/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;

public class Directories {
    public static List<String> reduceFullNameToLastDirectory(List<String> dirList) {
        ArrayList<String> shortList = new ArrayList<String>(dirList.size());
        for (String name : dirList) {
            Path pathName = Paths.get(name, new String[0]);
            shortList.add(pathName.getName(pathName.getNameCount() - 1).toString());
        }
        Collections.sort(shortList, String.CASE_INSENSITIVE_ORDER);
        return shortList;
    }

    public static HashSet<String> getDirectoriesWithFilesType(String rootDirectory, String filter) {
        HashSet<String> hSet = new HashSet<String>();
        try {
            Path rootPath = Paths.get(rootDirectory, new String[0]);
            if (Files.exists(rootPath, new LinkOption[0])) {
                Files.walk(rootPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().toLowerCase().endsWith(filter)).forEach(p -> hSet.add(p.toFile().getParent().toString()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hSet;
    }

    public static List<String> fetchSubDirectoriesMatchingFilter(String directory, String filter) {
        List<Path> subfolders = Directories.getAllSubPathsOfDirectory(directory, 1);
        if (subfolders == null) {
            return null;
        }
        List<String> dirList = Directories.getPathsContainingString(subfolders, filter);
        Collections.sort(dirList, String.CASE_INSENSITIVE_ORDER);
        return dirList;
    }

    public static List<String> getPathsContainingString(List<Path> subfolders, String filter) {
        if (subfolders == null) {
            return null;
        }
        HashSet<String> dirList = new HashSet<String>();
        for (Path dirPath : subfolders) {
            String subString = dirPath.toString();
            if (!subString.contains(filter)) continue;
            dirList.add(subString);
        }
        return new ArrayList<String>(dirList);
    }

    public static List<Path> getAllSubPathsOfDirectory(String directory, int depth) {
        Path pathExperimentDir = Paths.get(directory, new String[0]);
        List subfolders = null;
        try {
            if (Files.exists(pathExperimentDir, new LinkOption[0])) {
                subfolders = Files.walk(pathExperimentDir, depth, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (subfolders != null) {
            subfolders.remove(0);
        }
        return subfolders;
    }

    public static String getDirectoryFromName(String fileName) {
        File filepath = new File(fileName);
        String strDirectory = filepath.isDirectory() ? filepath.getAbsolutePath() : filepath.getParentFile().getAbsolutePath();
        return strDirectory;
    }

    public static List<String> getSortedListOfSubDirectoriesWithTIFF(String parentDirectory) {
        HashSet<String> hSet = Directories.getDirectoriesWithFilesType(parentDirectory, ".tiff");
        List<String> list = Directories.reduceFullNameToLastDirectory(new ArrayList<String>(hSet));
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int number2;
                if (s1.equalsIgnoreCase(s2)) {
                    return 0;
                }
                String tokens1 = s1.substring(4, s1.length());
                String tokens2 = s2.substring(4, s2.length());
                if (!Directories.isInteger(tokens1) || !Directories.isInteger(tokens2)) {
                    return tokens1.compareToIgnoreCase(tokens2);
                }
                int number1 = Integer.parseInt(tokens1);
                if (number1 != (number2 = Integer.parseInt(tokens2))) {
                    return number1 - number2;
                }
                return tokens1.compareToIgnoreCase(tokens2);
            }
        });
        return list;
    }

    public static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void deleteFilesWithExtension(String directory, String filter) {
        File folder = new File(directory);
        for (File file : folder.listFiles()) {
            String name = file.getName();
            if (!name.toLowerCase().endsWith(filter)) continue;
            file.delete();
        }
    }

    public static void move_TIFFfiles_To_Subdirectory(String directoryStr, String subname) {
        File directoryFile = new File(directoryStr);
        String subdirectoryStr = directoryStr + File.separator + subname;
        File subDirectoryFile = new File(subdirectoryStr);
        if (!subDirectoryFile.exists()) {
            subDirectoryFile.mkdir();
        }
        for (File file : directoryFile.listFiles()) {
            String name = file.getName();
            if (!name.toLowerCase().endsWith(".tiff") || !name.toLowerCase().startsWith("line")) continue;
            String destinationName = Capillary.replace_LR_with_12(name);
            file.renameTo(new File(subDirectoryFile + File.separator + destinationName));
            file.delete();
        }
    }

    public static void move_xmlLINEfiles_To_Subdirectory(String directoryStr, String subname, boolean clipName) {
        File directoryFile = new File(directoryStr);
        String subdirectoryStr = directoryStr + File.separator + subname;
        File subDirectoryFile = new File(subdirectoryStr);
        if (!subDirectoryFile.exists()) {
            subDirectoryFile.mkdir();
        }
        for (File file : directoryFile.listFiles()) {
            String name = file.getName();
            if (!name.toLowerCase().endsWith(".xml") && !name.toLowerCase().startsWith("line")) continue;
            String destinationName = Capillary.replace_LR_with_12(name);
            if (clipName) {
                destinationName = destinationName.substring(0, 6) + ".xml";
            }
            file.renameTo(new File(subDirectoryFile + File.separator + destinationName));
            file.delete();
        }
    }
}

