/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.ImageTransform.Transforms;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import java.awt.Dimension;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;

public class ChessboardImage
extends EzPlug
implements Block {
    private EzVarSequence seq1;
    private EzVarSequence seq2;
    private EzVarInteger squareSize;
    private EzVarSequence seqResult;

    protected void initialize() {
        this.seq1 = new EzVarSequence("Sequence 1");
        this.seq2 = new EzVarSequence("Sequence 2");
        this.squareSize = new EzVarInteger("Size of partition square (pixels)");
        this.addEzComponent((EzComponent)this.seq1);
        this.addEzComponent((EzComponent)this.seq2);
        this.addEzComponent((EzComponent)this.squareSize);
    }

    public void declareInput(VarList inputMap) {
        this.seq1 = new EzVarSequence("Sequence 1");
        this.seq2 = new EzVarSequence("Sequence 2");
        this.squareSize = new EzVarInteger("Size of partition square (pixels)");
        inputMap.add(this.seq1.name, (Var)this.seq1.getVariable());
        inputMap.add(this.seq2.name, (Var)this.seq2.getVariable());
        inputMap.add(this.squareSize.name, this.squareSize.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.seqResult = new EzVarSequence("Result image");
        outputMap.add(this.seqResult.name, (Var)this.seqResult.getVariable());
    }

    protected void execute() {
        Sequence s1 = (Sequence)this.seq1.getValue(true);
        Sequence s2 = (Sequence)this.seq2.getValue(true);
        int sSize = (Integer)this.squareSize.getValue();
        Sequence result = ChessboardImage.createChessboardImage(s1, s2, sSize);
        if (this.isHeadLess()) {
            this.seqResult.setValue(result);
        } else {
            this.addSequence(result);
        }
    }

    public void clean() {
    }

    public static Sequence createChessboardImage(Sequence s1, Sequence s2, int squareSize) {
        IcyBufferedImage s1Image = s1.getFirstImage();
        IcyBufferedImage s2Image = s2.getFirstImage();
        Dimension resultDim = new Dimension(Math.max(s1Image.getWidth(), s2Image.getWidth()), Math.max(s1Image.getHeight(), s2Image.getHeight()));
        IcyBufferedImage resultImage = new IcyBufferedImage(resultDim.width, resultDim.height, s1Image.getSizeC(), s1Image.getDataType_());
        resultImage.beginUpdate();
        for (int ch = 0; ch < resultImage.getSizeC(); ++ch) {
            double[] resultData = Array1DUtil.arrayToDoubleArray((Object)resultImage.getDataXY(ch), (boolean)resultImage.isSignedDataType());
            double[] s1Data = Array1DUtil.arrayToDoubleArray((Object)s1Image.getDataXY(ch), (boolean)resultImage.isSignedDataType());
            double[] s2Data = Array1DUtil.arrayToDoubleArray((Object)s2Image.getDataXY(ch), (boolean)resultImage.isSignedDataType());
            for (int j = 0; j < resultImage.getHeight(); ++j) {
                int jResultOffset = j * resultImage.getWidth();
                int js1Offset = j * s1Image.getWidth();
                int js2Offset = j * s2Image.getWidth();
                for (int i = 0; i < resultImage.getWidth(); ++i) {
                    boolean showS1;
                    boolean bl = showS1 = (i / squareSize % 2 + j / squareSize % 2) % 2 == 0;
                    if (showS1) {
                        if (i < s1Image.getWidth() && j < s1Image.getHeight()) {
                            resultData[jResultOffset + i] = s1Data[js1Offset + i];
                            continue;
                        }
                        resultData[jResultOffset + i] = 0.0;
                        continue;
                    }
                    resultData[jResultOffset + i] = i < s2Image.getWidth() && j < s2Image.getHeight() ? s2Data[js2Offset + i] : 0.0;
                }
            }
            Array1DUtil.doubleArrayToArray((double[])resultData, (Object)resultImage.getDataXY(ch));
        }
        resultImage.endUpdate();
        Sequence result = new Sequence("Chessboard(" + s1.getName() + s2.getName() + ")", resultImage);
        return result;
    }
}

