/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.ImageTransform.Transforms;

import icy.image.IcyBufferedImage;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformFunctionAbstract;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformOptions;

public class LinearCombinationNormed
extends ImageTransformFunctionAbstract
implements ImageTransformInterface {
    double w0 = 1.0;
    double w1 = 1.0;
    double w2 = 1.0;

    public LinearCombinationNormed(double w0, double w1, double w2) {
        this.w0 = w0;
        this.w1 = w1;
        this.w2 = w2;
    }

    @Override
    public IcyBufferedImage getTransformedImage(IcyBufferedImage sourceImage, ImageTransformOptions options) {
        return this.functionRGBtoLinearCombination(sourceImage);
    }

    protected IcyBufferedImage functionRGBtoLinearCombination(IcyBufferedImage sourceImage) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 3, sourceImage.getDataType_());
        double[] Rn = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        double[] Gn = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(1), (boolean)sourceImage.isSignedDataType());
        double[] Bn = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(2), (boolean)sourceImage.isSignedDataType());
        double[] ExG = (double[])Array1DUtil.createArray((DataType)DataType.DOUBLE, (int)Rn.length);
        for (int i = 0; i < Rn.length; ++i) {
            double sum = Rn[i] / 255.0 + Gn[i] / 255.0 + Bn[i] / 255.0;
            ExG[i] = (Rn[i] * this.w0 / 255.0 / sum + Gn[i] * this.w1 / 255.0 / sum + Bn[i] * this.w2 / 255.0 / sum) * 255.0;
        }
        this.copyExGDoubleToIcyBufferedImage(ExG, img2);
        return img2;
    }
}

