/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.ImageTransform.Transforms;

import icy.image.IcyBufferedImage;
import icy.type.collection.array.Array1DUtil;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformFunctionAbstract;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformOptions;

public class XDiffn
extends ImageTransformFunctionAbstract
implements ImageTransformInterface {
    int spanDiff = 5;

    public XDiffn(int spanDiff) {
        this.spanDiff = spanDiff;
    }

    @Override
    public IcyBufferedImage getTransformedImage(IcyBufferedImage sourceImage, ImageTransformOptions options) {
        int chan0 = 0;
        int chan1 = sourceImage.getSizeC();
        int imageSizeX = sourceImage.getSizeX();
        int imageSizeY = sourceImage.getSizeY();
        IcyBufferedImage img2 = new IcyBufferedImage(imageSizeX, imageSizeY, chan1 - chan0, sourceImage.getDataType_());
        for (int c = chan0; c < chan1; ++c) {
            int[] tabValues = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(c), (boolean)sourceImage.isSignedDataType());
            int[] outValues = Array1DUtil.arrayToIntArray((Object)img2.getDataXY(c), (boolean)img2.isSignedDataType());
            for (int iy = 0; iy < imageSizeY; ++iy) {
                for (int ix = 0; ix < this.spanDiff; ++ix) {
                    outValues[ix + iy * imageSizeX] = 0;
                }
                int deltay = iy * imageSizeX;
                for (int ix = this.spanDiff; ix < imageSizeX - this.spanDiff; ++ix) {
                    int kx = ix + deltay;
                    int deltax = 0;
                    double outVal = 0.0;
                    for (int ispan = 1; ispan < this.spanDiff; ++ispan) {
                        outVal += (double)(tabValues[kx + ++deltax] - tabValues[kx - deltax]);
                    }
                    outValues[kx] = (int)outVal > 0 ? (int)outVal : 0;
                }
            }
            Array1DUtil.intArrayToSafeArray((int[])outValues, (Object)img2.getDataXY(c), (boolean)true, (boolean)img2.isSignedDataType());
            img2.setDataXY(c, img2.getDataXY(c));
        }
        return img2;
    }
}

