/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.JComponents;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.capillaries.Capillaries;
import plugins.fmp.multicafe.tools.JComponents.ExperimentsJComboBox;

public class CapillariesWithTimeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private ExperimentsJComboBox expList = null;
    private final String[] columnNames = new String[]{"Starting at frame", "End frame"};
    private ArrayList<Long[]> intervals = null;

    public CapillariesWithTimeTableModel(ExperimentsJComboBox expList) {
        this.expList = expList;
    }

    @Override
    public int getRowCount() {
        if (this.expList != null && this.expList.getSelectedIndex() >= 0) {
            Capillaries capillaries = this.getCapillariesOfSelectedExperiment();
            this.intervals = capillaries.getKymoIntervalsFromCapillaries().intervals;
            return this.intervals.size();
        }
        return 0;
    }

    private Capillaries getCapillariesOfSelectedExperiment() {
        Experiment exp = (Experiment)this.expList.getSelectedItem();
        return exp.capillaries;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Integer.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Long[] interval = this.intervals.get(rowIndex);
        return interval[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Long[] interval = this.intervals.get(rowIndex);
        interval[columnIndex] = (long)((Long)aValue);
    }
}

