/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.toExcel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.fmp.multicafe.tools.toExcel.XLSResultsArray;

public class XLSResults {
    public String name = null;
    public String stimulus = null;
    public String concentration = null;
    int nadded = 1;
    boolean[] padded_out = null;
    public int dimension = 0;
    public int nflies = 1;
    public int cageID = 0;
    public EnumXLSExport exportType = null;
    public ArrayList<Integer> dataInt = null;
    public double[] valuesOut = null;

    public XLSResults(String name, int nflies, int cellID, EnumXLSExport exportType) {
        this.name = name;
        this.nflies = nflies;
        this.cageID = cellID;
        this.exportType = exportType;
    }

    public XLSResults(String name, int nflies, int cellID, EnumXLSExport exportType, int nFrames) {
        this.name = name;
        this.nflies = nflies;
        this.cageID = cellID;
        this.exportType = exportType;
        this.initValuesArray(nFrames);
    }

    void initValuesOutArray(int dimension, Double val) {
        this.dimension = dimension;
        this.valuesOut = new double[dimension];
        Arrays.fill(this.valuesOut, val);
    }

    private void initValuesArray(int dimension) {
        this.dimension = dimension;
        this.valuesOut = new double[dimension];
        Arrays.fill(this.valuesOut, Double.NaN);
        this.padded_out = new boolean[dimension];
        Arrays.fill(this.padded_out, false);
    }

    void clearValues(int fromindex) {
        int toindex = this.valuesOut.length;
        if (fromindex > 0 && fromindex < toindex) {
            Arrays.fill(this.valuesOut, fromindex, toindex, Double.NaN);
            Arrays.fill(this.padded_out, fromindex, toindex, false);
        }
    }

    void clearAll() {
        this.dataInt = null;
        this.valuesOut = null;
        this.nflies = 0;
    }

    public void transferDataIntToValuesOut(double scalingFactorToPhysicalUnits, EnumXLSExport xlsExport) {
        if (this.dimension == 0 || this.dataInt == null || this.dataInt.size() < 1) {
            return;
        }
        boolean removeZeros = false;
        if (xlsExport == EnumXLSExport.AMPLITUDEGULPS) {
            removeZeros = true;
        }
        int len = Math.min(this.dimension, this.dataInt.size());
        if (removeZeros) {
            for (int i = 0; i < len; ++i) {
                int ivalue = this.dataInt.get(i);
                this.valuesOut[i] = (ivalue == 0 ? Double.NaN : (double)ivalue) * scalingFactorToPhysicalUnits;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.valuesOut[i] = (double)this.dataInt.get(i).intValue() * scalingFactorToPhysicalUnits;
            }
        }
    }

    public void copyValuesOut(XLSResults sourceRow) {
        if (sourceRow.valuesOut.length != this.valuesOut.length) {
            this.dimension = sourceRow.dimension;
            this.valuesOut = new double[this.dimension];
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.valuesOut[i] = sourceRow.valuesOut[i];
        }
    }

    public List<Integer> subtractT0() {
        if (this.dataInt == null || this.dataInt.size() < 1) {
            return null;
        }
        int valueAtT0 = this.dataInt.get(0);
        for (int index = 0; index < this.dataInt.size(); ++index) {
            int value = this.dataInt.get(index);
            this.dataInt.set(index, value - valueAtT0);
        }
        return this.dataInt;
    }

    boolean subtractDeltaT(int arrayStep, int binStep) {
        if (this.valuesOut == null || this.valuesOut.length < 2) {
            return false;
        }
        for (int index = 0; index < this.valuesOut.length; ++index) {
            int timeIndex = index * arrayStep + binStep;
            int indexDelta = timeIndex / arrayStep;
            this.valuesOut[index] = indexDelta < this.valuesOut.length ? this.valuesOut[indexDelta] - this.valuesOut[index] : Double.NaN;
        }
        return true;
    }

    void addDataToValOutEvap(XLSResults result) {
        if (result.valuesOut.length > this.valuesOut.length) {
            System.out.println("XLSResults:addDataToValOutEvap() Error: from len=" + result.valuesOut.length + " to len=" + this.valuesOut.length);
            return;
        }
        for (int i = 0; i < result.valuesOut.length; ++i) {
            int n = i;
            this.valuesOut[n] = this.valuesOut[n] + result.valuesOut[i];
        }
        ++this.nflies;
    }

    void averageEvaporation() {
        if (this.nflies == 0) {
            return;
        }
        for (int i = 0; i < this.valuesOut.length; ++i) {
            this.valuesOut[i] = this.valuesOut[i] / (double)this.nflies;
        }
        this.nflies = 1;
    }

    void subtractEvap(XLSResults evap) {
        if (this.valuesOut == null) {
            return;
        }
        int len = Math.min(this.valuesOut.length, evap.valuesOut.length);
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.valuesOut[n] = this.valuesOut[n] - evap.valuesOut[i];
        }
    }

    void sumValues_out(XLSResults dataToAdd) {
        int len = Math.min(this.valuesOut.length, dataToAdd.valuesOut.length);
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.valuesOut[n] = this.valuesOut[n] + dataToAdd.valuesOut[i];
        }
        ++this.nadded;
    }

    public double padWithLastPreviousValue(long to_first_index) {
        double dvalue = 0.0;
        if (to_first_index >= (long)this.valuesOut.length) {
            return dvalue;
        }
        int index = this.getIndexOfFirstNonEmptyValueBackwards(to_first_index);
        if (index >= 0) {
            dvalue = this.valuesOut[index];
            int i = index + 1;
            while ((long)i < to_first_index) {
                this.valuesOut[i] = dvalue;
                this.padded_out[i] = true;
                ++i;
            }
        }
        return dvalue;
    }

    private int getIndexOfFirstNonEmptyValueBackwards(long fromindex) {
        int ifrom;
        int index = -1;
        for (int i = ifrom = (int)fromindex; i >= 0; --i) {
            if (Double.isNaN(this.valuesOut[i])) continue;
            index = i;
            break;
        }
        return index;
    }

    public static XLSResults getResultsArrayWithThatName(String testname, XLSResultsArray resultsArrayList) {
        XLSResults resultsFound = null;
        for (XLSResults results : resultsArrayList.resultsList) {
            if (!results.name.equals(testname)) continue;
            resultsFound = results;
            break;
        }
        return resultsFound;
    }
}

