/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.viewer1D;

import java.awt.geom.Point2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import plugins.fmp.multicafe.viewer1D.Pannable;

public class PannableXYPlot
extends XYPlot
implements Pannable {
    private static final long serialVersionUID = 5058105183885427900L;
    private boolean domainPannable = true;
    private boolean rangePannable = true;

    public PannableXYPlot() {
    }

    public PannableXYPlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer) {
        super(dataset, domainAxis, rangeAxis, renderer);
    }

    @Override
    public boolean isDomainPannable() {
        return this.domainPannable;
    }

    public void setDomainPannable(boolean pannable) {
        this.domainPannable = pannable;
    }

    @Override
    public boolean isRangePannable() {
        return this.rangePannable;
    }

    public void setRangePannable(boolean pannable) {
        this.rangePannable = pannable;
    }

    @Override
    public void panRangeAxis(double panRange, PlotRenderingInfo info, Point2D source) {
        double fullRange = this.getOrientation() == PlotOrientation.HORIZONTAL ? info.getDataArea().getWidth() : info.getDataArea().getHeight();
        for (int i = 0; i < this.getRangeAxisCount(); ++i) {
            ValueAxis rangeAxis = this.getRangeAxis(i);
            double rangeMove = fullRange != 0.0 ? Math.abs(rangeAxis.getLowerBound() - rangeAxis.getUpperBound()) * panRange / fullRange : 0.0;
            rangeAxis.setRange(rangeAxis.getLowerBound() + rangeMove, rangeAxis.getUpperBound() + rangeMove);
        }
    }

    @Override
    public void panDomainAxis(double panRange, PlotRenderingInfo info, Point2D source) {
        double fullRange = this.getOrientation() == PlotOrientation.HORIZONTAL ? info.getDataArea().getHeight() : info.getDataArea().getWidth();
        for (int i = 0; i < this.getDomainAxisCount(); ++i) {
            ValueAxis domainAxis = this.getDomainAxis(i);
            double rangeMove = fullRange != 0.0 ? Math.abs(domainAxis.getLowerBound() - domainAxis.getUpperBound()) * panRange / fullRange : 0.0;
            domainAxis.setRange(domainAxis.getLowerBound() + rangeMove, domainAxis.getUpperBound() + rangeMove);
        }
    }

    @Override
    public void panDomainAxisByAxisRelation(double panRangePercent, PlotRenderingInfo info, Point2D source) {
        double fullRange = this.getOrientation() == PlotOrientation.HORIZONTAL ? info.getDataArea().getWidth() : info.getDataArea().getHeight();
        double panRange = fullRange * panRangePercent;
        this.panDomainAxis(panRange, info, source);
    }

    @Override
    public void panRangeAxisByAxisRelation(double panRangePercent, PlotRenderingInfo info, Point2D source) {
        double fullRange = this.getOrientation() == PlotOrientation.HORIZONTAL ? info.getDataArea().getWidth() : info.getDataArea().getHeight();
        double panRange = fullRange * panRangePercent;
        this.panRangeAxis(panRange, info, source);
    }
}

