/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.capillaries;

import icy.gui.util.FontUtil;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;

public class LoadSaveCapillaries
extends JPanel {
    private static final long serialVersionUID = -4019075448319252245L;
    private JButton openButtonCapillaries = new JButton("Load...");
    private JButton saveButtonCapillaries = new JButton("Save...");
    private MultiCAFE parent0 = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        JLabel loadsaveText = new JLabel("-> Capillaries (xml) ", 4);
        loadsaveText.setFont(FontUtil.setStyle((Font)loadsaveText.getFont(), (int)2));
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(loadsaveText);
        panel1.add(this.openButtonCapillaries);
        panel1.add(this.saveButtonCapillaries);
        panel1.validate();
        this.add(panel1);
        this.parent0 = parent0;
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.openButtonCapillaries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveCapillaries)LoadSaveCapillaries.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveCapillaries.this.loadCapillaries_File(exp);
                    LoadSaveCapillaries.this.firePropertyChange("CAP_ROIS_OPEN", false, true);
                }
            }
        });
        this.saveButtonCapillaries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveCapillaries)LoadSaveCapillaries.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveCapillaries.this.saveCapillaries_file(exp);
                    LoadSaveCapillaries.this.firePropertyChange("CAP_ROIS_SAVE", false, true);
                }
            }
        });
    }

    public boolean loadCapillaries_File(Experiment exp) {
        boolean flag = exp.loadMCCapillaries_Only();
        exp.capillaries.transferCapillaryRoiToSequence(exp.seqCamData.seq);
        return flag;
    }

    public boolean saveCapillaries_file(Experiment exp) {
        this.parent0.paneCapillaries.getDialogCapillariesInfos(exp);
        this.parent0.paneExperiment.getExperimentInfosFromDialog(exp);
        exp.capillaries.transferDescriptionToCapillaries();
        exp.xmlSave_MCExperiment();
        exp.capillaries.updateCapillariesFromSequence(exp.seqCamData.seq);
        return exp.saveMCCapillaries_Only();
    }
}

