/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.experiment;

import icy.canvas.IcyCanvas;
import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.main.Icy;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.dlg.experiment.Edit;
import plugins.fmp.multicafe.dlg.experiment.Filter;
import plugins.fmp.multicafe.dlg.experiment.Infos;
import plugins.fmp.multicafe.dlg.experiment.Intervals;
import plugins.fmp.multicafe.dlg.experiment.Options;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.tools.ViewerFMP;

public class MCExperiment_
extends JPanel
implements ViewerListener,
ChangeListener {
    private static final long serialVersionUID = -6826269677524125173L;
    PopupPanel capPopupPanel = null;
    public JTabbedPane tabsPane = new JTabbedPane();
    public Options tabOptions = new Options();
    public Infos tabInfos = new Infos();
    public Filter tabFilter = new Filter();
    public Edit tabEdit = new Edit();
    public Intervals tabIntervals = new Intervals();
    private MultiCAFE parent0 = null;

    public void init(JPanel mainPanel, String string, final MultiCAFE parent0) {
        this.parent0 = parent0;
        this.capPopupPanel = new PopupPanel(string);
        this.capPopupPanel.collapse();
        mainPanel.add((Component)this.capPopupPanel);
        GridLayout tabsLayout = new GridLayout(4, 1);
        this.tabInfos.init(tabsLayout, parent0);
        this.tabsPane.addTab("Infos", null, this.tabInfos, "Define infos for this experiment/box");
        this.tabFilter.init(tabsLayout, parent0);
        this.tabsPane.addTab("Filter", null, this.tabFilter, "Filter experiments based on descriptors");
        this.tabEdit.init(tabsLayout, parent0);
        this.tabsPane.addTab("Edit", null, this.tabEdit, "Edit descriptors");
        this.tabIntervals.init(tabsLayout, parent0);
        this.tabsPane.addTab("Intervals", null, this.tabIntervals, "View/edit time-lapse intervals");
        this.tabOptions.init(tabsLayout, parent0);
        this.tabsPane.addTab("Options", null, this.tabOptions, "Options to display data");
        this.tabsPane.setTabLayoutPolicy(1);
        JPanel capPanel = this.capPopupPanel.getMainPanel();
        capPanel.setLayout(new BorderLayout());
        capPanel.add((Component)this.tabsPane, "Last");
        this.tabsPane.addChangeListener(this);
        this.capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                parent0.mainFrame.revalidate();
                parent0.mainFrame.pack();
                parent0.mainFrame.repaint();
            }
        });
    }

    public void updateDialogs(Experiment exp) {
        this.tabIntervals.displayCamDataIntervals(exp);
        this.tabInfos.transferPreviousExperimentInfosToDialog(exp, exp);
        this.parent0.paneKymos.tabDisplay.updateResultsAvailable(exp);
    }

    public void getExperimentInfosFromDialog(Experiment exp) {
        this.tabInfos.getExperimentInfosFromDialog(exp);
    }

    public void updateViewerForSequenceCam(final Experiment exp) {
        final Sequence seq = exp.seqCamData.seq;
        if (seq == null) {
            return;
        }
        final MCExperiment_ parent = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerFMP v = (ViewerFMP)seq.getFirstViewer();
                if (v == null) {
                    v = new ViewerFMP(exp.seqCamData.seq, true, true);
                    List list = IcyCanvas.getCanvasPluginNames();
                    String pluginName = list.stream().filter(s -> s.contains("Canvas2DWithTransforms")).findFirst().orElse(null);
                    v.setCanvas(pluginName);
                }
                if (v != null) {
                    MCExperiment_.this.placeViewerNextToDialogBox(v, ((MCExperiment_)MCExperiment_.this).parent0.mainFrame);
                    v.toFront();
                    v.requestFocus();
                    v.addListener(parent);
                    v.setTitle(exp.seqCamData.getDecoratedImageName(0));
                    v.setRepeat(false);
                }
            }
        });
    }

    private void placeViewerNextToDialogBox(Viewer v, IcyFrame mainFrame) {
        Rectangle rectv = v.getBoundsInternal();
        Rectangle rect0 = mainFrame.getBoundsInternal();
        if (rect0.x + rect0.width < Icy.getMainInterface().getMainFrame().getDesktopWidth()) {
            rectv.setLocation(rect0.x + rect0.width, rect0.y);
            v.setBounds(rectv);
        }
    }

    public void viewerChanged(ViewerEvent event) {
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED && event.getDim() == DimensionId.T) {
            int idCurrentExp;
            Viewer v = event.getSource();
            int idViewer = v.getSequence().getId();
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null && idViewer == (idCurrentExp = exp.seqCamData.seq.getId())) {
                int t = v.getPositionT();
                v.setTitle(exp.seqCamData.getDecoratedImageName(t));
                if (this.parent0.paneCages.bTrapROIsEdit) {
                    exp.saveDetRoisToPositions();
                }
                exp.updateROIsAt(t);
            }
        }
    }

    public void viewerClosed(Viewer viewer) {
        viewer.removeListener((ViewerListener)this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
        if (tabbedPane.getSelectedIndex() == 0) {
            this.tabInfos.initInfosCombos();
        } else if (tabbedPane.getSelectedIndex() == 1) {
            this.tabFilter.initFilterCombos();
        } else if (tabbedPane.getSelectedIndex() == 2) {
            this.tabEdit.initEditCombos();
        }
    }
}

