/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.kymos;

import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.series.BuildKymographs;
import plugins.fmp.multicafe.series.BuildSeriesOptions;
import plugins.fmp.multicafe.tools.EnumStatusComputation;
import plugins.fmp.multicafe.tools.JComponents.JComboMs;

public class Create
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1771360416354320887L;
    private String detectString = "Start";
    JButton startComputationButton = new JButton("Start");
    JSpinner diskRadiusSpinner = new JSpinner(new SpinnerNumberModel(3, 1, 100, 1));
    JCheckBox concurrentDisplayCheckBox = new JCheckBox("concurrent display", false);
    JCheckBox allSeriesCheckBox = new JCheckBox("ALL series (current to last)", false);
    JSpinner binSize = new JSpinner(new SpinnerNumberModel(1.0, 1.0, 1000.0, 1.0));
    JComboMs binUnit = new JComboMs();
    JRadioButton isFloatingFrameButton = new JRadioButton("all", true);
    JRadioButton isFixedFrameButton = new JRadioButton("from ", false);
    JSpinner startJSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 10000.0, 1.0));
    JSpinner endJSpinner = new JSpinner(new SpinnerNumberModel(240.0, 1.0, 9.9999999E7, 1.0));
    JComboMs intervalsUnit = new JComboMs();
    EnumStatusComputation sComputation = EnumStatusComputation.START_COMPUTATION;
    private MultiCAFE parent0 = null;
    private BuildKymographs threadBuildKymo = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel0 = new JPanel(layoutLeft);
        ((FlowLayout)panel0.getLayout()).setVgap(1);
        panel0.add(this.startComputationButton);
        panel0.add(this.allSeriesCheckBox);
        panel0.add(this.concurrentDisplayCheckBox);
        this.add(panel0);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(new JLabel("area around ROIs", 4));
        panel2.add(this.diskRadiusSpinner);
        panel2.add(new JLabel("bin size "));
        panel2.add(this.binSize);
        panel2.add(this.binUnit);
        this.add(panel2);
        this.binUnit.setSelectedIndex(2);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(new JLabel("Analyze "));
        panel1.add(this.isFloatingFrameButton);
        panel1.add(this.isFixedFrameButton);
        panel1.add(this.startJSpinner);
        panel1.add(new JLabel(" to "));
        panel1.add(this.endJSpinner);
        panel1.add(this.intervalsUnit);
        this.intervalsUnit.setSelectedIndex(2);
        this.add(panel1);
        this.enableIntervalButtons(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.isFloatingFrameButton);
        group.add(this.isFixedFrameButton);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.startComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Create.this.startComputationButton.getText().equals(Create.this.detectString)) {
                    Create.this.startComputation();
                } else {
                    Create.this.stopComputation();
                }
            }
        });
        this.allSeriesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (Create.this.allSeriesCheckBox.isSelected()) {
                    color = Color.RED;
                }
                Create.this.allSeriesCheckBox.setForeground(color);
                Create.this.startComputationButton.setForeground(color);
            }
        });
        this.isFixedFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Create.this.enableIntervalButtons(true);
            }
        });
        this.isFloatingFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Create.this.enableIntervalButtons(false);
            }
        });
    }

    private void enableIntervalButtons(boolean isSelected) {
        this.startJSpinner.setEnabled(isSelected);
        this.endJSpinner.setEnabled(isSelected);
        this.intervalsUnit.setEnabled(isSelected);
    }

    private BuildSeriesOptions initBuildParameters() {
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allSeriesCheckBox.isSelected() ? this.parent0.expListCombo.getItemCount() - 1 : options.expList.index0;
        options.isFrameFixed = this.getIsFixedFrame();
        options.t_Ms_First = this.getStartMs();
        options.t_Ms_Last = this.getEndMs();
        options.t_Ms_BinDuration = (long)((Double)this.binSize.getValue() * (double)this.binUnit.getMsUnitValue());
        options.diskRadius = (Integer)this.diskRadiusSpinner.getValue();
        options.doRegistration = false;
        options.referenceFrame = 0;
        options.concurrentDisplay = this.concurrentDisplayCheckBox.isSelected();
        options.doCreateBinDir = true;
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.binSubDirectory = "bin_" + options.t_Ms_BinDuration / 1000L;
        return options;
    }

    private void startComputation() {
        this.sComputation = EnumStatusComputation.STOP_COMPUTATION;
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.parent0.paneCapillaries.tabFile.saveCapillaries_file(exp);
        }
        this.threadBuildKymo = new BuildKymographs();
        this.threadBuildKymo.options = this.initBuildParameters();
        this.threadBuildKymo.addPropertyChangeListener(this);
        this.threadBuildKymo.execute();
        this.startComputationButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.threadBuildKymo != null && !this.threadBuildKymo.stopFlag) {
            this.threadBuildKymo.stopFlag = true;
        }
    }

    boolean getIsFixedFrame() {
        return this.isFixedFrameButton.isSelected();
    }

    long getStartMs() {
        return (long)((Double)this.startJSpinner.getValue() * (double)this.binUnit.getMsUnitValue());
    }

    long getEndMs() {
        return (long)((Double)this.endJSpinner.getValue() * (double)this.binUnit.getMsUnitValue());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.startComputationButton.setText(this.detectString);
        }
    }
}

