/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.levels;

import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.series.BuildSeriesOptions;
import plugins.fmp.multicafe.series.DetectGulps;
import plugins.fmp.multicafe.tools.Canvas2D.Canvas2DWithTransforms;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformEnums;

public class LevelsToGulps
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -5590697762090397890L;
    JCheckBox allKymosCheckBox = new JCheckBox("all kymographs", true);
    ImageTransformEnums[] gulpTransforms = new ImageTransformEnums[]{ImageTransformEnums.XDIFFN, ImageTransformEnums.YDIFFN, ImageTransformEnums.YDIFFN1D, ImageTransformEnums.XYDIFFN};
    JComboBox<ImageTransformEnums> gulpTransforms_comboBox = new JComboBox<ImageTransformEnums>(this.gulpTransforms);
    JSpinner start_spinner = new JSpinner(new SpinnerNumberModel(0, 0, 100000, 1));
    JSpinner end_spinner = new JSpinner(new SpinnerNumberModel(3, 1, 100000, 1));
    JCheckBox derivative_checkbox = new JCheckBox("derivative", true);
    JCheckBox gulps_checkbox = new JCheckBox("gulps", true);
    private JCheckBox from_pixel_checkbox = new JCheckBox("from (pixel)", false);
    private JToggleButton display_button = new JToggleButton("Display");
    private JSpinner spanTransf2Spinner = new JSpinner(new SpinnerNumberModel(3, 0, 500, 1));
    private JSpinner detectGulpsThresholdSpinner = new JSpinner(new SpinnerNumberModel(0.5, 0.0, 500.0, 0.1));
    private String detectString = "        Detect     ";
    private JButton detectButton = new JButton(this.detectString);
    private JCheckBox all_checkbox = new JCheckBox("ALL (current to last)", false);
    private DetectGulps threadDetectGulps = null;
    private MultiCAFE parent0 = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        layoutLeft.setVgap(0);
        JPanel panel0 = new JPanel(layoutLeft);
        panel0.add(this.detectButton);
        panel0.add(this.all_checkbox);
        panel0.add(this.allKymosCheckBox);
        panel0.add(this.derivative_checkbox);
        panel0.add(this.gulps_checkbox);
        this.add(panel0);
        JPanel panel01 = new JPanel(layoutLeft);
        panel01.add(new JLabel("threshold", 4));
        panel01.add(this.detectGulpsThresholdSpinner);
        panel01.add(this.gulpTransforms_comboBox);
        panel01.add(this.display_button);
        this.add(panel01);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.from_pixel_checkbox);
        panel1.add(this.start_spinner);
        panel1.add(new JLabel("to"));
        panel1.add(this.end_spinner);
        this.add(panel1);
        this.gulpTransforms_comboBox.setSelectedItem((Object)ImageTransformEnums.XDIFFN);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.gulpTransforms_comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LevelsToGulps)LevelsToGulps.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqCamData != null) {
                    int index = LevelsToGulps.this.gulpTransforms_comboBox.getSelectedIndex();
                    LevelsToGulps.this.getKymosCanvas((Experiment)exp).transformsCombo1.setSelectedIndex(index + 1);
                }
            }
        });
        this.detectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LevelsToGulps.this.detectButton.getText().equals(LevelsToGulps.this.detectString)) {
                    LevelsToGulps.this.startComputation(true);
                } else {
                    LevelsToGulps.this.stopComputation();
                }
            }
        });
        this.display_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LevelsToGulps)LevelsToGulps.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqCamData != null) {
                    if (LevelsToGulps.this.display_button.isSelected()) {
                        Canvas2DWithTransforms canvas = LevelsToGulps.this.getKymosCanvas(exp);
                        canvas.updateTransformsComboStep1(LevelsToGulps.this.gulpTransforms);
                        int index = LevelsToGulps.this.gulpTransforms_comboBox.getSelectedIndex();
                        canvas.selectIndexStep1(index + 1, null);
                    } else {
                        LevelsToGulps.this.getKymosCanvas((Experiment)exp).transformsCombo1.setSelectedIndex(0);
                    }
                }
            }
        });
        this.all_checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (LevelsToGulps.this.all_checkbox.isSelected()) {
                    color = Color.RED;
                }
                LevelsToGulps.this.all_checkbox.setForeground(color);
                LevelsToGulps.this.detectButton.setForeground(color);
            }
        });
    }

    private BuildSeriesOptions initBuildParameters(Experiment exp) {
        BuildSeriesOptions options = this.threadDetectGulps.options;
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.all_checkbox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.detectAllKymos = this.allKymosCheckBox.isSelected();
        if (!this.allKymosCheckBox.isSelected()) {
            int t;
            options.kymoFirst = t = exp.seqKymos.seq.getFirstViewer().getPositionT();
            options.kymoLast = t;
        } else {
            options.kymoFirst = 0;
            options.kymoLast = exp.seqKymos.seq.getSizeT() - 1;
        }
        options.detectGulpsThreshold_uL = (Double)this.detectGulpsThresholdSpinner.getValue();
        options.transformForGulps = (ImageTransformEnums)((Object)this.gulpTransforms_comboBox.getSelectedItem());
        options.detectAllGulps = this.allKymosCheckBox.isSelected();
        options.spanDiff = (Integer)this.spanTransf2Spinner.getValue();
        options.buildGulps = this.gulps_checkbox.isSelected();
        options.buildDerivative = this.derivative_checkbox.isSelected();
        options.analyzePartOnly = this.from_pixel_checkbox.isSelected();
        options.searchArea.x = (Integer)this.start_spinner.getValue();
        options.searchArea.width = (Integer)this.end_spinner.getValue() + (Integer)this.start_spinner.getValue();
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.binSubDirectory = exp.getBinSubDirectory();
        return options;
    }

    void startComputation(boolean bDetectGulps) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            exp.saveCapillariesMeasures(exp.getKymosBinFullDirectory());
            this.threadDetectGulps = new DetectGulps();
            this.threadDetectGulps.options = this.initBuildParameters(exp);
            if (!bDetectGulps) {
                this.threadDetectGulps.options.buildGulps = false;
            }
            this.threadDetectGulps.addPropertyChangeListener(this);
            this.threadDetectGulps.execute();
            this.detectButton.setText("STOP");
        }
    }

    void setInfos(Capillary cap) {
        BuildSeriesOptions options = cap.getGulpsOptions();
        this.detectGulpsThresholdSpinner.setValue(options.detectGulpsThreshold_uL);
        this.gulpTransforms_comboBox.setSelectedItem((Object)options.transformForGulps);
        this.allKymosCheckBox.setSelected(options.detectAllGulps);
    }

    private void stopComputation() {
        if (this.threadDetectGulps != null && !this.threadDetectGulps.stopFlag) {
            this.threadDetectGulps.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.detectButton.setText(this.detectString);
            this.parent0.paneKymos.tabDisplay.selectKymographImage(this.parent0.paneKymos.tabDisplay.indexImagesCombo);
            this.parent0.paneKymos.tabDisplay.indexImagesCombo = -1;
            this.start_spinner.setValue(this.threadDetectGulps.options.searchArea.x);
            this.end_spinner.setValue(this.threadDetectGulps.options.searchArea.width + this.threadDetectGulps.options.searchArea.x);
        }
    }

    protected Canvas2DWithTransforms getKymosCanvas(Experiment exp) {
        Canvas2DWithTransforms canvas = (Canvas2DWithTransforms)exp.seqKymos.seq.getFirstViewer().getCanvas();
        return canvas;
    }
}

