/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileNameTimePattern {
    public DateFormat dateFormat = null;
    public String patternString = null;
    public Pattern patternCompiled = null;
    long timeFirstImageInMs = 0L;

    FileNameTimePattern(String dateFormatString, String patternString) {
        this.dateFormat = new SimpleDateFormat(dateFormatString);
        this.patternString = patternString;
        this.patternCompiled = Pattern.compile(patternString);
    }

    public FileNameTimePattern() {
    }

    long getTimeFromString(String fileName, int t) {
        if (this.dateFormat == null) {
            return this.getDummyTime(t);
        }
        long timeInMs = 0L;
        Matcher m = this.patternCompiled.matcher(fileName);
        if (m.find()) {
            try {
                Date date = this.dateFormat.parse(m.group(0));
                timeInMs = date.getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("FileNamePatterns:getTimeFromString() Error parsing filename: " + fileName);
                timeInMs = this.getDummyTime(t);
            }
        } else {
            System.out.println("FileNamePatterns:getTimeFromString() Error finding time in filename: " + fileName);
            timeInMs = this.getDummyTime(t);
        }
        return timeInMs;
    }

    public boolean findMatch(String fileName) {
        Matcher m = this.patternCompiled.matcher(fileName);
        return m.find();
    }

    public long getDummyTime(int t) {
        if (this.timeFirstImageInMs == 0L) {
            this.timeFirstImageInMs = System.currentTimeMillis();
        }
        return this.timeFirstImageInMs + (long)(t * 60 * 1000);
    }
}

