/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment.cages;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.util.XMLUtil;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceCamData;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.experiment.cages.EnumCageMeasures;
import plugins.fmp.multicafe.experiment.cages.FlyPositions;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.Comparators;
import plugins.fmp.multicafe.tools.JComponents.Dialog;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Cages {
    public ArrayList<Cage> cageList = new ArrayList();
    public long detectFirst_Ms = 0L;
    public long detectLast_Ms = 0L;
    public long detectBin_Ms = 60000L;
    public int detect_threshold = 0;
    public int detect_nframes = 0;
    private final String ID_CAGES = "Cages";
    private final String ID_NCAGES = "n_cages";
    private final String ID_DROSOTRACK = "drosoTrack";
    private final String ID_NBITEMS = "nb_items";
    private final String ID_CAGELIMITS = "Cage_Limits";
    private final String ID_FLYDETECTED = "Fly_Detected";
    private static final String ID_MCDROSOTRACK_XML = "MCdrosotrack.xml";
    final String csvSep = ";";

    public boolean load_Cages(String directory) {
        boolean flag = false;
        try {
            flag = this.csvLoad_CageBox(directory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!flag) {
            String tempName = directory + File.separator + ID_MCDROSOTRACK_XML;
            Document doc = XMLUtil.loadDocument((String)tempName);
            if (doc == null) {
                return false;
            }
            flag = this.xmlLoadCages(doc);
        }
        return flag;
    }

    public boolean save_Cages(String directory) {
        if (directory == null) {
            return false;
        }
        this.csvSave_Cages(directory);
        return true;
    }

    public void clearAllMeasures(int option_detectCage) {
        for (Cage cage : this.cageList) {
            int cageIndex = cage.getCageID();
            if (option_detectCage >= 0 && option_detectCage != cageIndex) continue;
            cage.clearMeasures();
        }
    }

    public void clearCageList() {
        this.cageList.clear();
    }

    public void mergeLists(Cages cagem) {
        for (Cage inputCagem : cagem.cageList) {
            if (this.isPresent(inputCagem)) continue;
            this.cageList.add(inputCagem);
        }
    }

    private boolean csvLoad_CageBox(String directory) throws Exception {
        String row;
        String pathToCsv = directory + File.separator + "CagesMeasures.csv";
        File csvFile = new File(pathToCsv);
        if (!csvFile.isFile()) {
            return false;
        }
        BufferedReader csvReader = new BufferedReader(new FileReader(pathToCsv));
        String sep = ";";
        while ((row = csvReader.readLine()) != null) {
            String[] data;
            if (row.charAt(0) == '#') {
                sep = String.valueOf(row.charAt(1));
            }
            if (!(data = row.split(sep))[0].equals("#")) continue;
            switch (data[1]) {
                case "DESCRIPTION": {
                    this.csvLoad_DESCRIPTION(csvReader, sep);
                    break;
                }
                case "CAGE": {
                    this.csvLoad_CageBox(csvReader, sep);
                    break;
                }
                case "POSITION": {
                    this.csvLoad_Measures(csvReader, EnumCageMeasures.POSITION, sep);
                    break;
                }
            }
        }
        csvReader.close();
        return true;
    }

    private String csvLoad_DESCRIPTION(BufferedReader csvReader, String sep) {
        try {
            String row;
            while ((row = csvReader.readLine()) != null) {
                String[] data = row.split(sep);
                if (data[0].equals("#")) {
                    return data[1];
                }
                String test = data[0].substring(0, Math.min(data[0].length(), 7));
                if (!test.equals("n cages") && !test.equals("n cells")) continue;
                int ncages = Integer.valueOf(data[1]);
                if (ncages >= this.cageList.size()) {
                    this.cageList.ensureCapacity(ncages);
                    continue;
                }
                this.cageList.subList(ncages, this.cageList.size()).clear();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String csvLoad_CageBox(BufferedReader csvReader, String sep) {
        try {
            String row = csvReader.readLine();
            while ((row = csvReader.readLine()) != null) {
                String[] data = row.split(sep);
                if (data[0].equals("#")) {
                    return data[1];
                }
                int cageID = 0;
                try {
                    cageID = Integer.valueOf(data[0]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid integer input: " + data[0]);
                }
                Cage cage = this.getCageFromID(cageID);
                if (cage == null) {
                    cage = new Cage();
                    this.cageList.add(cage);
                }
                cage.csvImport_CAGE_Header(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String csvLoad_Measures(BufferedReader csvReader, EnumCageMeasures measureType, String sep) {
        try {
            String row = csvReader.readLine();
            boolean complete = row.contains("w(i)");
            boolean v0 = row.contains("x(i)");
            while ((row = csvReader.readLine()) != null) {
                String[] data = row.split(sep);
                if (data[0].equals("#")) {
                    return data[1];
                }
                int cageID = -1;
                try {
                    cageID = Integer.valueOf(data[0]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid integer input: " + data[0]);
                }
                Cage cage = this.getCageFromID(cageID);
                if (cage == null) {
                    cage = new Cage();
                }
                if (v0) {
                    cage.csvImport_MEASURE_Data_v0(measureType, data, complete);
                    continue;
                }
                cage.csvImport_MEASURE_Data_Parameters(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean csvSave_Cages(String directory) {
        Path path = Paths.get(directory, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try {
            FileWriter csvWriter = new FileWriter(directory + File.separator + "CagesMeasures.csv");
            this.csvSave_Description(csvWriter);
            this.csvSave_Measures(csvWriter, EnumCageMeasures.POSITION);
            csvWriter.flush();
            csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSave_Description(FileWriter csvWriter) {
        try {
            csvWriter.append("#;DESCRIPTION\n");
            csvWriter.append("n cages=;" + Integer.toString(this.cageList.size()) + "\n");
            csvWriter.append("#;#\n");
            if (this.cageList.size() > 0) {
                csvWriter.append(this.cageList.get(0).csvExport_CAGE_Header(";"));
                for (Cage cage : this.cageList) {
                    csvWriter.append(cage.csvExport_CAGE_Data(";"));
                }
                csvWriter.append("#;#\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSave_Measures(FileWriter csvWriter, EnumCageMeasures measureType) {
        try {
            if (this.cageList.size() <= 1) {
                return false;
            }
            boolean complete = true;
            csvWriter.append(this.cageList.get(0).csvExport_MEASURE_Header(measureType, ";", complete));
            for (Cage cage : this.cageList) {
                csvWriter.append(cage.csvExport_MEASURE_Data(measureType, ";", complete));
            }
            csvWriter.append("#;#\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean xmlWriteCagesToFileNoQuestion(String tempname) {
        if (tempname == null) {
            return false;
        }
        Document doc = XMLUtil.createDocument((boolean)true);
        if (doc == null) {
            return false;
        }
        Element node = XMLUtil.addElement((Node)XMLUtil.getRootElement((Document)doc), (String)"drosoTrack");
        if (node == null) {
            return false;
        }
        int index = 0;
        Element xmlVal = XMLUtil.addElement((Node)node, (String)"Cages");
        int nCages = this.cageList.size();
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"n_cages", (int)nCages);
        for (Cage cage : this.cageList) {
            cage.xmlSaveCagel(xmlVal, index);
            ++index;
        }
        return XMLUtil.saveDocument((Document)doc, (String)tempname);
    }

    public boolean xmlReadCagesFromFile(Experiment exp) {
        String[] filedummy = null;
        String filename = exp.getExperimentDirectory();
        File file = new File(filename);
        String directory = file.getParentFile().getAbsolutePath();
        filedummy = Dialog.selectFiles(directory, "xml");
        boolean wasOk = false;
        if (filedummy != null) {
            for (int i = 0; i < filedummy.length; ++i) {
                String csFile = filedummy[i];
                wasOk &= this.xmlReadCagesFromFileNoQuestion(csFile, exp);
            }
        }
        return wasOk;
    }

    public boolean xmlReadCagesFromFileNoQuestion(String tempname, Experiment exp) {
        if (tempname == null) {
            return false;
        }
        Document doc = XMLUtil.loadDocument((String)tempname);
        if (doc == null) {
            return false;
        }
        boolean flag = this.xmlLoadCages(doc);
        if (!flag) {
            System.out.println("Cages:xmlReadCageFromFileNoQuestion() failed to load cages from file");
            return false;
        }
        this.cagesToROIs(exp.seqCamData);
        return true;
    }

    private boolean xmlLoadCages(Document doc) {
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)"drosoTrack");
        if (node == null) {
            return false;
        }
        this.cageList.clear();
        Element xmlVal = XMLUtil.getElement((Node)node, (String)"Cages");
        if (xmlVal != null) {
            int nCages = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"n_cages", (int)0);
            for (int index = 0; index < nCages; ++index) {
                Cage cage = new Cage();
                cage.xmlLoadCage(xmlVal, index);
                this.cageList.add(cage);
            }
        } else {
            ArrayList<ROI2D> cageLimitROIList = new ArrayList<ROI2D>();
            if (this.xmlLoadCageLimits_v0(node, cageLimitROIList)) {
                ArrayList<FlyPositions> flyPositionsList = new ArrayList<FlyPositions>();
                this.xmlLoadFlyPositions_v0(node, flyPositionsList);
                this.transferDataToCageBox_v0(cageLimitROIList, flyPositionsList);
            } else {
                return false;
            }
        }
        return true;
    }

    public void copy(Cages cagesArray) {
        this.cageList.clear();
        for (Cage cageSource : cagesArray.cageList) {
            Cage cageDestination = new Cage();
            cageDestination.copyCage(cageSource);
            this.cageList.add(cageDestination);
        }
    }

    private void transferDataToCageBox_v0(List<ROI2D> cageLimitROIList, List<FlyPositions> flyPositionsList) {
        this.cageList.clear();
        Collections.sort(cageLimitROIList, new Comparators.ROI2D_Name_Comparator());
        int nCages = cageLimitROIList.size();
        for (int index = 0; index < nCages; ++index) {
            Cage cage = new Cage();
            cage.cageRoi2D = cageLimitROIList.get(index);
            cage.flyPositions = flyPositionsList.get(index);
            this.cageList.add(cage);
        }
    }

    private boolean xmlLoadCageLimits_v0(Node node, List<ROI2D> cageLimitROIList) {
        if (node == null) {
            return false;
        }
        Element xmlVal = XMLUtil.getElement((Node)node, (String)"Cage_Limits");
        if (xmlVal == null) {
            return false;
        }
        cageLimitROIList.clear();
        int nb_items = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"nb_items", (int)0);
        for (int i = 0; i < nb_items; ++i) {
            ROI2DPolygon roi = (ROI2DPolygon)ROI.create((String)"plugins.kernel.roi.roi2d.ROI2DPolygon");
            Element subnode = XMLUtil.getElement((Node)xmlVal, (String)("cage" + i));
            roi.loadFromXML((Node)subnode);
            cageLimitROIList.add((ROI2D)roi);
        }
        return true;
    }

    private boolean xmlLoadFlyPositions_v0(Node node, List<FlyPositions> flyPositionsList) {
        if (node == null) {
            return false;
        }
        Element xmlVal = XMLUtil.getElement((Node)node, (String)"Fly_Detected");
        if (xmlVal == null) {
            return false;
        }
        flyPositionsList.clear();
        int nb_items = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"nb_items", (int)0);
        int ielement = 0;
        for (int i = 0; i < nb_items; ++i) {
            Element subnode = XMLUtil.getElement((Node)xmlVal, (String)("cage" + ielement));
            FlyPositions pos = new FlyPositions();
            pos.xmlLoadXYTPositions(subnode);
            flyPositionsList.add(pos);
            ++ielement;
        }
        return true;
    }

    private boolean isPresent(Cage cageNew) {
        boolean flag = false;
        for (Cage cage : this.cageList) {
            if (!cage.cageRoi2D.getName().contentEquals(cageNew.cageRoi2D.getName())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void addMissingCages(List<ROI2D> roiList) {
        for (ROI2D roi : roiList) {
            boolean found = false;
            if (roi.getName() == null) break;
            for (Cage cage : this.cageList) {
                if (cage.cageRoi2D == null) break;
                if (!roi.getName().equals(cage.cageRoi2D.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Cage cage = new Cage();
            cage.cageRoi2D = roi;
            this.cageList.add(cage);
        }
    }

    private void removeOrphanCages(List<ROI2D> roiList) {
        Iterator<Cage> iterator = this.cageList.iterator();
        while (iterator.hasNext()) {
            Cage cage = iterator.next();
            boolean found = false;
            if (cage.cageRoi2D != null) {
                String cageRoiName = cage.cageRoi2D.getName();
                for (ROI2D roi : roiList) {
                    if (!roi.getName().equals(cageRoiName)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            iterator.remove();
        }
    }

    private List<ROI2D> getRoisWithCageName(SequenceCamData seqCamData) {
        ArrayList roiList = seqCamData.seq.getROI2Ds();
        ArrayList<ROI2D> cageList = new ArrayList<ROI2D>();
        for (ROI2D roi : roiList) {
            String csName = roi.getName();
            if (!(roi instanceof ROI2DPolygon) && !(roi instanceof ROI2DArea) || (csName.length() <= 4 || !csName.substring(0, 4).contains("cage") && !csName.substring(0, 4).contains("cell")) && !csName.contains("Polygon2D")) continue;
            cageList.add(roi);
        }
        return cageList;
    }

    public void cagesToROIs(SequenceCamData seqCamData) {
        List<ROI2D> cageLimitROIList = this.getRoisWithCageName(seqCamData);
        seqCamData.seq.removeROIs(cageLimitROIList, false);
        for (Cage cage : this.cageList) {
            cageLimitROIList.add(cage.cageRoi2D);
        }
        seqCamData.seq.addROIs(cageLimitROIList, true);
    }

    public void cagesFromROIs(SequenceCamData seqCamData) {
        List<ROI2D> roiList = this.getRoisWithCageName(seqCamData);
        if (roiList.size() > 0) {
            Collections.sort(roiList, new Comparators.ROI2D_Name_Comparator());
            this.addMissingCages(roiList);
            this.removeOrphanCages(roiList);
            Collections.sort(this.cageList, new Comparators.Cage_Name_Comparator());
        }
    }

    public void setFirstAndLastCageToZeroFly() {
        for (Cage cage : this.cageList) {
            if (!cage.cageRoi2D.getName().contains("000") && !cage.cageRoi2D.getName().contains("009")) continue;
            cage.cageNFlies = 0;
        }
    }

    public void removeAllRoiDetFromSequence(SequenceCamData seqCamData) {
        ArrayList seqlist = seqCamData.seq.getROI2Ds();
        for (ROI2D roi : seqlist) {
            if (!(roi instanceof ROI2DShape) || !roi.getName().contains("det")) continue;
            seqCamData.seq.removeROI((ROI)roi);
        }
    }

    public void transferNFliesFromCapillariesToCageBox(List<Capillary> capList) {
        block0: for (Cage cage : this.cageList) {
            int cagenb = cage.getCageID();
            for (Capillary cap : capList) {
                if (cap.capCageID != cagenb) continue;
                cage.cageNFlies = cap.capNFlies;
                continue block0;
            }
        }
    }

    public void transferNFliesFromCagesToCapillaries(List<Capillary> capList) {
        for (Cage cage : this.cageList) {
            int cageIndex = cage.getCageID();
            for (Capillary cap : capList) {
                if (cap.capCageID != cageIndex) continue;
                cap.capNFlies = cage.cageNFlies;
            }
        }
    }

    public void setCageNbFromName(List<Capillary> capList) {
        for (Capillary cap : capList) {
            int cageIndex;
            cap.capCageID = cageIndex = cap.getCageIndexFromRoiName();
        }
    }

    public Cage getCageFromID(int number) {
        Cage cageFound = null;
        for (Cage cage : this.cageList) {
            if (number != cage.getCageID()) continue;
            cageFound = cage;
            break;
        }
        return cageFound;
    }

    public List<ROI2D> getPositionsAsListOfROI2DRectanglesAtT(int t) {
        ArrayList<ROI2D> roiRectangleList = new ArrayList<ROI2D>(this.cageList.size());
        for (Cage cage : this.cageList) {
            ROI2DRectangle roiRectangle = cage.getRoiRectangleFromPositionAtT(t);
            if (roiRectangle == null) continue;
            roiRectangleList.add((ROI2D)roiRectangle);
        }
        return roiRectangleList;
    }

    public void orderFlyPositions() {
        for (Cage cage : this.cageList) {
            Collections.sort(cage.flyPositions.flyPositionList, new Comparators.XYTaValue_Tindex_Comparator());
        }
    }

    public void initFlyPositions(int option_cagenumber) {
        int nCages = this.cageList.size();
        for (int i = 0; i < nCages; ++i) {
            Cage cage = this.cageList.get(i);
            if (option_cagenumber != -1 && cage.getCageID() != option_cagenumber || cage.cageNFlies <= 0) continue;
            cage.flyPositions = new FlyPositions();
            cage.flyPositions.ensureCapacity(this.detect_nframes);
        }
    }

    public void initCagesTmsForFlyPositions(long[] intervalsMs) {
        for (Cage cage : this.cageList) {
            cage.initTmsForFlyPositions(intervalsMs);
        }
    }

    public void computeBooleanMasksForCages() {
        for (Cage cage : this.cageList) {
            try {
                cage.computeCageBooleanMask2D();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int getLastIntervalFlyAlive(int cagenumber) {
        int flypos = -1;
        for (Cage cage : this.cageList) {
            String cageNumberString = cage.cageRoi2D.getName().substring(4);
            if (Integer.valueOf(cageNumberString) != cagenumber) continue;
            flypos = cage.flyPositions.getLastIntervalAlive();
            break;
        }
        return flypos;
    }

    public boolean isFlyAlive(int cagenumber) {
        boolean isalive = false;
        for (Cage cage : this.cageList) {
            String cageNumberString = cage.cageRoi2D.getName().substring(4);
            if (Integer.valueOf(cageNumberString) != cagenumber) continue;
            isalive = cage.flyPositions.getLastIntervalAlive() > 0;
            break;
        }
        return isalive;
    }

    public boolean isDataAvailable(int cagenumber) {
        boolean isavailable = false;
        for (Cage cage : this.cageList) {
            String cageNumberString = cage.cageRoi2D.getName().substring(4);
            if (Integer.valueOf(cageNumberString) != cagenumber) continue;
            isavailable = true;
            break;
        }
        return isavailable;
    }

    public int getHorizontalSpanOfCages() {
        int leftPixel = -1;
        int rightPixel = -1;
        for (Cage cage : this.cageList) {
            ROI2D roiCage = cage.cageRoi2D;
            Rectangle2D rect = roiCage.getBounds2D();
            int left = (int)rect.getX();
            int right = left + (int)rect.getWidth();
            if (leftPixel < 0 || left < leftPixel) {
                leftPixel = left;
            }
            if (right <= rightPixel) continue;
            rightPixel = right;
        }
        return rightPixel - leftPixel;
    }
}

