/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment.capillaries;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import plugins.fmp.multicafe.experiment.KymoIntervals;
import plugins.fmp.multicafe.experiment.capillaries.CapillariesDescription;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.experiment.capillaries.EnumCapillaryMeasures;
import plugins.fmp.multicafe.tools.Comparators;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DAlongT;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Capillaries {
    public CapillariesDescription capillariesDescription = new CapillariesDescription();
    public CapillariesDescription desc_old = new CapillariesDescription();
    public ArrayList<Capillary> capillariesList = new ArrayList();
    private KymoIntervals capillariesListTimeIntervals = null;
    private static final String ID_CAPILLARYTRACK = "capillaryTrack";
    private static final String ID_NCAPILLARIES = "N_capillaries";
    private static final String ID_LISTOFCAPILLARIES = "List_of_capillaries";
    private static final String ID_CAPILLARY_ = "capillary_";
    private static final String ID_MCCAPILLARIES_XML = "MCcapillaries.xml";
    final String csvSep = ";";

    public boolean load_Capillaries(String directory) {
        boolean flag = false;
        try {
            flag = this.csvLoad_Capillaries(directory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!flag) {
            flag = this.xmlLoadCapillaries_Measures(directory);
        }
        return flag;
    }

    public boolean save_Capillaries(String directory) {
        if (directory == null) {
            return false;
        }
        this.csvSave_Capillaries(directory);
        return true;
    }

    public String getXMLNameToAppend() {
        return ID_MCCAPILLARIES_XML;
    }

    public boolean xmlSaveCapillaries_Descriptors(String csFileName) {
        Document doc;
        if (csFileName != null && (doc = XMLUtil.createDocument((boolean)true)) != null) {
            this.capillariesDescription.xmlSaveCapillaryDescription(doc);
            this.xmlSaveListOfCapillaries(doc);
            return XMLUtil.saveDocument((Document)doc, (String)csFileName);
        }
        return false;
    }

    private boolean xmlSaveListOfCapillaries(Document doc) {
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_CAPILLARYTRACK);
        if (node == null) {
            return false;
        }
        XMLUtil.setElementIntValue((Node)node, (String)"version", (int)2);
        Element nodecaps = XMLUtil.setElement((Node)node, (String)ID_LISTOFCAPILLARIES);
        XMLUtil.setElementIntValue((Node)nodecaps, (String)ID_NCAPILLARIES, (int)this.capillariesList.size());
        int i = 0;
        Collections.sort(this.capillariesList);
        for (Capillary cap : this.capillariesList) {
            Element nodecapillary = XMLUtil.setElement((Node)node, (String)(ID_CAPILLARY_ + i));
            cap.xmlSave_CapillaryOnly(nodecapillary);
            ++i;
        }
        return true;
    }

    public boolean loadMCCapillaries_Descriptors(String csFileName) {
        boolean flag = false;
        if (csFileName == null) {
            return flag;
        }
        Document doc = XMLUtil.loadDocument((String)csFileName);
        if (doc != null) {
            this.capillariesDescription.xmlLoadCapillaryDescription(doc);
            flag = this.xmlLoadCapillaries_Only_v1(doc);
        }
        return flag;
    }

    public boolean xmlLoadOldCapillaries_Only(String csFileName) {
        if (csFileName == null) {
            return false;
        }
        Document doc = XMLUtil.loadDocument((String)csFileName);
        if (doc != null) {
            this.capillariesDescription.xmlLoadCapillaryDescription(doc);
            switch (this.capillariesDescription.version) {
                case 1: {
                    this.xmlLoadCapillaries_Only_v1(doc);
                    break;
                }
                case 0: {
                    this.xmlLoadCapillaries_v0(doc, csFileName);
                    break;
                }
                default: {
                    this.xmlLoadCapillaries_Only_v2(doc, csFileName);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean xmlLoadCapillaries_Measures(String directory) {
        boolean flag = false;
        int ncapillaries = this.capillariesList.size();
        int i = 0;
        while (i < ncapillaries) {
            String csFile = directory + File.separator + this.capillariesList.get(i).getKymographName() + ".xml";
            Document capdoc = XMLUtil.loadDocument((String)csFile);
            Element node = XMLUtil.getRootElement((Document)capdoc, (boolean)true);
            Capillary cap = this.capillariesList.get(i);
            cap.kymographIndex = i++;
            flag |= cap.xmlLoad_MeasuresOnly(node);
        }
        return flag;
    }

    private void xmlLoadCapillaries_v0(Document doc, String csFileName) {
        List listOfCapillaryROIs = ROI.loadROIsFromXML((Node)XMLUtil.getRootElement((Document)doc));
        this.capillariesList.clear();
        Path directorypath = Paths.get(csFileName, new String[0]).getParent();
        String directory = directorypath + File.separator;
        int t = 0;
        for (ROI roiCapillary : listOfCapillaryROIs) {
            this.xmlLoadIndividualCapillary_v0((ROI2D)((ROI2DShape)roiCapillary), directory, t);
            ++t;
        }
    }

    private void xmlLoadIndividualCapillary_v0(ROI2D roiCapillary, String directory, int t) {
        NodeList nodeROISingle;
        Capillary cap = new Capillary(roiCapillary);
        if (!this.isPresent(cap)) {
            this.capillariesList.add(cap);
        }
        String csFile = directory + roiCapillary.getName() + ".xml";
        cap.kymographIndex = t;
        Document dockymo = XMLUtil.loadDocument((String)csFile);
        if (dockymo != null && (nodeROISingle = dockymo.getElementsByTagName("roi")).getLength() > 0) {
            ArrayList<ROI> rois = new ArrayList<ROI>();
            for (int i = 0; i < nodeROISingle.getLength(); ++i) {
                Node element = nodeROISingle.item(i);
                ROI roi_i = ROI.createFromXML((Node)element);
                if (roi_i == null) continue;
                rois.add(roi_i);
            }
            cap.transferROIsToMeasures(rois);
        }
    }

    private boolean xmlLoadCapillaries_Only_v1(Document doc) {
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_CAPILLARYTRACK);
        if (node == null) {
            return false;
        }
        Element nodecaps = XMLUtil.getElement((Node)node, (String)ID_LISTOFCAPILLARIES);
        int nitems = XMLUtil.getElementIntValue((Node)nodecaps, (String)ID_NCAPILLARIES, (int)0);
        this.capillariesList = new ArrayList(nitems);
        for (int i = 0; i < nitems; ++i) {
            Element nodecapillary = XMLUtil.getElement((Node)node, (String)(ID_CAPILLARY_ + i));
            Capillary cap = new Capillary();
            cap.xmlLoad_CapillaryOnly(nodecapillary);
            if (this.isPresent(cap)) continue;
            this.capillariesList.add(cap);
        }
        return true;
    }

    private void xmlLoadCapillaries_Only_v2(Document doc, String csFileName) {
        this.xmlLoadCapillaries_Only_v1(doc);
        Path directorypath = Paths.get(csFileName, new String[0]).getParent();
        String directory = directorypath + File.separator;
        for (Capillary cap : this.capillariesList) {
            String csFile = directory + cap.getKymographName() + ".xml";
            Document capdoc = XMLUtil.loadDocument((String)csFile);
            Element node = XMLUtil.getRootElement((Document)capdoc, (boolean)true);
            cap.xmlLoad_CapillaryOnly(node);
        }
    }

    public void copy(Capillaries cap) {
        this.capillariesDescription.copy(cap.capillariesDescription);
        this.capillariesList.clear();
        for (Capillary ccap : cap.capillariesList) {
            if (ccap == null || ccap.getRoi() == null) continue;
            Capillary capi = new Capillary();
            capi.copy(ccap);
            this.capillariesList.add(capi);
        }
    }

    public boolean isPresent(Capillary capNew) {
        boolean flag = false;
        for (Capillary cap : this.capillariesList) {
            if (!cap.getKymographName().contentEquals(capNew.getKymographName())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void mergeLists(Capillaries caplist) {
        for (Capillary capm : caplist.capillariesList) {
            if (this.isPresent(capm)) continue;
            this.capillariesList.add(capm);
        }
    }

    public void adjustToImageWidth(int imageWidth) {
        for (Capillary cap : this.capillariesList) {
            cap.adjustToImageWidth(imageWidth);
        }
    }

    public void cropToImageWidth(int imageWidth) {
        for (Capillary cap : this.capillariesList) {
            cap.cropToImageWidth(imageWidth);
        }
    }

    public void transferDescriptionToCapillaries() {
        for (Capillary cap : this.capillariesList) {
            this.transferCapGroupCageIDToCapillary(cap);
            cap.setVolumeAndPixels(this.capillariesDescription.volume, this.capillariesDescription.pixels);
        }
    }

    private void transferCapGroupCageIDToCapillary(Capillary cap) {
        String nameL;
        Capillary cap0;
        String letter;
        if (this.capillariesDescription.grouping != 2) {
            return;
        }
        String name = cap.getRoiName();
        cap.capSide = letter = name.substring(name.length() - 1);
        if (letter.equals("R") && (cap0 = this.getCapillaryFromRoiName(nameL = name.substring(0, name.length() - 1) + "L")) != null) {
            cap.capCageID = cap0.capCageID;
        }
    }

    public Capillary getCapillaryFromRoiName(String name) {
        Capillary capFound = null;
        for (Capillary cap : this.capillariesList) {
            if (!cap.getRoiName().equals(name)) continue;
            capFound = cap;
            break;
        }
        return capFound;
    }

    public Capillary getCapillaryFromKymographName(String name) {
        Capillary capFound = null;
        for (Capillary cap : this.capillariesList) {
            if (!cap.getKymographName().equals(name)) continue;
            capFound = cap;
            break;
        }
        return capFound;
    }

    public Capillary getCapillaryFromRoiNamePrefix(String name) {
        Capillary capFound = null;
        for (Capillary cap : this.capillariesList) {
            if (!cap.getRoiNamePrefix().equals(name)) continue;
            capFound = cap;
            break;
        }
        return capFound;
    }

    public void updateCapillariesFromSequence(Sequence seq) {
        List<ROI2D> listROISCap = ROI2DUtilities.getROIs2DContainingString("line", seq);
        Collections.sort(listROISCap, new Comparators.ROI2D_Name_Comparator());
        block0: for (Capillary cap : this.capillariesList) {
            cap.valid = false;
            String capName = Capillary.replace_LR_with_12(cap.getRoiName());
            Iterator<ROI2D> iterator = listROISCap.iterator();
            while (iterator.hasNext()) {
                ROI2D roi = iterator.next();
                String roiName = Capillary.replace_LR_with_12(roi.getName());
                if (roiName.equals(capName)) {
                    cap.setRoi((ROI2D)((ROI2DShape)roi));
                    cap.valid = true;
                }
                if (!cap.valid) continue;
                iterator.remove();
                continue block0;
            }
        }
        Iterator<Capillary> iterator = this.capillariesList.iterator();
        while (iterator.hasNext()) {
            Capillary cap;
            cap = iterator.next();
            if (cap.valid) continue;
            iterator.remove();
        }
        if (listROISCap.size() > 0) {
            for (ROI2D roi : listROISCap) {
                Capillary cap = new Capillary((ROI2D)((ROI2DShape)roi));
                if (this.isPresent(cap)) continue;
                this.capillariesList.add(cap);
            }
        }
        Collections.sort(this.capillariesList);
    }

    public void transferCapillaryRoiToSequence(Sequence seq) {
        seq.removeAllROI();
        for (Capillary cap : this.capillariesList) {
            seq.addROI((ROI)cap.getRoi());
        }
    }

    public void initCapillariesWith10Cages(int nflies, boolean optionZeroFlyFirstLastCapillary) {
        int capArraySize = this.capillariesList.size();
        for (int i = 0; i < capArraySize; ++i) {
            Capillary cap = this.capillariesList.get(i);
            cap.capNFlies = nflies;
            if (optionZeroFlyFirstLastCapillary && (i <= 1 || i >= capArraySize - 2)) {
                cap.capNFlies = 0;
            }
            cap.capCageID = i / 2;
        }
    }

    public void initCapillariesWith6Cages(int nflies) {
        int capArraySize = this.capillariesList.size();
        for (int i = 0; i < capArraySize; ++i) {
            Capillary cap = this.capillariesList.get(i);
            cap.capNFlies = 1;
            if (i <= 1) {
                cap.capNFlies = 0;
                cap.capCageID = 0;
                continue;
            }
            if (i >= capArraySize - 2) {
                cap.capNFlies = 0;
                cap.capCageID = 5;
                continue;
            }
            cap.capNFlies = nflies;
            cap.capCageID = 1 + (i - 2) / 4;
        }
    }

    public KymoIntervals getKymoIntervalsFromCapillaries() {
        if (this.capillariesListTimeIntervals == null) {
            this.capillariesListTimeIntervals = new KymoIntervals();
            for (Capillary cap : this.capillariesList) {
                for (ROI2DAlongT roiFK : cap.getROIsForKymo()) {
                    Long[] interval = new Long[]{roiFK.getStart(), -1L};
                    this.capillariesListTimeIntervals.addIfNew(interval);
                }
            }
        }
        return this.capillariesListTimeIntervals;
    }

    public int addKymoROI2DInterval(long start) {
        Long[] interval = new Long[]{start, -1L};
        int item = this.capillariesListTimeIntervals.addIfNew(interval);
        for (Capillary cap : this.capillariesList) {
            List<ROI2DAlongT> listROI2DForKymo = cap.getROIsForKymo();
            ROI2D roi = cap.getRoi();
            if (item > 0) {
                roi = (ROI2D)listROI2DForKymo.get(item - 1).getRoi().getCopy();
            }
            listROI2DForKymo.add(item, new ROI2DAlongT(start, roi));
        }
        return item;
    }

    public void deleteKymoROI2DInterval(long start) {
        this.capillariesListTimeIntervals.deleteIntervalStartingAt(start);
        for (Capillary cap : this.capillariesList) {
            cap.removeROI2DIntervalStartingAt(start);
        }
    }

    public int findKymoROI2DIntervalStart(long intervalT) {
        return this.capillariesListTimeIntervals.findStartItem(intervalT);
    }

    public long getKymoROI2DIntervalsStartAt(int selectedItem) {
        return this.capillariesListTimeIntervals.get(selectedItem)[0];
    }

    public double getScalingFactorToPhysicalUnits(EnumXLSExport xlsoption) {
        double scalingFactorToPhysicalUnits;
        switch (xlsoption) {
            case NBGULPS: 
            case TTOGULP: 
            case TTOGULP_LR: 
            case AUTOCORREL: 
            case CROSSCORREL: 
            case CROSSCORREL_LR: {
                scalingFactorToPhysicalUnits = 1.0;
                break;
            }
            default: {
                scalingFactorToPhysicalUnits = this.capillariesDescription.volume / (double)this.capillariesDescription.pixels;
            }
        }
        return scalingFactorToPhysicalUnits;
    }

    public Polygon2D get2DPolygonEnclosingCapillaries() {
        Capillary cap0 = this.capillariesList.get(0);
        Point2D upperLeft = (Point2D)cap0.getCapillaryROIFirstPoint().clone();
        Point2D lowerLeft = (Point2D)cap0.getCapillaryROILastPoint().clone();
        Point2D upperRight = (Point2D)upperLeft.clone();
        Point2D lowerRight = (Point2D)lowerLeft.clone();
        for (Capillary cap : this.capillariesList) {
            Point2D capFirst = cap.getCapillaryROIFirstPoint();
            Point2D capLast = cap.getCapillaryROILastPoint();
            if (capFirst.getX() < upperLeft.getX()) {
                upperLeft.setLocation(capFirst.getX(), upperLeft.getY());
            }
            if (capFirst.getY() < upperLeft.getY()) {
                upperLeft.setLocation(upperLeft.getX(), capFirst.getY());
            }
            if (capLast.getX() < lowerLeft.getX()) {
                lowerLeft.setLocation(capLast.getX(), lowerLeft.getY());
            }
            if (capLast.getY() > lowerLeft.getY()) {
                lowerLeft.setLocation(lowerLeft.getX(), capLast.getY());
            }
            if (capFirst.getX() > upperRight.getX()) {
                upperRight.setLocation(capFirst.getX(), upperRight.getY());
            }
            if (capFirst.getY() < upperRight.getY()) {
                upperRight.setLocation(upperRight.getX(), capFirst.getY());
            }
            if (capLast.getX() > lowerRight.getX()) {
                lowerRight.setLocation(capLast.getX(), lowerRight.getY());
            }
            if (!(capLast.getY() > lowerRight.getY())) continue;
            lowerRight.setLocation(lowerRight.getX(), capLast.getY());
        }
        ArrayList<Point2D> listPoints = new ArrayList<Point2D>(4);
        listPoints.add(upperLeft);
        listPoints.add(lowerLeft);
        listPoints.add(lowerRight);
        listPoints.add(upperRight);
        return new Polygon2D(listPoints);
    }

    public void deleteAllCapillaries() {
        this.capillariesList.clear();
    }

    private boolean csvLoad_Capillaries(String directory) throws Exception {
        String row;
        String pathToCsv = directory + File.separator + "CapillariesMeasures.csv";
        File csvFile = new File(pathToCsv);
        if (!csvFile.isFile()) {
            return false;
        }
        BufferedReader csvReader = new BufferedReader(new FileReader(pathToCsv));
        String sep = ";";
        while ((row = csvReader.readLine()) != null) {
            String[] data;
            if (row.charAt(0) == '#') {
                sep = String.valueOf(row.charAt(1));
            }
            if (!(data = row.split(sep))[0].equals("#")) continue;
            switch (data[1]) {
                case "DESCRIPTION": {
                    this.csvLoad_Description(csvReader, sep);
                    break;
                }
                case "CAPILLARIES": {
                    this.csvLoad_Capillaries_Description(csvReader, sep);
                    break;
                }
                case "TOPLEVEL": {
                    this.csvLoad_Capillaries_Measures(csvReader, EnumCapillaryMeasures.TOPLEVEL, sep, row.contains("xi"));
                    break;
                }
                case "BOTTOMLEVEL": {
                    this.csvLoad_Capillaries_Measures(csvReader, EnumCapillaryMeasures.BOTTOMLEVEL, sep, row.contains("xi"));
                    break;
                }
                case "TOPDERIVATIVE": {
                    this.csvLoad_Capillaries_Measures(csvReader, EnumCapillaryMeasures.TOPDERIVATIVE, sep, row.contains("xi"));
                    break;
                }
                case "GULPS": {
                    this.csvLoad_Capillaries_Measures(csvReader, EnumCapillaryMeasures.GULPS, sep, true);
                    break;
                }
            }
        }
        csvReader.close();
        return true;
    }

    private String csvLoad_Capillaries_Description(BufferedReader csvReader, String sep) {
        try {
            String row = csvReader.readLine();
            while ((row = csvReader.readLine()) != null) {
                String[] data = row.split(sep);
                if (data[0].equals("#")) {
                    return data[1];
                }
                Capillary cap = this.getCapillaryFromKymographName(data[2]);
                if (cap == null) {
                    cap = new Capillary();
                    this.capillariesList.add(cap);
                }
                cap.csvImport_CapillaryDescription(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String csvLoad_Description(BufferedReader csvReader, String sep) {
        try {
            String row = csvReader.readLine();
            row = csvReader.readLine();
            String[] data = row.split(sep);
            this.capillariesDescription.csvImportCapillariesDescriptionData(data);
            row = csvReader.readLine();
            data = row.split(sep);
            if (data[0].substring(0, Math.min(data[0].length(), 5)).equals("n cap")) {
                int ncapillaries = Integer.valueOf(data[1]);
                if (ncapillaries >= this.capillariesList.size()) {
                    this.capillariesList.ensureCapacity(ncapillaries);
                } else {
                    this.capillariesList.subList(ncapillaries, this.capillariesList.size()).clear();
                }
                row = csvReader.readLine();
                data = row.split(sep);
            }
            if (data[0].equals("#")) {
                return data[1];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String csvLoad_Capillaries_Measures(BufferedReader csvReader, EnumCapillaryMeasures measureType, String sep, boolean x) {
        boolean y = true;
        try {
            String row;
            while ((row = csvReader.readLine()) != null) {
                String[] data = row.split(sep);
                if (data[0].equals("#")) {
                    return data[1];
                }
                Capillary cap = this.getCapillaryFromRoiNamePrefix(data[0]);
                if (cap == null) {
                    cap = new Capillary();
                }
                cap.csvImport_CapillaryData(measureType, data, x, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean csvSave_Capillaries(String directory) {
        Path path = Paths.get(directory, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try {
            FileWriter csvWriter = new FileWriter(directory + File.separator + "CapillariesMeasures.csv");
            this.csvSave_DescriptionSection(csvWriter);
            this.csvSave_MeasuresSection(csvWriter, EnumCapillaryMeasures.TOPLEVEL);
            this.csvSave_MeasuresSection(csvWriter, EnumCapillaryMeasures.BOTTOMLEVEL);
            this.csvSave_MeasuresSection(csvWriter, EnumCapillaryMeasures.TOPDERIVATIVE);
            this.csvSave_MeasuresSection(csvWriter, EnumCapillaryMeasures.GULPS);
            csvWriter.flush();
            csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSave_DescriptionSection(FileWriter csvWriter) {
        try {
            csvWriter.append(this.capillariesDescription.csvExportSectionHeader(";"));
            csvWriter.append(this.capillariesDescription.csvExportExperimentDescriptors(";"));
            csvWriter.append("n caps=;" + Integer.toString(this.capillariesList.size()) + "\n");
            csvWriter.append("#;#\n");
            if (this.capillariesList.size() > 0) {
                csvWriter.append(this.capillariesList.get(0).csvExport_CapillarySubSectionHeader(";"));
                for (Capillary cap : this.capillariesList) {
                    csvWriter.append(cap.csvExport_CapillaryDescription(";"));
                }
                csvWriter.append("#;#\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSave_MeasuresSection(FileWriter csvWriter, EnumCapillaryMeasures measureType) {
        try {
            if (this.capillariesList.size() <= 1) {
                return false;
            }
            csvWriter.append(this.capillariesList.get(0).csvExport_MeasureSectionHeader(measureType, ";"));
            for (Capillary cap : this.capillariesList) {
                csvWriter.append(cap.csvExport_MeasuresOneType(measureType, ";"));
            }
            csvWriter.append("#;#\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

