/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.series;

import icy.file.Saver;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import loci.formats.FormatException;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceCamData;
import plugins.fmp.multicafe.experiment.SequenceKymos;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.series.BuildSeries;
import plugins.fmp.multicafe.tools.Bresenham;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DAlongT;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DUtilities;

public class BuildKymographs
extends BuildSeries {
    public Sequence seqData = new Sequence();
    private Viewer vData = null;
    ArrayList<IcyBufferedImage> cap_bufKymoImage = null;
    int kymoImageWidth = 0;

    @Override
    void analyzeExperiment(Experiment exp) {
        this.loadExperimentDataToBuildKymos(exp);
        this.openKymoViewers(exp);
        this.getTimeLimitsOfSequence(exp);
        if (this.buildKymo(exp)) {
            this.saveComputation(exp);
        }
        this.closeKymoViewers();
        exp.seqKymos.closeSequence();
    }

    private boolean loadExperimentDataToBuildKymos(Experiment exp) {
        boolean flag = exp.loadMCCapillaries_Only();
        exp.seqCamData.seq = exp.seqCamData.initSequenceFromFirstImage(exp.seqCamData.getImagesList(true));
        return flag;
    }

    private void getTimeLimitsOfSequence(Experiment exp) {
        exp.getFileIntervalsFromSeqCamData();
        exp.kymoBin_ms = this.options.t_Ms_BinDuration;
        if (this.options.isFrameFixed) {
            exp.kymoFirst_ms = this.options.t_Ms_First;
            exp.kymoLast_ms = this.options.t_Ms_Last;
            if (exp.kymoLast_ms + exp.camImageFirst_ms > exp.camImageLast_ms) {
                exp.kymoLast_ms = exp.camImageLast_ms - exp.camImageFirst_ms;
            }
        } else {
            exp.kymoFirst_ms = 0L;
            exp.kymoLast_ms = exp.camImageLast_ms - exp.camImageFirst_ms;
        }
    }

    private void saveComputation(final Experiment exp) {
        int t0;
        String directory;
        if (this.options.doCreateBinDir) {
            exp.setBinSubDirectory(exp.getBinNameFromKymoFrameStep());
        }
        if ((directory = exp.getDirectoryToSaveResults()) == null) {
            return;
        }
        ProgressFrame progressBar = new ProgressFrame("Save kymographs");
        int nframes = exp.seqKymos.seq.getSizeT();
        int nCPUs = SystemUtil.getNumberOfCPUs();
        Processor processor = new Processor(nCPUs);
        processor.setThreadName("buildkymo2");
        processor.setPriority(5);
        ArrayList futuresArray = new ArrayList(nframes);
        futuresArray.clear();
        int t = t0 = (int)exp.binT0;
        while (t < exp.seqKymos.seq.getSizeT()) {
            final int t_index = t++;
            futuresArray.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    Capillary cap = exp.capillaries.capillariesList.get(t_index);
                    String filename = directory + File.separator + cap.getKymographName() + ".tiff";
                    File file = new File(filename);
                    IcyBufferedImage image = exp.seqKymos.getSeqImage(t_index, 0);
                    try {
                        Saver.saveImage((IcyBufferedImage)image, (File)file, (boolean)true);
                    }
                    catch (FormatException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
        this.waitFuturesCompletion(processor, futuresArray, progressBar);
        progressBar.close();
        exp.xmlSave_MCExperiment();
    }

    private boolean buildKymo(final Experiment exp) {
        if (exp.capillaries.capillariesList.size() < 1) {
            System.out.println("BuildKymographs:buildKymo Abort (1): nbcapillaries = 0");
            return false;
        }
        SequenceKymos seqKymos = exp.seqKymos;
        seqKymos.seq = new Sequence();
        this.initArraysToBuildKymographImages(exp);
        this.threadRunning = true;
        this.stopFlag = false;
        int nKymographColumns = (int)((exp.kymoLast_ms - exp.kymoFirst_ms) / exp.kymoBin_ms + 1L);
        int iToColumn = 0;
        FileTime firstImage_FileTime = exp.seqCamData.getFileTimeFromStructuredName(0);
        exp.build_MsTimeIntervalsArray_From_SeqCamData_FileNamesList(firstImage_FileTime.toMillis());
        int sourceImageIndex = exp.findNearestIntervalWithBinarySearch(exp.kymoFirst_ms, 0, exp.seqCamData.nTotalFrames);
        String vDataTitle = new String(" / " + nKymographColumns);
        ProgressFrame progressBar1 = new ProgressFrame("Analyze stack frame ");
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("buildKymograph");
        processor.setPriority(5);
        int ntasks = exp.capillaries.capillariesList.size();
        ArrayList tasks = new ArrayList(ntasks);
        tasks.clear();
        long ii_ms = exp.kymoFirst_ms;
        while (ii_ms <= exp.kymoLast_ms && !this.stopFlag) {
            IcyBufferedImage sourceImage;
            final int fromSourceImageIndex = sourceImageIndex = exp.findNearestIntervalWithBinarySearch(ii_ms, 0, exp.seqCamData.nTotalFrames);
            final int kymographColumn = iToColumn;
            if (this.options.concurrentDisplay) {
                sourceImage = this.loadImageFromIndex(exp, fromSourceImageIndex);
                this.vData.setTitle("Analyzing frame: " + (fromSourceImageIndex + 1) + vDataTitle);
                this.seqData.setImage(0, 0, (BufferedImage)sourceImage);
            }
            sourceImage = this.loadImageFromIndex(exp, fromSourceImageIndex);
            progressBar1.setMessage("Analyze frame: " + fromSourceImageIndex + "//" + exp.seqCamData.nTotalFrames);
            tasks.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    for (Capillary capi : exp.capillaries.capillariesList) {
                        BuildKymographs.this.analyzeImageWithCapillary(sourceImage, capi, fromSourceImageIndex, kymographColumn);
                    }
                }
            }));
            ii_ms += exp.kymoBin_ms;
            ++iToColumn;
        }
        this.waitFuturesCompletion(processor, tasks, null);
        progressBar1.close();
        ProgressFrame progressBar2 = new ProgressFrame("Combine results into kymograph");
        int sizeC = this.seqData.getSizeC();
        this.exportCapillaryIntegerArrays_to_Kymograph(exp, seqKymos.seq, sizeC);
        progressBar2.close();
        return true;
    }

    private void analyzeImageWithCapillary(IcyBufferedImage sourceImage, Capillary cap, int t, int kymographColumn) {
        ROI2DAlongT kymoROI2DatT = cap.getROI2DKymoAtIntervalT(t);
        int sizeC = sourceImage.getSizeC();
        for (int chan = 0; chan < sizeC; ++chan) {
            int[] sourceImageChannel = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(chan), (boolean)sourceImage.isSignedDataType());
            int[] capImageChannel = cap.cap_Integer.get(chan);
            int cnt = 0;
            int sourceImageWidth = sourceImage.getWidth();
            for (ArrayList<int[]> mask : kymoROI2DatT.getMasksList()) {
                int sum = 0;
                for (int[] m : mask) {
                    sum += sourceImageChannel[m[0] + m[1] * sourceImageWidth];
                }
                if (mask.size() > 0) {
                    capImageChannel[cnt * this.kymoImageWidth + kymographColumn] = sum / mask.size();
                }
                ++cnt;
            }
        }
    }

    private IcyBufferedImage loadImageFromIndex(Experiment exp, int indexFromFrame) {
        IcyBufferedImage sourceImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(indexFromFrame));
        return sourceImage;
    }

    private void exportCapillaryIntegerArrays_to_Kymograph(Experiment exp, final Sequence seqKymo, final int sizeC) {
        seqKymo.beginUpdate();
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("buildKymograph");
        processor.setPriority(5);
        int nbcapillaries = exp.capillaries.capillariesList.size();
        ArrayList tasks = new ArrayList(nbcapillaries);
        tasks.clear();
        int icap = 0;
        while (icap < nbcapillaries) {
            final Capillary cap = exp.capillaries.capillariesList.get(icap);
            final IcyBufferedImage cap_Image = this.cap_bufKymoImage.get(icap);
            final int indexCap = icap++;
            tasks.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    BuildKymographs.this.export_One_CapillaryIntegerArray_to_Kymograph(seqKymo, indexCap, cap, cap_Image, sizeC);
                }
            }));
        }
        this.waitFuturesCompletion(processor, tasks, null);
        seqKymo.endUpdate();
    }

    private void export_One_CapillaryIntegerArray_to_Kymograph(Sequence seqKymo, int icap, Capillary cap, IcyBufferedImage cap_Image, int sizeC) {
        ArrayList<int[]> cap_Integer = cap.cap_Integer;
        boolean isSignedDataType = cap_Image.isSignedDataType();
        for (int chan = 0; chan < sizeC; ++chan) {
            int[] tabValues = cap_Integer.get(chan);
            Object destArray = cap_Image.getDataXY(chan);
            Array1DUtil.intArrayToSafeArray((int[])tabValues, (int)0, (Object)destArray, (int)0, (int)-1, (boolean)isSignedDataType, (boolean)isSignedDataType);
            cap_Image.setDataXY(chan, destArray);
        }
        seqKymo.setImage(icap, 0, (BufferedImage)cap_Image);
        cap.cap_Integer = null;
    }

    private void initArraysToBuildKymographImages(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData.seq == null) {
            seqCamData.seq = exp.seqCamData.initSequenceFromFirstImage(exp.seqCamData.getImagesList(true));
        }
        int sizex = seqCamData.seq.getSizeX();
        int sizey = seqCamData.seq.getSizeY();
        this.kymoImageWidth = (int)((exp.kymoLast_ms - exp.kymoFirst_ms) / exp.kymoBin_ms + 1L);
        int imageHeight = 0;
        for (Capillary cap : exp.capillaries.capillariesList) {
            for (ROI2DAlongT capT : cap.getROIsForKymo()) {
                int imageHeight_i = this.buildMasks(capT, sizex, sizey);
                if (imageHeight_i <= imageHeight) continue;
                imageHeight = imageHeight_i;
            }
        }
        this.buildCapInteger(exp, imageHeight);
    }

    private int buildMasks(ROI2DAlongT capT, int sizex, int sizey) {
        ArrayList<ArrayList<int[]>> masks = new ArrayList<ArrayList<int[]>>();
        this.getPointsfromROIPolyLineUsingBresenham(ROI2DUtilities.getCapillaryPoints(capT.getRoi()), masks, this.options.diskRadius, sizex, sizey);
        capT.setMasksList(masks);
        return masks.size();
    }

    private void buildCapInteger(Experiment exp, int imageHeight) {
        DataType dataType;
        SequenceCamData seqCamData = exp.seqCamData;
        int numC = seqCamData.seq.getSizeC();
        if (numC <= 0) {
            numC = 3;
        }
        if ((dataType = seqCamData.seq.getDataType_()).toString().equals("undefined")) {
            dataType = DataType.UBYTE;
        }
        int len = this.kymoImageWidth * imageHeight;
        int nbcapillaries = exp.capillaries.capillariesList.size();
        this.cap_bufKymoImage = new ArrayList(nbcapillaries);
        for (int i = 0; i < nbcapillaries; ++i) {
            IcyBufferedImage cap_Image = new IcyBufferedImage(this.kymoImageWidth, imageHeight, numC, dataType);
            this.cap_bufKymoImage.add(cap_Image);
            Capillary cap = exp.capillaries.capillariesList.get(i);
            cap.cap_Integer = new ArrayList(numC);
            for (int chan = 0; chan < numC; ++chan) {
                int[] tabValues = new int[len];
                cap.cap_Integer.add(tabValues);
            }
        }
    }

    private void getPointsfromROIPolyLineUsingBresenham(ArrayList<Point2D> pointsList, List<ArrayList<int[]>> masks, double diskRadius, int sizex, int sizey) {
        ArrayList<int[]> pixels = Bresenham.getPixelsAlongLineFromROI2D(pointsList);
        int idiskRadius = (int)diskRadius;
        for (int[] pixel : pixels) {
            masks.add(this.getAllPixelsAroundPixel(pixel, idiskRadius, sizex, sizey));
        }
    }

    private ArrayList<int[]> getAllPixelsAroundPixel(int[] pixel, int diskRadius, int sizex, int sizey) {
        ArrayList<int[]> maskAroundPixel = new ArrayList<int[]>();
        double m1 = pixel[0];
        double m2 = pixel[1];
        double radiusSquared = diskRadius * diskRadius;
        int minX = this.clipValueToLimits(pixel[0] - diskRadius, 0, sizex - 1);
        int maxX = this.clipValueToLimits(pixel[0] + diskRadius, minX, sizex - 1);
        int minY = pixel[1];
        int maxY = pixel[1];
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                double dx = (double)x - m1;
                double dy = (double)y - m2;
                double distanceSquared = dx * dx + dy * dy;
                if (!(distanceSquared <= radiusSquared)) continue;
                maskAroundPixel.add(new int[]{x, y});
            }
        }
        return maskAroundPixel;
    }

    private int clipValueToLimits(int x, int min, int max) {
        if (x < min) {
            x = min;
        }
        if (x > max) {
            x = max;
        }
        return x;
    }

    private void closeKymoViewers() {
        this.closeViewer(this.vData);
        this.closeSequence(this.seqData);
    }

    private void openKymoViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildKymographs.this.seqData = BuildKymographs.this.newSequence("analyze stack starting with file " + exp.seqCamData.seq.getName(), exp.seqCamData.getSeqImage(0, 0));
                    BuildKymographs.this.vData = new Viewer(BuildKymographs.this.seqData, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

