/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.ImageTransform.Transforms;

import icy.image.IcyBufferedImage;
import icy.type.collection.array.Array1DUtil;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformFunctionAbstract;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformOptions;

public class XYDiffn
extends ImageTransformFunctionAbstract
implements ImageTransformInterface {
    int spanDiff = 5;

    public XYDiffn(int spanDiff) {
        this.spanDiff = spanDiff;
    }

    @Override
    public IcyBufferedImage getTransformedImage(IcyBufferedImage sourceImage, ImageTransformOptions options) {
        int chan0 = 0;
        int chan1 = sourceImage.getSizeC();
        int imageSizeX = sourceImage.getSizeX();
        int imageSizeY = sourceImage.getSizeY();
        IcyBufferedImage img2 = new IcyBufferedImage(imageSizeX, imageSizeY, 1, sourceImage.getDataType_());
        for (int c = chan0; c < chan1; ++c) {
            int[] tabValues = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(c), (boolean)sourceImage.isSignedDataType());
            int[] outValues = Array1DUtil.arrayToIntArray((Object)img2.getDataXY(c), (boolean)img2.isSignedDataType());
            for (int ix = 0; ix < imageSizeX; ++ix) {
                for (int iy = this.spanDiff; iy < imageSizeY - this.spanDiff; ++iy) {
                    int ky = ix + iy * imageSizeX;
                    int deltay = 0;
                    double outVal = 0.0;
                    for (int ispan = 1; ispan < this.spanDiff; ++ispan) {
                        outVal += (double)(tabValues[ky + (deltay += imageSizeX)] - tabValues[ky - deltay]);
                    }
                    int deltax = 0;
                    int yspan2 = 10;
                    if (ix > yspan2 && ix < imageSizeX - yspan2) {
                        for (int ispan = 1; ispan < yspan2; ++ispan) {
                            outVal += (double)(tabValues[ky + ++deltax] - tabValues[ky - deltax]);
                        }
                    }
                    outValues[ky] = (int)outVal > 0 ? (int)outVal : 0;
                }
            }
            Array1DUtil.intArrayToSafeArray((int[])outValues, (Object)img2.getDataXY(c), (boolean)true, (boolean)img2.isSignedDataType());
            img2.setDataXY(c, img2.getDataXY(c));
        }
        return img2;
    }
}

