/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.ImageTransform.Transforms;

import icy.image.IcyBufferedImage;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformFunctionAbstract;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformOptions;

public class YDiffn1D
extends ImageTransformFunctionAbstract
implements ImageTransformInterface {
    int spanDiff = 5;

    public YDiffn1D(int spanDiff) {
        this.spanDiff = spanDiff;
    }

    @Override
    public IcyBufferedImage getTransformedImage(IcyBufferedImage sourceImage, ImageTransformOptions options) {
        int imageSizeX = sourceImage.getSizeX();
        int imageSizeY = sourceImage.getSizeY();
        IcyBufferedImage img2 = new IcyBufferedImage(imageSizeX, imageSizeY, 3, sourceImage.getDataType_());
        int[] Rn = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        int[] Gn = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(1), (boolean)sourceImage.isSignedDataType());
        int[] Bn = Array1DUtil.arrayToIntArray((Object)sourceImage.getDataXY(2), (boolean)sourceImage.isSignedDataType());
        double[] outValues = (double[])Array1DUtil.createArray((DataType)DataType.DOUBLE, (int)Rn.length);
        for (int ix = 0; ix < imageSizeX; ++ix) {
            for (int iy = this.spanDiff; iy < imageSizeY - this.spanDiff; ++iy) {
                int kx = ix + iy * imageSizeX;
                int deltax = 0;
                double outVal = 0.0;
                for (int ispan = 1; ispan < this.spanDiff; ++ispan) {
                    outVal += (double)(Rn[kx + (deltax += imageSizeX)] - Rn[kx - deltax]) - (double)(Gn[kx + deltax] - Gn[kx - deltax] + (Bn[kx + deltax] - Bn[kx - deltax])) / 2.0;
                }
                outValues[kx] = (int)outVal > 0 ? (double)((int)outVal) : 0.0;
            }
        }
        this.copyExGDoubleToIcyBufferedImage(outValues, img2);
        return img2;
    }
}

