/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.viewer1D;

import icy.canvas.IcyCanvas;
import icy.gui.component.IcySlider;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.collection.array.Array1DUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYSeriesLabelGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multicafe.viewer1D.CheckComboBox;
import plugins.fmp.multicafe.viewer1D.CheckComboBoxSelectionChangedListener;
import plugins.fmp.multicafe.viewer1D.PanningChartPanel;

public class IntensityProfile {
    final IcySlider slider;
    JCheckBox graphOverZ = new JCheckBox("Graph Z");
    JButton rowOColBtn = new JButton("row");
    JButton exportToFileBtn = new JButton("Export to file");
    JLabel indexLbl = new JLabel("0");
    JLabel maxIndexLbl = new JLabel("0");
    public PanningChartPanel chartPanel;
    public JFreeChart chart;
    XYSeriesCollection xyDataset = new XYSeriesCollection();
    String OPTION_meanAlongZ = "Mean along Z";
    String OPTION_meanAlongT = "Mean along T";
    CheckComboBox optionComboBox;
    private Sequence sequence;
    boolean rowMode = true;
    int lineIndex = 0;
    IcyCanvas mainCanvas;
    public double posX = 0.0;
    public double posY = 0.0;
    double pixelSize = 1.0;
    int paintersSize = 0;
    Runnable updateRunnable;
    private int lastChannelSize = 0;
    int runCount = 0;

    public IntensityProfile(IcyCanvas mainCav, Sequence seq) {
        this.sequence = seq;
        HashSet<String> mapValue = new HashSet<String>();
        mapValue.add(this.OPTION_meanAlongZ);
        mapValue.add(this.OPTION_meanAlongT);
        this.optionComboBox = new CheckComboBox(mapValue);
        ComponentUtil.setFixedHeight((Component)this.optionComboBox, (int)22);
        this.optionComboBox.addSelectionChangedListener(new CheckComboBoxSelectionChangedListener(){

            @Override
            public void selectionChanged(int idx) {
                IntensityProfile.this.updateChart();
            }
        });
        this.rowOColBtn.setFocusPainted(false);
        this.rowOColBtn.setPreferredSize(new Dimension(65, 22));
        this.rowOColBtn.setMaximumSize(new Dimension(80, 22));
        this.rowOColBtn.setMinimumSize(new Dimension(65, 22));
        this.rowOColBtn.setMargin(new Insets(2, 8, 2, 8));
        this.rowOColBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String xlabel;
                if (IntensityProfile.this.rowOColBtn.getText() == "row") {
                    IntensityProfile.this.rowOColBtn.setText("column");
                    IntensityProfile.this.rowMode = false;
                    xlabel = "Column (Y)";
                } else {
                    IntensityProfile.this.rowOColBtn.setText("row");
                    IntensityProfile.this.rowMode = true;
                    xlabel = "Row (X)";
                }
                IntensityProfile.this.chart.getXYPlot().getDomainAxis().setLabel(xlabel);
                IntensityProfile.this.updateXYNav();
                IntensityProfile.this.updateChart();
            }
        });
        this.rowOColBtn.setToolTipText("slide in row or column");
        this.exportToFileBtn.setFocusPainted(false);
        this.exportToFileBtn.setPreferredSize(new Dimension(180, 22));
        this.exportToFileBtn.setMaximumSize(new Dimension(240, 22));
        this.exportToFileBtn.setMinimumSize(new Dimension(120, 22));
        this.exportToFileBtn.setMargin(new Insets(2, 8, 2, 8));
        this.exportToFileBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jdir = new JFileChooser();
                jdir.setFileSelectionMode(0);
                if (0 == jdir.showOpenDialog(null)) {
                    String path = jdir.getSelectedFile().getAbsolutePath();
                    if (!path.contains(".")) {
                        path = path + ".txt";
                    }
                    BufferedWriter writer = null;
                    try {
                        File outputFile = new File(path);
                        writer = new BufferedWriter(new FileWriter(outputFile));
                        int maxSize = 0;
                        for (Object s : IntensityProfile.this.xyDataset.getSeries()) {
                            if (maxSize >= ((XYSeries)s).getItemCount()) continue;
                            maxSize = ((XYSeries)s).getItemCount();
                        }
                        String[] dataArr = new String[maxSize + 1];
                        for (int i = 0; i < maxSize + 1; ++i) {
                            dataArr[i] = "";
                        }
                        for (int c = 0; c < IntensityProfile.this.xyDataset.getSeriesCount(); ++c) {
                            XYSeries seriesXY = IntensityProfile.this.xyDataset.getSeries(c);
                            List it = seriesXY.getItems();
                            int size = it.size();
                            dataArr[0] = dataArr[0] + seriesXY.getKey().toString() + "(X)\t" + seriesXY.getKey().toString() + "(Y)\t";
                            for (int i = 1; i < maxSize + 1; ++i) {
                                if (size > i) {
                                    int n = i;
                                    dataArr[n] = dataArr[n] + ((XYDataItem)it.get(i)).getXValue() + "\t" + ((XYDataItem)it.get(i)).getYValue() + "\t";
                                    continue;
                                }
                                int n = i;
                                dataArr[n] = dataArr[n] + " \t \t";
                            }
                        }
                        for (String s : dataArr) {
                            writer.write(s + "\n");
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        this.exportToFileBtn.setToolTipText("Print current line data to the console of Icy.");
        this.indexLbl.setHorizontalAlignment(4);
        this.maxIndexLbl.setHorizontalAlignment(4);
        this.slider = new IcySlider(0);
        this.slider.setFocusable(false);
        this.slider.setMaximum(0);
        this.slider.setMinimum(0);
        this.slider.setToolTipText("Move cursor to navigate in T dimension");
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    IntensityProfile.this.indexLbl.setText(String.valueOf(IntensityProfile.this.slider.getValue()));
                    IntensityProfile.this.lineIndex = IntensityProfile.this.slider.getValue();
                    if (IntensityProfile.this.rowMode) {
                        IntensityProfile.this.posY = IntensityProfile.this.lineIndex;
                        IntensityProfile.this.mainCanvas.mouseImagePositionChanged(DimensionId.Y);
                    } else {
                        IntensityProfile.this.posX = IntensityProfile.this.lineIndex;
                        IntensityProfile.this.mainCanvas.mouseImagePositionChanged(DimensionId.X);
                    }
                }
                finally {
                    IntensityProfile.this.updateChart();
                }
            }
        });
        ComponentUtil.setFixedHeight((Component)this.slider, (int)22);
        String xlabel = this.rowMode ? "Row (X)" : "Column (Y)";
        this.chart = ChartFactory.createXYLineChart((String)"", (String)xlabel, (String)"Intensity Value", (XYDataset)this.xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        this.chartPanel = new PanningChartPanel(this.chart, 1024, 500, 500, 200, 10000, 10000, false, false, true, false, true, true);
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent arg0) {
                IntensityProfile.this.chart.getXYPlot().setDomainCrosshairVisible(true);
                IntensityProfile.this.chart.getXYPlot().setDomainCrosshairLockedOnData(true);
                IntensityProfile.this.chart.getXYPlot().setRangeCrosshairVisible(true);
                IntensityProfile.this.chart.getXYPlot().setRangeCrosshairLockedOnData(true);
                IntensityProfile.this.chart.getXYPlot().getRangeAxis(0).setAxisLineVisible(true);
                IntensityProfile.this.chart.getXYPlot().getDomainAxis(0).setAxisLineVisible(false);
            }

            public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
                Point2D p = IntensityProfile.this.chartPanel.translateScreenToJava2D(chartMouseEvent.getTrigger().getPoint());
                Rectangle2D plotArea = IntensityProfile.this.chartPanel.getScreenDataArea();
                XYPlot plot = (XYPlot)IntensityProfile.this.chart.getPlot();
                double chartX = plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge());
                if (IntensityProfile.this.rowMode) {
                    IntensityProfile.this.posX = chartX;
                    IntensityProfile.this.mainCanvas.mouseImagePositionChanged(DimensionId.X);
                } else {
                    IntensityProfile.this.posY = chartX;
                    IntensityProfile.this.mainCanvas.mouseImagePositionChanged(DimensionId.Y);
                }
            }
        });
        this.chart.getXYPlot().getRangeAxis(0).setAutoRange(true);
        this.chart.getXYPlot().getDomainAxis(0).setAutoRange(true);
        this.chart.getXYPlot().setDomainCrosshairPaint((Paint)Color.red);
        this.chart.getXYPlot().setRangeCrosshairPaint((Paint)Color.red);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer();
        renderer.setLegendItemToolTipGenerator((XYSeriesLabelGenerator)new StandardXYSeriesLabelGenerator("Legend {0}"));
        this.mainCanvas = mainCav;
        this.mainCanvas.add((Component)GuiUtil.createPageBoxPanel((Component[])new Component[]{GuiUtil.createLineBoxPanel((Component[])new Component[]{this.optionComboBox, this.exportToFileBtn}), this.chartPanel, GuiUtil.createLineBoxPanel((Component[])new Component[]{this.rowOColBtn, this.slider, this.maxIndexLbl})}));
        this.chart.setBackgroundPaint((Paint)new Color(0.0f, 0.0f, 0.0f, 0.0f));
        XYPlot plot = this.chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.getRenderer().setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        plot.getRenderer().setSeriesShape(0, null);
        this.updateXYNav();
        this.updateChart();
    }

    public BufferedImage getImage() {
        BufferedImage objBufferedImage = this.chart.createBufferedImage(1024, 800);
        return objBufferedImage;
    }

    public void updateChannelOptions() {
        int size = this.sequence.getSizeC();
        if (this.lastChannelSize != size) {
            LinkedHashSet<String> mapValue = new LinkedHashSet<String>();
            mapValue.add(this.OPTION_meanAlongZ);
            mapValue.add(this.OPTION_meanAlongT);
            for (int i = 0; i < size; ++i) {
                mapValue.add("channel " + i + "(" + this.sequence.getChannelName(i) + ")");
            }
            this.optionComboBox.resetObjs(mapValue, false);
            ArrayList<String> selectedValues = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                if (i >= this.sequence.getSizeC()) continue;
                selectedValues.add("channel " + i + "(" + this.sequence.getChannelName(i) + ")");
            }
            this.optionComboBox.addSelectedItems(selectedValues);
            this.lastChannelSize = size;
        }
    }

    public void updateChannelPainters() {
        XYPlot plot = this.chart.getXYPlot();
        int size = this.xyDataset.getSeries().size();
        if (this.paintersSize < size) {
            if (size == 1) {
                plot.getRenderer().setSeriesPaint(0, (Paint)Color.blue);
            } else if (size == 2) {
                plot.getRenderer().setSeriesPaint(0, (Paint)Color.blue);
                plot.getRenderer().setSeriesPaint(1, (Paint)Color.red);
            } else if (size == 3) {
                plot.getRenderer().setSeriesPaint(0, (Paint)Color.red);
                plot.getRenderer().setSeriesPaint(1, (Paint)Color.green);
                plot.getRenderer().setSeriesPaint(1, (Paint)Color.blue);
            } else {
                for (int i = this.paintersSize; i < size; ++i) {
                    int R = (int)(Math.random() * 256.0);
                    int G = (int)(Math.random() * 256.0);
                    int B = (int)(Math.random() * 256.0);
                    Color color = new Color(R, G, B);
                    Random random = new Random();
                    float hue = random.nextFloat();
                    float saturation = 0.9f;
                    float luminance = 1.0f;
                    color = Color.getHSBColor(hue, 0.9f, 1.0f);
                    plot.getRenderer().setSeriesPaint(i, (Paint)color);
                }
            }
        }
        this.paintersSize = size;
    }

    public void updateChart() {
        this.chart.setAntiAlias(true);
        this.chart.setTextAntiAlias(true);
        try {
            this.updateChannelOptions();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.updateRunnable == null) {
            this.updateRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        IntensityProfile.this.updateChartThreaded();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }
        ThreadUtil.bgRunSingle((Runnable)this.updateRunnable);
        this.updateChannelPainters();
    }

    private void updateChartThreaded() {
        ArrayList<Point2D> pointList;
        int currentZ = 0;
        int currentT = 0;
        currentT = this.mainCanvas.getPositionT();
        currentZ = this.mainCanvas.getPositionZ();
        if (currentZ < 0) {
            currentZ = 0;
        }
        if (currentT < 0) {
            currentT = 0;
        }
        if (this.rowMode) {
            if (this.lineIndex > this.sequence.getHeight() - 1) {
                this.lineIndex = this.sequence.getHeight() - 1;
                this.slider.setValue(this.lineIndex);
                return;
            }
            this.pixelSize = this.sequence.getPixelSizeX();
            pointList = new ArrayList<Point2D>();
            int size = this.sequence.getSizeX();
            for (int i = 0; i < size; ++i) {
                pointList.add(new Point2D.Double(i, this.lineIndex));
            }
        } else {
            if (this.lineIndex > this.sequence.getWidth() - 1) {
                this.lineIndex = this.sequence.getWidth() - 1;
                this.slider.setValue(this.lineIndex);
                return;
            }
            this.pixelSize = this.sequence.getPixelSizeY();
            pointList = new ArrayList();
            int size = this.sequence.getSizeY();
            for (int i = 0; i < size; ++i) {
                pointList.add(new Point2D.Double(this.lineIndex, i));
            }
        }
        if (pointList.size() > 1) {
            this.computeLineProfile(pointList, currentT, currentZ, this.sequence);
            if (this.optionComboBox.isItemSelected(this.OPTION_meanAlongZ)) {
                this.computeZMeanLineProfile(pointList, currentT, this.sequence);
            }
            if (this.optionComboBox.isItemSelected(this.OPTION_meanAlongT)) {
                this.computeTMeanLineProfile(pointList, currentZ, this.sequence);
            }
            this.updateChannelPainters();
            this.chart.fireChartChanged();
        }
    }

    public void updateXYNav() {
        if (this.rowMode) {
            this.rowOColBtn.setText("row");
            this.slider.setMaximum(this.sequence.getHeight() - 1);
            this.slider.setMinimum(0);
            if (this.slider.getValue() > this.sequence.getHeight() - 1) {
                this.slider.setValue(0);
            }
            this.indexLbl.setText(String.valueOf(this.slider.getValue()));
            this.maxIndexLbl.setText(String.valueOf(this.sequence.getHeight() - 1));
        } else {
            this.rowOColBtn.setText("column");
            this.slider.setMaximum(this.sequence.getWidth() - 1);
            this.slider.setMinimum(0);
            if (this.slider.getValue() > this.sequence.getWidth() - 1) {
                this.slider.setValue(0);
            }
            this.indexLbl.setText(String.valueOf(this.slider.getValue()));
            this.maxIndexLbl.setText(String.valueOf(this.sequence.getWidth() - 1));
        }
    }

    private void computeZMeanLineProfile(ArrayList<Point2D> pointList, int currentT, Sequence sequence) {
        if (sequence.getSizeZ() > 1) {
            int c;
            double[][] result = null;
            for (int z = 0; z < sequence.getSizeZ(); ++z) {
                Profile profile = this.getValueForPointList(pointList, sequence.getImage(currentT, z));
                if (result == null) {
                    result = new double[profile.values.length][profile.values[0].length];
                }
                for (int c2 = 0; c2 < sequence.getSizeC(); ++c2) {
                    for (int i = 0; i < profile.values[c2].length; ++i) {
                        double[] dArray = result[c2];
                        int n = i;
                        dArray[n] = dArray[n] + profile.values[c2][i];
                    }
                }
            }
            for (c = 0; c < sequence.getSizeC(); ++c) {
                int i = 0;
                while (i < ((void)result[c]).length) {
                    void v2 = result[c];
                    int n = i++;
                    v2[n] = v2[n] / (double)sequence.getSizeZ();
                }
            }
            for (c = 0; c < sequence.getSizeC(); ++c) {
                boolean found = false;
                XYSeries seriesXY2 = null;
                try {
                    seriesXY2 = this.xyDataset.getSeries((Comparable)((Object)("Mean along Z c" + c)));
                    found = true;
                }
                catch (Exception i) {
                    // empty catch block
                }
                XYSeries seriesXY = new XYSeries((Comparable)((Object)("Mean along Z c" + c)));
                for (int i = 0; i < result[c].length; ++i) {
                    seriesXY.add((double)i * this.pixelSize, result[c][i]);
                }
                this.xyDataset.addSeries(seriesXY);
                if (!found || seriesXY2 == null) continue;
                this.xyDataset.removeSeries(seriesXY2);
            }
        }
    }

    private void computeTMeanLineProfile(ArrayList<Point2D> pointList, int currentZ, Sequence sequence) {
        if (sequence.getSizeT() > 1) {
            int c;
            double[][] result = null;
            for (int t = 0; t < sequence.getSizeT(); ++t) {
                Profile profile = this.getValueForPointList(pointList, sequence.getImage(t, currentZ));
                if (result == null) {
                    result = new double[profile.values.length][profile.values[0].length];
                }
                for (int c2 = 0; c2 < sequence.getSizeC(); ++c2) {
                    for (int i = 0; i < profile.values[c2].length; ++i) {
                        double[] dArray = result[c2];
                        int n = i;
                        dArray[n] = dArray[n] + profile.values[c2][i];
                    }
                }
            }
            for (c = 0; c < sequence.getSizeC(); ++c) {
                int i = 0;
                while (i < ((void)result[c]).length) {
                    void v2 = result[c];
                    int n = i++;
                    v2[n] = v2[n] / (double)sequence.getSizeT();
                }
            }
            for (c = 0; c < sequence.getSizeC(); ++c) {
                boolean found = false;
                XYSeries seriesXY2 = null;
                try {
                    seriesXY2 = this.xyDataset.getSeries((Comparable)((Object)("Mean along T c" + c)));
                    found = true;
                }
                catch (Exception i) {
                    // empty catch block
                }
                XYSeries seriesXY = new XYSeries((Comparable)((Object)("Mean along T c" + c)));
                for (int i = 0; i < result[c].length; ++i) {
                    seriesXY.add((double)i * this.pixelSize, result[c][i]);
                }
                this.xyDataset.addSeries(seriesXY);
                if (!found || seriesXY2 == null) continue;
                this.xyDataset.removeSeries(seriesXY2);
            }
        }
    }

    private void computeLineProfile(ArrayList<Point2D> pointList, int currentT, int currentZ, Sequence sequence) {
        Profile profile = this.getValueForPointList(pointList, sequence.getImage(currentT, currentZ));
        boolean found = false;
        for (int c = 0; c < sequence.getSizeC(); ++c) {
            XYSeries seriesXY = null;
            try {
                seriesXY = this.xyDataset.getSeries((Comparable)((Object)("channel " + c)));
                found = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.optionComboBox.isItemSelected("channel " + c + "(" + sequence.getChannelName(c) + ")")) {
                XYSeries seriesXY2 = new XYSeries((Comparable)((Object)("channel " + c)));
                for (int i = 0; i < profile.values[c].length; ++i) {
                    seriesXY2.add((double)i * this.pixelSize, profile.values[c][i]);
                }
                this.xyDataset.addSeries(seriesXY2);
            }
            if (!found || seriesXY == null) continue;
            this.xyDataset.removeSeries(seriesXY);
        }
    }

    private Profile getValueForPointList(ArrayList<Point2D> pointList, IcyBufferedImage image) {
        ArrayList<double[][]> dataList = new ArrayList<double[][]>();
        ArrayList<Integer> roiLineBreaks = new ArrayList<Integer>();
        int indexSize = 0;
        for (int i = 0; i < pointList.size() - 1; ++i) {
            double[][] dataTmp = this.getValueFor1DSegment(pointList.get(i), pointList.get(i + 1), image);
            dataList.add(dataTmp);
            roiLineBreaks.add(indexSize += dataTmp[0].length);
        }
        double[][] data = new double[image.getSizeC()][indexSize];
        int index = 0;
        for (double[][] dataToAdd : dataList) {
            for (int c = 0; c < image.getSizeC(); ++c) {
                for (int i = 0; i < dataToAdd[0].length; ++i) {
                    data[c][index + i] = dataToAdd[c][i];
                }
            }
            index += dataToAdd[0].length;
        }
        Profile profile = new Profile();
        profile.values = data;
        return profile;
    }

    private double[][] getValueFor1DSegment(Point2D p1, Point2D p2, IcyBufferedImage image) {
        int distance = (int)p1.distance(p2);
        double vx = (p2.getX() - p1.getX()) / (double)distance;
        double vy = (p2.getY() - p1.getY()) / (double)distance;
        int nbComponent = image.getSizeC();
        double[][] data = new double[nbComponent][distance];
        double x = p1.getX();
        double y = p1.getY();
        for (int i = 0; i < distance; ++i) {
            int component;
            if (image.isInside((int)x, (int)y)) {
                for (component = 0; component < nbComponent; ++component) {
                    data[component][i] = Array1DUtil.getValue((Object)image.getDataXY(component), (int)image.getOffset((int)x, (int)y), (boolean)image.isSignedDataType());
                }
            } else {
                for (component = 0; component < nbComponent; ++component) {
                    data[component][i] = 0.0;
                }
            }
            x += vx;
            y += vy;
        }
        return data;
    }

    class Profile {
        double[][] values;

        Profile() {
        }
    }
}

