/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.browse;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.dlg.browse.SelectFiles1;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.ExperimentDirectories;
import plugins.fmp.multicafe.tools.JComponents.SequenceNameListRenderer;

public class LoadSaveExperiment
extends JPanel
implements PropertyChangeListener,
ItemListener,
SequenceListener {
    private static final long serialVersionUID = -690874563607080412L;
    private JButton createButton = new JButton("Create...");
    private JButton openButton = new JButton("Open...");
    private JButton searchButton = new JButton("Search...");
    private JButton closeButton = new JButton("Close");
    public JCheckBox filteredCheck = new JCheckBox("List filtered");
    public List<String> selectedNames = new ArrayList<String>();
    private SelectFiles1 dialogSelect = null;
    private JButton previousButton = new JButton("<");
    private JButton nextButton = new JButton(">");
    private MultiCAFE parent0 = null;

    public JPanel initPanel(MultiCAFE parent0) {
        this.parent0 = parent0;
        SequenceNameListRenderer renderer = new SequenceNameListRenderer();
        parent0.expListCombo.setRenderer(renderer);
        int bWidth = 30;
        int height = 20;
        this.previousButton.setPreferredSize(new Dimension(bWidth, height));
        this.nextButton.setPreferredSize(new Dimension(bWidth, height));
        JPanel sequencePanel0 = new JPanel(new BorderLayout());
        sequencePanel0.add((Component)this.previousButton, "Before");
        sequencePanel0.add((Component)parent0.expListCombo, "Center");
        sequencePanel0.add((Component)this.nextButton, "After");
        JPanel sequencePanel = new JPanel(new BorderLayout());
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(1);
        JPanel subPanel = new JPanel(layout);
        subPanel.add(this.openButton);
        subPanel.add(this.createButton);
        subPanel.add(this.searchButton);
        subPanel.add(this.closeButton);
        subPanel.add(this.filteredCheck);
        sequencePanel.add((Component)subPanel, "Before");
        this.defineActionListeners();
        parent0.expListCombo.addItemListener(this);
        JPanel twoLinesPanel = new JPanel(new GridLayout(2, 1));
        twoLinesPanel.add(sequencePanel0);
        twoLinesPanel.add(sequencePanel);
        return twoLinesPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SELECT1_CLOSED")) {
            this.parent0.paneExperiment.tabInfos.disableChangeFile = true;
            if (this.selectedNames.size() < 1) {
                return;
            }
            ExperimentDirectories experimentDirectories = new ExperimentDirectories();
            if (experimentDirectories.getDirectoriesFromExptPath(this.parent0.expListCombo, this.selectedNames.get(0), null)) {
                final int item = this.addExperimentFrom3NamesAnd2Lists(experimentDirectories);
                final String binSubDirectory = this.parent0.expListCombo.expListBinSubDirectory;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.paneExperiment.tabInfos.disableChangeFile = false;
                        for (int i = 1; i < LoadSaveExperiment.this.selectedNames.size(); ++i) {
                            ExperimentDirectories expDirectories = new ExperimentDirectories();
                            if (!expDirectories.getDirectoriesFromExptPath(((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo, LoadSaveExperiment.this.selectedNames.get(i), binSubDirectory)) continue;
                            LoadSaveExperiment.this.addExperimentFrom3NamesAnd2Lists(expDirectories);
                        }
                        LoadSaveExperiment.this.selectedNames.clear();
                        LoadSaveExperiment.this.updateBrowseInterface();
                        ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.paneExperiment.tabInfos.disableChangeFile = true;
                        ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.paneExperiment.tabInfos.initInfosCombos();
                        ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.setSelectedIndex(item);
                        Experiment exp = (Experiment)((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.getSelectedItem();
                        if (exp != null) {
                            ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.paneExperiment.tabInfos.transferPreviousExperimentInfosToDialog(exp, exp);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                this.openSelecteExperiment(exp);
            }
        } else if (e.getStateChange() == 2) {
            Experiment exp = (Experiment)e.getItem();
            this.closeViewsForCurrentExperiment(exp);
        }
    }

    void closeAllExperiments() {
        this.closeCurrentExperiment();
        this.parent0.expListCombo.removeAllItems();
        this.parent0.paneExperiment.tabFilter.clearAllCheckBoxes();
        this.parent0.paneExperiment.tabFilter.filterExpList.removeAllItems();
        this.parent0.paneExperiment.tabInfos.clearCombos();
        this.filteredCheck.setSelected(false);
    }

    public void closeViewsForCurrentExperiment(Experiment exp) {
        if (exp != null) {
            if (exp.seqCamData != null) {
                exp.xmlSave_MCExperiment();
                exp.saveCapillariesMeasures(exp.getKymosBinFullDirectory());
                exp.saveCageAndMeasures();
            }
            exp.closeSequences();
        }
    }

    public void closeCurrentExperiment() {
        if (this.parent0.expListCombo.getSelectedIndex() < 0) {
            return;
        }
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.closeViewsForCurrentExperiment(exp);
        }
    }

    void updateBrowseInterface() {
        int isel = this.parent0.expListCombo.getSelectedIndex();
        boolean flag1 = isel != 0;
        boolean flag2 = isel != this.parent0.expListCombo.getItemCount() - 1;
        this.previousButton.setEnabled(flag1);
        this.nextButton.setEnabled(flag2);
    }

    boolean openSelecteExperiment(Experiment exp) {
        ProgressFrame progressFrame = new ProgressFrame("Load Data");
        exp.xmlLoad_MCExperiment();
        boolean flag = true;
        progressFrame.setMessage("Load image");
        exp.loadCamDataImages();
        this.parent0.paneExperiment.updateViewerForSequenceCam(exp);
        exp.seqCamData.seq.addListener((SequenceListener)this);
        if (exp.seqCamData != null) {
            exp.loadCamDataCapillaries();
            this.parent0.paneKymos.tabLoadSave.loadDefaultKymos(exp);
            if (exp.seqKymos != null) {
                this.parent0.paneLevels.tabFileLevels.dlg_levels_loadCapillaries_Measures(exp);
                if (this.parent0.paneExperiment.tabOptions.graphsCheckBox.isSelected()) {
                    this.parent0.paneLevels.tabGraphs.displayGraphsPanels(exp);
                }
            }
            exp.loadCageMeasures();
            exp.updateROIsAt(0);
            progressFrame.setMessage("Load data: update dialogs");
            this.parent0.paneExperiment.updateDialogs(exp);
            this.parent0.paneKymos.updateDialogs(exp);
            this.parent0.paneCapillaries.updateDialogs(exp);
        } else {
            flag = false;
            System.out.println("LoadSaveExperiments:openSelectedExperiment() Error: no jpg files found for this experiment\n");
        }
        this.parent0.paneExperiment.tabInfos.transferPreviousExperimentInfosToDialog(exp, exp);
        progressFrame.close();
        return flag;
    }

    private void defineActionListeners() {
        this.parent0.expListCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadSaveExperiment.this.updateBrowseInterface();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.setSelectedIndex(((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.getSelectedIndex() + 1);
                LoadSaveExperiment.this.updateBrowseInterface();
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.setSelectedIndex(((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.getSelectedIndex() - 1);
                LoadSaveExperiment.this.updateBrowseInterface();
            }
        });
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LoadSaveExperiment.this.selectedNames = new ArrayList<String>();
                LoadSaveExperiment.this.dialogSelect = new SelectFiles1();
                LoadSaveExperiment.this.dialogSelect.initialize(LoadSaveExperiment.this.parent0);
            }
        });
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExperimentDirectories eDAF = new ExperimentDirectories();
                if (eDAF.getDirectoriesFromDialog(((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo, null, true)) {
                    int item = LoadSaveExperiment.this.addExperimentFrom3NamesAnd2Lists(eDAF);
                    ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.paneExperiment.tabInfos.initInfosCombos();
                    ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.setSelectedIndex(item);
                }
            }
        });
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExperimentDirectories eDAF = new ExperimentDirectories();
                if (eDAF.getDirectoriesFromDialog(((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo, null, false)) {
                    int item = LoadSaveExperiment.this.addExperimentFrom3NamesAnd2Lists(eDAF);
                    ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.paneExperiment.tabInfos.initInfosCombos();
                    ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.setSelectedIndex(item);
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadSaveExperiment.this.closeAllExperiments();
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.paneExperiment.tabsPane.setSelectedIndex(0);
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.removeAllItems();
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.expListCombo.updateUI();
            }
        });
        this.filteredCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((LoadSaveExperiment)LoadSaveExperiment.this).parent0.paneExperiment.tabFilter.filterExperimentList(LoadSaveExperiment.this.filteredCheck.isSelected());
            }
        });
    }

    private int addExperimentFrom3NamesAnd2Lists(ExperimentDirectories eDAF) {
        Experiment exp = new Experiment(eDAF);
        int item = this.parent0.expListCombo.addExperiment(exp, false);
        return item;
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        Experiment exp;
        if (sequenceEvent.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null && exp.seqCamData.seq != null && sequenceEvent.getSequence() == exp.seqCamData.seq) {
            Viewer v = exp.seqCamData.seq.getFirstViewer();
            int t = v.getPositionT();
            v.setTitle(exp.seqCamData.getDecoratedImageName(t));
        }
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
    }
}

