/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.browse;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.preferences.XMLPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.dlg.browse.LoadSaveExperiment;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.ExperimentDirectories;

public class SelectFiles1
extends JPanel {
    private static final long serialVersionUID = 4172927636287523049L;
    IcyFrame dialogFrame = null;
    private JComboBox<String> filterCombo = new JComboBox<String>(new String[]{"capillarytrack", "multicafe", "roisline", "cam", "grabs", "MCcapillaries", "MCexperiment"});
    private JButton findButton = new JButton("Select root directory and search...");
    private JButton clearSelectedButton = new JButton("Clear selected");
    private JButton clearAllButton = new JButton("Clear all");
    private JButton addSelectedButton = new JButton("Add selected");
    private JButton addAllButton = new JButton("Add all");
    private JRadioButton rbFile = new JRadioButton("file", true);
    private JRadioButton rbDirectory = new JRadioButton("directory");
    private JList<String> directoriesJList = new JList(new DefaultListModel());
    private MultiCAFE parent0 = null;
    private LoadSaveExperiment parent1 = null;

    public void initialize(MultiCAFE parent0) {
        this.parent0 = parent0;
        this.parent1 = parent0.paneBrowse.panelLoadSave;
        this.addPropertyChangeListener(this.parent1);
        JPanel mainPanel = GuiUtil.generatePanelWithoutBorder();
        this.dialogFrame = new IcyFrame("Select files", true, true);
        this.dialogFrame.setLayout((LayoutManager)new BorderLayout());
        this.dialogFrame.add((Component)mainPanel, (Object)"Center");
        FlowLayout layout1 = new FlowLayout(0);
        layout1.setVgap(1);
        JPanel topPanel = new JPanel(layout1);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbFile);
        bg.add(this.rbDirectory);
        topPanel.add(this.findButton);
        topPanel.add(this.filterCombo);
        topPanel.add(this.rbFile);
        topPanel.add(this.rbDirectory);
        mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{topPanel}));
        this.directoriesJList.setSelectionMode(2);
        this.directoriesJList.setLayoutOrientation(0);
        this.directoriesJList.setVisibleRowCount(20);
        JScrollPane scrollPane = new JScrollPane(this.directoriesJList);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(22);
        mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{scrollPane}));
        mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.clearSelectedButton, this.clearAllButton}));
        mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.addSelectedButton, this.addAllButton}));
        this.filterCombo.setEditable(true);
        this.filterCombo.setSelectedIndex(6);
        this.addActionListeners();
        this.dialogFrame.pack();
        this.dialogFrame.addToDesktopPane();
        this.dialogFrame.requestFocus();
        this.dialogFrame.center();
        this.dialogFrame.setVisible(true);
    }

    void close() {
        this.dialogFrame.close();
    }

    void addActionListeners() {
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String pattern = (String)SelectFiles1.this.filterCombo.getSelectedItem();
                if (pattern.contains("MCexperiment")) {
                    pattern = "MCexpe";
                } else if (pattern.contains("MCcapillaries")) {
                    pattern = "MCcapi";
                }
                boolean isFileName = SelectFiles1.this.rbFile.isSelected();
                if (pattern.contains("grabs") || pattern.contains("cam")) {
                    isFileName = false;
                }
                SelectFiles1.this.getListofFilesMatchingPattern(pattern, isFileName);
            }
        });
        this.clearSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                List selectedItems = SelectFiles1.this.directoriesJList.getSelectedValuesList();
                SelectFiles1.this.removeListofNamesFromList(selectedItems);
            }
        });
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((DefaultListModel)SelectFiles1.this.directoriesJList.getModel()).removeAllElements();
            }
        });
        this.addSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                List selectedItems = SelectFiles1.this.directoriesJList.getSelectedValuesList();
                SelectFiles1.this.addNamesToSelectedList(selectedItems);
                SelectFiles1.this.removeListofNamesFromList(selectedItems);
                SelectFiles1.this.firePropertyChange("SELECT1_CLOSED", false, true);
                SelectFiles1.this.close();
            }
        });
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ArrayList<String> allItems = new ArrayList<String>(SelectFiles1.this.directoriesJList.getModel().getSize());
                for (int i = 0; i < SelectFiles1.this.directoriesJList.getModel().getSize(); ++i) {
                    String name = (String)SelectFiles1.this.directoriesJList.getModel().getElementAt(i);
                    allItems.add(name);
                }
                SelectFiles1.this.addNamesToSelectedList(allItems);
                ((DefaultListModel)SelectFiles1.this.directoriesJList.getModel()).removeAllElements();
                SelectFiles1.this.firePropertyChange("SELECT1_CLOSED", false, true);
                SelectFiles1.this.close();
            }
        });
    }

    private void removeListofNamesFromList(List<String> selectedItems) {
        for (String oo : selectedItems) {
            ((DefaultListModel)this.directoriesJList.getModel()).removeElement(oo);
        }
    }

    private void setPreferencesPath(String pathString) {
        XMLPreferences guiPrefs = this.parent0.getPreferences("gui");
        guiPrefs.put("lastUsedPath", pathString);
    }

    private String getPreferencesPath() {
        XMLPreferences guiPrefs = this.parent0.getPreferences("gui");
        return guiPrefs.get("lastUsedPath", "");
    }

    private boolean getListofFilesMatchingFileNamePattern(String pattern, File directory) {
        String lastUsedPathString = directory.getAbsolutePath();
        Path lastPath = Paths.get(lastUsedPathString, new String[0]);
        List result = null;
        try (Stream<Path> walk = Files.walk(lastPath, new FileVisitOption[0]);){
            result = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().contains(pattern)).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean flag = false;
        if (result != null && result.size() > 0) {
            flag = true;
            for (Path path : result) {
                this.addNameToListIfNew(path.toString());
            }
        }
        return flag;
    }

    private boolean getListofFilesMatchingDirectoryNamePattern(String pattern, File directory) {
        String lastUsedPathString = directory.getAbsolutePath();
        Path lastPath = Paths.get(lastUsedPathString, new String[0]);
        List result = null;
        try (Stream<Path> walk = Files.walk(lastPath, new FileVisitOption[0]);){
            result = walk.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().contains(pattern)).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result != null) {
            for (Path path : result) {
                String experimentName;
                File dir = path.toFile();
                if (this.getListofFilesMatchingFileNamePattern("MCexpe", dir) || (experimentName = this.createEmptyExperiment(path)) == null) continue;
                this.addNameToListIfNew(experimentName);
            }
        }
        return result != null;
    }

    private String createEmptyExperiment(Path path) {
        ExperimentDirectories eADF = new ExperimentDirectories();
        eADF.getDirectoriesFromGrabPath(path.toString());
        if (eADF.cameraImagesList.size() == 0) {
            return null;
        }
        Experiment exp = new Experiment(eADF);
        return exp.getExperimentDirectory();
    }

    private void getListofFilesMatchingPattern(String pattern, boolean isFileName) {
        File dir = this.chooseDirectory(this.getPreferencesPath());
        if (dir == null) {
            return;
        }
        String lastUsedPathString = dir.getAbsolutePath();
        this.setPreferencesPath(lastUsedPathString);
        if (isFileName) {
            this.getListofFilesMatchingFileNamePattern(pattern, dir);
        } else if (!this.getListofFilesMatchingDirectoryNamePattern(pattern, dir) && pattern == "cam") {
            this.getListofFilesMatchingDirectoryNamePattern("grab", dir);
        }
    }

    private void addNameToListIfNew(String fileName) {
        int ilast = ((DefaultListModel)this.directoriesJList.getModel()).getSize();
        boolean found = false;
        for (int i = 0; i < ilast; ++i) {
            String oo = (String)((DefaultListModel)this.directoriesJList.getModel()).getElementAt(i);
            if (!oo.equalsIgnoreCase(fileName)) continue;
            found = true;
            break;
        }
        if (!found) {
            ((DefaultListModel)this.directoriesJList.getModel()).addElement(fileName);
        }
    }

    private File chooseDirectory(String rootdirectory) {
        File dummy_selected = null;
        JFileChooser fc = new JFileChooser();
        if (rootdirectory != null) {
            fc.setCurrentDirectory(new File(rootdirectory));
        }
        fc.setDialogTitle("Select a root directory...");
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showOpenDialog(null) == 0) {
            dummy_selected = fc.getSelectedFile();
        } else {
            System.out.println("SelectFiles:chooseDirectory() No directory selected ");
        }
        return dummy_selected;
    }

    private void addNamesToSelectedList(List<String> stringList) {
        for (String name : stringList) {
            String directoryName = Paths.get(name, new String[0]).getParent().toString();
            if (!this.isDirectoryWithJpg(directoryName)) continue;
            this.parent1.selectedNames.add(directoryName);
        }
        Collections.sort(this.parent1.selectedNames);
    }

    private boolean isDirectoryWithJpg(String directoryName) {
        String imageDirectory = ExperimentDirectories.getImagesDirectoryAsParentFromFileName(directoryName);
        File dir = new File(imageDirectory);
        File[] files = dir.listFiles((d, name) -> name.endsWith(".jpg"));
        boolean flag = files.length > 0;
        return flag;
    }
}

