/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.cages;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.dlg.cages.InfosCagesTable;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;

public class Infos
extends JPanel {
    private static final long serialVersionUID = -3325915033686366985L;
    private JButton editCageButton = new JButton("Edit cage infos...");
    private MultiCAFE parent0 = null;
    private InfosCagesTable dialog = null;
    private List<Cage> cellsArrayCopy = new ArrayList<Cage>();
    JRadioButton useCapillaries = new JRadioButton("capillary");
    JRadioButton useCage = new JRadioButton("cage");
    JRadioButton useManual = new JRadioButton("manual entry");
    ButtonGroup useGroup = new ButtonGroup();
    private JSpinner lengthSpinner = new JSpinner(new SpinnerNumberModel(78.0, 0.0, 100.0, 1.0));
    private JSpinner pixelsSpinner = new JSpinner(new SpinnerNumberModel(5, 0, 1000, 1));
    private JButton measureButton = new JButton("get 1rst capillary");

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel0a = new JPanel(flowLayout);
        panel0a.add(new JLabel("Use as reference: "));
        panel0a.add(this.useCapillaries);
        panel0a.add(this.useCage);
        panel0a.add(this.useManual);
        this.add(panel0a);
        this.useGroup.add(this.useCapillaries);
        this.useGroup.add(this.useCage);
        this.useGroup.add(this.useManual);
        this.useCage.setSelected(true);
        JPanel panel00 = new JPanel(flowLayout);
        panel00.add(new JLabel("length in mm:", 4));
        panel00.add(this.lengthSpinner);
        this.add(panel00);
        JPanel panel0 = new JPanel(flowLayout);
        panel0.add(new JLabel("length in pixels:", 4));
        panel0.add(this.pixelsSpinner);
        panel0.add(this.measureButton);
        this.add(panel0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.editCageButton);
        this.add(panel1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.editCageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.capillaries.transferDescriptionToCapillaries();
                    exp.cages.transferNFliesFromCapillariesToCageBox(exp.capillaries.capillariesList);
                    Infos.this.dialog = new InfosCagesTable();
                    Infos.this.dialog.initialize(Infos.this.parent0, Infos.this.cellsArrayCopy);
                }
            }
        });
        this.useCapillaries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos.this.lengthSpinner.setValue(23.0);
                Infos.this.measureButton.setText("get length 1rst capillary");
                Infos.this.measureButton.setVisible(true);
            }
        });
        this.useCage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos.this.lengthSpinner.setValue(78.0);
                Infos.this.measureButton.setText("get span between 1rst and last cell");
                Infos.this.measureButton.setVisible(true);
            }
        });
        this.useManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos.this.measureButton.setVisible(false);
            }
        });
        this.measureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Infos.this.useCapillaries.isSelected()) {
                    Infos.this.measureFirstCapillary();
                } else if (Infos.this.useCage.isSelected()) {
                    Infos.this.measureCellsSpan();
                }
            }
        });
    }

    void measureFirstCapillary() {
        int npixels = this.parent0.paneCapillaries.tabInfos.getLengthFirstCapillaryROI();
        if (npixels > 0) {
            this.pixelsSpinner.setValue(npixels);
        }
    }

    void measureCellsSpan() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            int npixels;
            exp.capillaries.updateCapillariesFromSequence(exp.seqCamData.seq);
            if (exp.capillaries.capillariesList.size() > 0 && (npixels = exp.cages.getHorizontalSpanOfCages()) > 0) {
                this.pixelsSpinner.setValue(npixels);
            }
        }
    }
}

