/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.experiment;

import icy.canvas.IcyCanvas;
import icy.canvas.Layer;
import icy.gui.viewer.Viewer;
import icy.roi.ROI;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;

public class Options
extends JPanel {
    private static final long serialVersionUID = 6565346204580890307L;
    JCheckBox kymographsCheckBox = new JCheckBox("kymos", true);
    JCheckBox cellsCheckBox = new JCheckBox("cells", true);
    JCheckBox measuresCheckBox = new JCheckBox("measures", true);
    public JCheckBox graphsCheckBox = new JCheckBox("graphs", true);
    public JCheckBox viewCapillariesCheckBox = new JCheckBox("capillaries", true);
    public JCheckBox viewCellsCheckbox = new JCheckBox("cells", true);
    JCheckBox viewFlyCheckbox = new JCheckBox("flies center", false);
    JCheckBox viewFlyRectCheckbox = new JCheckBox("flies rect", false);
    private MultiCAFE parent0 = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(1);
        JPanel panel2 = new JPanel(layout);
        panel2.add(new JLabel("Load: "));
        panel2.add(this.kymographsCheckBox);
        panel2.add(this.cellsCheckBox);
        panel2.add(this.measuresCheckBox);
        panel2.add(this.graphsCheckBox);
        panel2.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.add(panel2);
        JPanel panel1 = new JPanel(layout);
        panel1.add(new JLabel("View : "));
        panel1.add(this.viewCapillariesCheckBox);
        panel1.add(this.viewCellsCheckbox);
        panel1.add(this.viewFlyCheckbox);
        panel1.add(this.viewFlyRectCheckbox);
        this.add(panel1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.viewCapillariesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Options.this.displayROIsCategory(Options.this.viewCapillariesCheckBox.isSelected(), "line");
            }
        });
        this.viewCellsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Options.this.displayROIsCategory(Options.this.viewCellsCheckbox.isSelected(), "cell");
                Options.this.displayROIsCategory(Options.this.viewCellsCheckbox.isSelected(), "cage");
            }
        });
        this.viewFlyCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Options.this.displayROIsCategory(Options.this.viewFlyCheckbox.isSelected(), "det");
            }
        });
        this.viewFlyRectCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Options.this.displayROIsCategory(Options.this.viewFlyRectCheckbox.isSelected(), "det");
            }
        });
    }

    public void displayROIsCategory(boolean isVisible, String pattern) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Viewer v = exp.seqCamData.seq.getFirstViewer();
        IcyCanvas canvas = v.getCanvas();
        List layers = canvas.getLayers(false);
        if (layers == null) {
            return;
        }
        for (Layer layer : layers) {
            String cs;
            ROI roi = layer.getAttachedROI();
            if (roi == null || !(cs = roi.getName()).contains(pattern)) continue;
            layer.setVisible(isVisible);
        }
    }
}

