/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment.cages;

import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polygon2D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multicafe.experiment.cages.EnumCageMeasures;
import plugins.fmp.multicafe.experiment.cages.FlyPosition;
import plugins.fmp.multicafe.experiment.cages.FlyPositions;
import plugins.fmp.multicafe.experiment.capillaries.Capillaries;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class Cage {
    public ROI2D cageRoi2D = null;
    public BooleanMask2D cageMask2D = null;
    public FlyPositions flyPositions = new FlyPositions();
    public int cageNFlies = 0;
    public int cageAge = 5;
    public String cageComment = "..";
    public String cageSex = "..";
    public String cageStrain = "..";
    private String cageID = "-1";
    public boolean valid = false;
    public boolean bDetect = true;
    public boolean initialflyRemoved = false;
    private ArrayList<Capillary> capList = new ArrayList(2);
    private final String ID_CAGELIMITS = "CageLimits";
    private final String ID_FLYPOSITIONS = "FlyPositions";
    private final String ID_NFLIES = "nflies";
    private final String ID_AGE = "age";
    private final String ID_COMMENT = "comment";
    private final String ID_SEX = "sex";
    private final String ID_STRAIN = "strain";

    public String getRoiName() {
        if (this.cageRoi2D != null) {
            return this.cageRoi2D.getName();
        }
        return null;
    }

    public void addCapillaryIfUnique(Capillary cap) {
        if (this.capList.size() == 0) {
            this.capList.add(cap);
            return;
        }
        for (Capillary capCage : this.capList) {
            if (capCage.compareTo(cap) != 0) continue;
            return;
        }
        this.capList.add(cap);
    }

    public void addCapillaryIfUniqueBulkFilteredOnCageID(List<Capillary> capillaryList) {
        for (Capillary cap : capillaryList) {
            if (cap.capCageID != this.getCageID()) continue;
            this.addCapillaryIfUnique(cap);
        }
    }

    public void clearCapillaryList() {
        this.capList.clear();
    }

    public ArrayList<Capillary> getCapillaryList() {
        return this.capList;
    }

    public boolean xmlSaveCagel(Node node, int index) {
        if (node == null) {
            return false;
        }
        Element xmlVal = XMLUtil.addElement((Node)node, (String)("Cage" + index));
        this.xmlSaveCageLimits(xmlVal);
        this.xmlSaveCageParameters(xmlVal);
        if (this.cageNFlies > 0) {
            this.xmlSaveFlyPositions(xmlVal);
        }
        return true;
    }

    public boolean xmlSaveCageParameters(Element xmlVal) {
        XMLUtil.setElementIntValue((Node)xmlVal, (String)"nflies", (int)this.cageNFlies);
        XMLUtil.setElementIntValue((Node)xmlVal, (String)"age", (int)this.cageAge);
        XMLUtil.setElementValue((Node)xmlVal, (String)"comment", (String)this.cageComment);
        XMLUtil.setElementValue((Node)xmlVal, (String)"sex", (String)this.cageSex);
        XMLUtil.setElementValue((Node)xmlVal, (String)"strain", (String)this.cageStrain);
        return true;
    }

    public boolean xmlSaveCageLimits(Element xmlVal) {
        Element xmlVal2 = XMLUtil.addElement((Node)xmlVal, (String)"CageLimits");
        if (this.cageRoi2D != null) {
            this.cageRoi2D.setSelected(false);
            this.cageRoi2D.saveToXML((Node)xmlVal2);
        }
        return true;
    }

    public boolean xmlSaveFlyPositions(Element xmlVal) {
        Element xmlVal2 = XMLUtil.addElement((Node)xmlVal, (String)"FlyPositions");
        this.flyPositions.xmlSaveXYTPositions(xmlVal2);
        return true;
    }

    public boolean xmlLoadCage(Node node, int index) {
        if (node == null) {
            return false;
        }
        Element xmlVal = XMLUtil.getElement((Node)node, (String)("Cage" + index));
        if (xmlVal == null) {
            return false;
        }
        this.xmlLoadCageLimits(xmlVal);
        this.xmlLoadCageParameters(xmlVal);
        this.xmlLoadFlyPositions(xmlVal);
        return true;
    }

    public boolean xmlLoadCageLimits(Element xmlVal) {
        Element xmlVal2 = XMLUtil.getElement((Node)xmlVal, (String)"CageLimits");
        if (xmlVal2 != null) {
            this.cageRoi2D = (ROI2D)ROI.createFromXML((Node)xmlVal2);
            this.cageRoi2D.setSelected(false);
            this.cageRoi2D.setColor(Color.MAGENTA);
        }
        return true;
    }

    public boolean xmlLoadCageParameters(Element xmlVal) {
        this.cageNFlies = XMLUtil.getElementIntValue((Node)xmlVal, (String)"nflies", (int)this.cageNFlies);
        this.cageAge = XMLUtil.getElementIntValue((Node)xmlVal, (String)"age", (int)this.cageAge);
        this.cageComment = XMLUtil.getElementValue((Node)xmlVal, (String)"comment", (String)this.cageComment);
        this.cageSex = XMLUtil.getElementValue((Node)xmlVal, (String)"sex", (String)this.cageSex);
        this.cageStrain = XMLUtil.getElementValue((Node)xmlVal, (String)"strain", (String)this.cageStrain);
        return true;
    }

    public boolean xmlLoadFlyPositions(Element xmlVal) {
        Element xmlVal2 = XMLUtil.getElement((Node)xmlVal, (String)"FlyPositions");
        if (xmlVal2 != null) {
            this.flyPositions.xmlLoadXYTPositions(xmlVal2);
            return true;
        }
        return false;
    }

    public String csvExport_CAGE_Header(String sep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append("#" + sep + "CAGE\n");
        List<String> row2 = Arrays.asList("cageID", "nFlies", "age", "comment", "strain", "sex", "ROI", "npoints", "x(i)", "y(i)");
        sbf.append(String.join((CharSequence)sep, row2));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExport_CAGE_Data(String sep) {
        StringBuffer sbf = new StringBuffer();
        ArrayList<String> row = new ArrayList<String>();
        row.add(this.cageID);
        row.add(Integer.toString(this.cageNFlies));
        row.add(Integer.toString(this.cageAge));
        row.add(this.cageComment);
        row.add(this.cageStrain);
        row.add(this.cageSex);
        row.add(this.cageRoi2D.getName());
        if (this.cageRoi2D != null) {
            Polygon2D polygon = ((ROI2DPolygon)this.cageRoi2D).getPolygon2D();
            row.add(Integer.toString(polygon.npoints));
            for (int i = 0; i < polygon.npoints; ++i) {
                row.add(Double.toString(polygon.xpoints[i]));
                row.add(Double.toString(polygon.ypoints[i]));
            }
        } else {
            row.add("0");
        }
        sbf.append(String.join((CharSequence)sep, row));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExport_MEASURE_Header(EnumCageMeasures measureType, String sep, boolean complete) {
        StringBuffer sbf = new StringBuffer();
        String explanation = "cageID" + sep + "parm" + sep + "npts";
        switch (measureType) {
            case POSITION: {
                sbf.append("#" + sep + "POSITION\n" + explanation + "\n");
                break;
            }
            default: {
                sbf.append("#" + sep + "UNDEFINED------------\n");
            }
        }
        return sbf.toString();
    }

    public String csvExport_MEASURE_Data(EnumCageMeasures measureType, String sep, boolean complete) {
        StringBuffer sbf = new StringBuffer();
        switch (measureType) {
            case POSITION: {
                this.flyPositions.cvsExport_Parameter_ToRow(sbf, "t(i)", this.cageID, sep);
                this.flyPositions.cvsExport_Parameter_ToRow(sbf, "x(i)", this.cageID, sep);
                this.flyPositions.cvsExport_Parameter_ToRow(sbf, "y(i)", this.cageID, sep);
                this.flyPositions.cvsExport_Parameter_ToRow(sbf, "w(i)", this.cageID, sep);
                this.flyPositions.cvsExport_Parameter_ToRow(sbf, "h(i)", this.cageID, sep);
                break;
            }
        }
        return sbf.toString();
    }

    public void csvImport_CAGE_Header(String[] data) {
        int i = 0;
        this.cageID = data[i];
        this.cageNFlies = Integer.valueOf(data[++i]);
        this.cageAge = Integer.valueOf(data[++i]);
        this.cageComment = data[++i];
        this.cageStrain = data[++i];
        this.cageSex = data[++i];
        String cageROI_name = data[++i];
        int npoints = Integer.valueOf(data[++i]);
        ++i;
        if (npoints > 0) {
            double[] x = new double[npoints];
            double[] y = new double[npoints];
            for (int j = 0; j < npoints; ++j) {
                x[j] = Double.valueOf(data[i]);
                y[j] = Double.valueOf(data[++i]);
                ++i;
            }
            Polygon2D polygon = new Polygon2D(x, y, npoints);
            this.cageRoi2D = new ROI2DPolygon(polygon);
            this.cageRoi2D.setName(cageROI_name);
            this.cageRoi2D.setColor(Color.MAGENTA);
        }
    }

    public void csvImport_MEASURE_Data_v0(EnumCageMeasures measureType, String[] data, boolean complete) {
        switch (measureType) {
            case POSITION: {
                if (complete) {
                    this.flyPositions.csvImport_Rectangle_FromRow(data, 1);
                    break;
                }
                this.flyPositions.csvImport_XY_FromRow(data, 1);
                break;
            }
        }
    }

    public void csvImport_MEASURE_Data_Parameters(String[] data) {
        this.flyPositions.cvsImport_Parameter_FromRow(data);
    }

    public String getCageIDasString() {
        if (this.cageID == null) {
            this.cageID = this.cageRoi2D.getName().substring(this.cageRoi2D.getName().length() - 3);
        }
        return this.cageID;
    }

    public void setCageID(int iID) {
        this.cageID = Integer.toString(iID);
    }

    public int getCageID() {
        int cageIndex = -1;
        this.cageID = this.getCageIDasString();
        if (this.cageID != null) {
            try {
                return Integer.parseInt(this.cageID);
            }
            catch (NumberFormatException e) {
                return cageIndex;
            }
        }
        return cageIndex;
    }

    public void clearMeasures() {
        this.flyPositions.clear();
    }

    public Point2D getCenterTopCage() {
        Rectangle2D rect = this.cageRoi2D.getBounds2D();
        Point2D.Double pt = new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY());
        return pt;
    }

    public Point2D getCenterTipCapillaries(Capillaries capList) {
        ArrayList<Point2D> listpts = new ArrayList<Point2D>();
        for (Capillary cap : capList.capillariesList) {
            Point2D pt = cap.getCapillaryTipWithinROI2D(this.cageRoi2D);
            if (pt == null) continue;
            listpts.add(pt);
        }
        double x = 0.0;
        double y = 0.0;
        int n = listpts.size();
        for (Point2D pt : listpts) {
            x += pt.getX();
            y += pt.getY();
        }
        Point2D.Double pt = new Point2D.Double(x / (double)n, y / (double)n);
        return pt;
    }

    public void copyCage(Cage cageFrom) {
        this.cageRoi2D = cageFrom.cageRoi2D;
        this.cageNFlies = cageFrom.cageNFlies;
        this.cageComment = cageFrom.cageComment;
        this.cageID = cageFrom.cageID;
        this.cageStrain = cageFrom.cageStrain;
        this.cageSex = cageFrom.cageSex;
        this.valid = false;
        this.flyPositions.copyPositions(cageFrom.flyPositions);
    }

    public ROI2DRectangle getRoiRectangleFromPositionAtT(int t) {
        int nitems = this.flyPositions.flyPositionList.size();
        if (nitems == 0 || t >= nitems) {
            return null;
        }
        FlyPosition aValue = this.flyPositions.flyPositionList.get(t);
        ROI2DRectangle flyRoiR = new ROI2DRectangle(aValue.getRectangle2D());
        flyRoiR.setName("detR" + this.getCageIDasString() + "_" + t);
        flyRoiR.setT(t);
        flyRoiR.setColor(Color.YELLOW);
        return flyRoiR;
    }

    public void transferRoisToPositions(List<ROI2D> detectedROIsList) {
        String filter = "detR" + this.getCageIDasString();
        for (ROI2D roi : detectedROIsList) {
            String name = roi.getName();
            if (!name.contains(filter)) continue;
            Rectangle2D rect = ((ROI2DRectangle)roi).getRectangle();
            int t = roi.getT();
            this.flyPositions.flyPositionList.get(t).setRectangle2D(rect);
        }
    }

    public void computeCageBooleanMask2D() throws InterruptedException {
        this.cageMask2D = this.cageRoi2D.getBooleanMask2D(0, 0, 1, true);
    }

    public void initTmsForFlyPositions(long[] intervalsMs) {
        for (FlyPosition flyPosition : this.flyPositions.flyPositionList) {
            flyPosition.tMs = intervalsMs[flyPosition.flyIndexT];
        }
    }

    public void addFlyPositionsFromOtherCage(Cage cageExpi) {
        this.flyPositions.flyPositionList.addAll(cageExpi.flyPositions.flyPositionList);
    }
}

