/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment.cages;

import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DArea;

public class FlyPosition {
    public double x = Double.NaN;
    public double y = Double.NaN;
    public double w = Double.NaN;
    public double h = Double.NaN;
    public ROI2DArea flyRoi = null;
    public int flyIndexT = 0;
    public long tMs = 0L;
    public boolean bAlive = false;
    public boolean bSleep = false;
    public boolean bPadded = false;
    public double distance = 0.0;
    public double sumDistance = 0.0;
    public double axis1 = 0.0;
    public double axis2 = 0.0;

    public FlyPosition() {
    }

    public FlyPosition(int indexT) {
        this.flyIndexT = indexT;
    }

    public FlyPosition(int indexT, Rectangle2D rectangle) {
        if (rectangle != null) {
            this.setRectangle2D(rectangle);
        }
        this.flyIndexT = indexT;
    }

    public FlyPosition(int indexT, Rectangle2D rectangle, ROI2DArea roiArea) {
        if (rectangle != null) {
            this.setRectangle2D(rectangle);
        }
        this.flyRoi = new ROI2DArea(roiArea);
        this.flyRoi.setColor(Color.YELLOW);
        this.flyIndexT = indexT;
    }

    public FlyPosition(int indexT, Rectangle2D rectangle, boolean alive) {
        if (rectangle != null) {
            this.setRectangle2D(rectangle);
        }
        this.flyIndexT = indexT;
        this.bAlive = alive;
    }

    public FlyPosition(FlyPosition flyPosSource) {
        this.copy(flyPosSource);
    }

    public void copy(FlyPosition source) {
        this.flyIndexT = source.flyIndexT;
        this.bAlive = source.bAlive;
        this.bSleep = source.bSleep;
        this.bPadded = source.bPadded;
        this.tMs = source.tMs;
        this.distance = source.distance;
        this.x = source.x;
        this.y = source.y;
        this.w = source.w;
        this.h = source.h;
        if (source.flyRoi != null && source.flyRoi.getBounds().height > 0 && source.flyRoi.getBounds().width > 0) {
            this.flyRoi = new ROI2DArea(source.flyRoi);
            this.flyRoi.setColor(Color.YELLOW);
        }
        this.axis1 = source.axis1;
        this.axis2 = source.axis2;
    }

    Point2D getCenterRectangle() {
        return new Point2D.Double(this.x + this.w / 2.0, this.y + this.h / 2.0);
    }

    public Rectangle2D getRectangle2D() {
        return new Rectangle2D.Double(this.x, this.y, this.w, this.h);
    }

    public void setRectangle2D(Rectangle2D rectangle) {
        this.x = rectangle.getX();
        this.y = rectangle.getY();
        this.w = rectangle.getWidth();
        this.h = rectangle.getHeight();
    }

    public boolean xmlLoadPosition(Node node) {
        Element node_roi;
        if (node == null) {
            return false;
        }
        Element node_XYTa = XMLUtil.getElement((Node)node, (String)"XYTa");
        if (node_XYTa != null) {
            double xR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"xR", (double)Double.NaN);
            double yR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"yR", (double)Double.NaN);
            double wR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"wR", (double)Double.NaN);
            double hR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"hR", (double)Double.NaN);
            if (!Double.isNaN(xR) && !Double.isNaN(yR)) {
                this.x = xR;
                this.y = yR;
                this.w = wR;
                this.h = hR;
            } else {
                xR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"x", (double)Double.NaN);
                yR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"y", (double)Double.NaN);
                if (!Double.isNaN(xR) && !Double.isNaN(yR)) {
                    this.x -= 2.0;
                    this.y -= 2.0;
                    this.w = 4.0;
                    this.h = 4.0;
                }
            }
            this.flyIndexT = XMLUtil.getAttributeIntValue((Element)node_XYTa, (String)"t", (int)0);
            this.bAlive = XMLUtil.getAttributeBooleanValue((Element)node_XYTa, (String)"a", (boolean)false);
            this.bSleep = XMLUtil.getAttributeBooleanValue((Element)node_XYTa, (String)"s", (boolean)false);
        }
        if ((node_roi = XMLUtil.getElement((Node)node, (String)"roi")) != null) {
            if (this.flyRoi == null) {
                this.flyRoi = new ROI2DArea();
            }
            this.flyRoi.loadFromXML((Node)node_roi);
            this.flyRoi.setColor(Color.YELLOW);
        }
        return false;
    }

    public boolean xmlSavePosition(Node node) {
        if (node == null) {
            return false;
        }
        Element node_XYTa = XMLUtil.addElement((Node)node, (String)"XYTa");
        if (!Double.isNaN(this.x)) {
            XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"xR", (double)this.x);
            XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"yR", (double)this.y);
            XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"wR", (double)this.w);
            XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"hR", (double)this.h);
        }
        XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"t", (double)this.flyIndexT);
        XMLUtil.setAttributeBooleanValue((Element)node_XYTa, (String)"a", (boolean)this.bAlive);
        XMLUtil.setAttributeBooleanValue((Element)node_XYTa, (String)"s", (boolean)this.bSleep);
        Element node_roi = XMLUtil.addElement((Node)node, (String)"roi");
        if (this.flyRoi != null) {
            this.flyRoi.saveToXML((Node)node_roi);
        }
        return false;
    }

    public boolean cvsExportT(StringBuffer sbf, String sep) {
        sbf.append(StringUtil.toString((int)this.flyIndexT));
        sbf.append(sep);
        return true;
    }

    public boolean cvsExportX(StringBuffer sbf, String sep) {
        sbf.append(StringUtil.toString((double)this.x));
        sbf.append(sep);
        return true;
    }

    public boolean cvsExportY(StringBuffer sbf, String sep) {
        sbf.append(StringUtil.toString((double)this.y));
        sbf.append(sep);
        return true;
    }

    public boolean cvsExportWidth(StringBuffer sbf, String sep) {
        sbf.append(StringUtil.toString((double)this.w));
        sbf.append(sep);
        return true;
    }

    public boolean cvsExportHeight(StringBuffer sbf, String sep) {
        sbf.append(StringUtil.toString((double)this.h));
        sbf.append(sep);
        return true;
    }

    public boolean csvImportRectangle(String[] data, int startAt) {
        int npoints = 5;
        if (data.length < npoints + startAt - 1) {
            return false;
        }
        int offset = startAt;
        this.flyIndexT = Integer.valueOf(data[offset]);
        this.x = Double.valueOf(data[++offset]);
        this.y = Double.valueOf(data[++offset]);
        this.w = Double.valueOf(data[++offset]);
        this.h = Double.valueOf(data[++offset]);
        ++offset;
        return true;
    }

    public boolean csvImportXY(String[] data, int startAt) {
        int npoints = 3;
        if (data.length < npoints + startAt - 1) {
            return false;
        }
        int offset = startAt;
        this.flyIndexT = Integer.valueOf(data[offset]);
        this.x = Double.valueOf(data[++offset]);
        this.y = Double.valueOf(data[++offset]);
        ++offset;
        if (!Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            this.x -= 2.0;
            this.y -= 2.0;
            this.w = 4.0;
            this.h = 4.0;
        }
        return true;
    }

    public boolean cvsImportT(String strData) {
        this.flyIndexT = Integer.valueOf(strData);
        return true;
    }

    public boolean cvsImportX(String strData) {
        this.x = Double.valueOf(strData);
        return true;
    }

    public boolean cvsImportY(String strData) {
        this.y = Double.valueOf(strData);
        return true;
    }

    public boolean cvsImportWidth(String strData) {
        this.w = Double.valueOf(strData);
        return true;
    }

    public boolean cvsImportHeight(String strData) {
        this.h = Double.valueOf(strData);
        return true;
    }
}

