/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools;

import icy.type.geom.Polyline2D;
import java.awt.geom.Point2D;
import java.util.List;

public class Level2D
extends Polyline2D {
    public Level2D() {
    }

    public Level2D(Polyline2D polyline) {
        super(polyline.xpoints, polyline.ypoints, polyline.npoints);
    }

    public Level2D(double[] xpoints, double[] ypoints, int npoints) {
        super(xpoints, ypoints, npoints);
    }

    public Level2D(int[] xpoints, int[] ypoints, int npoints) {
        super(xpoints, ypoints, npoints);
    }

    public Level2D(List<Point2D> limit) {
        this.npoints = limit.size();
        this.xpoints = new double[this.npoints];
        this.ypoints = new double[this.npoints];
        int index = 0;
        for (Point2D pt : limit) {
            this.xpoints[index] = pt.getX();
            this.ypoints[index] = pt.getY();
            ++index;
        }
    }

    public boolean insertSeriesofYPoints(List<Point2D> points, int start, int end) {
        if (start < 0 || end > this.npoints - 1) {
            return false;
        }
        int i_list = 0;
        int i_array = start;
        while (i_array < end) {
            this.ypoints[i_array] = points.get(i_list).getY();
            ++i_array;
            ++i_list;
        }
        return true;
    }

    public boolean insertYPoints(int[] points, int start, int end) {
        if (start < 0 || end > this.npoints - 1) {
            return false;
        }
        int i_list = 0;
        int i_array = start;
        while (i_array <= end) {
            this.ypoints[i_array] = points[i_list];
            ++i_array;
            ++i_list;
        }
        return true;
    }

    public Level2D clone() {
        Level2D pol = new Level2D();
        for (int i = 0; i < this.npoints; ++i) {
            pol.addPoint(this.xpoints[i], this.ypoints[i]);
        }
        return pol;
    }

    public Level2D expandPolylineToNewSize(int imageSize) {
        double[] nxpoints = new double[imageSize];
        double[] nypoints = new double[imageSize];
        for (int j = 0; j < this.npoints; ++j) {
            double y0;
            int i0 = j * imageSize / this.npoints;
            int i1 = (j + 1) * imageSize / this.npoints;
            double y1 = y0 = this.ypoints[j];
            if (j + 1 < this.npoints) {
                y1 = this.ypoints[j + 1];
            }
            for (int i = i0; i < i1; ++i) {
                nxpoints[i] = i;
                nypoints[i] = y0 + (y1 - y0) * (double)(i - i0) / (double)(i1 - i0);
            }
        }
        return new Level2D(nxpoints, nypoints, imageSize);
    }

    public Level2D contractPolylineToNewSize(int imageSize) {
        double[] nxpoints = new double[imageSize];
        double[] nypoints = new double[imageSize];
        for (int i = 0; i < imageSize; ++i) {
            int j = i * this.npoints / imageSize;
            nxpoints[i] = i;
            nypoints[i] = this.ypoints[j];
        }
        return new Level2D(nxpoints, nypoints, imageSize);
    }

    public Level2D cropPolylineToNewSize(int imageSize) {
        double[] nxpoints = new double[imageSize];
        double[] nypoints = new double[imageSize];
        for (int i = 0; i < imageSize; ++i) {
            int j = i;
            nypoints[i] = j < this.npoints ? this.ypoints[j] : this.ypoints[this.npoints - 1];
            nxpoints[i] = i;
        }
        return new Level2D(nxpoints, nypoints, imageSize);
    }
}

