/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.Overlay;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.image.IcyBufferedImage;
import icy.painter.Overlay;
import icy.painter.OverlayListener;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class OverlayTrapMouse
extends Overlay {
    private Point5D.Double Pt;
    private JButton pickColorButton = null;
    private JComboBox<Color> colorPickCombo = null;
    private String textPickAPixel = null;

    public OverlayTrapMouse() {
        super("Simple overlay");
    }

    public OverlayTrapMouse(JButton pickColorButton, JComboBox<Color> colorPickCombo) {
        super("overlay with Jbutton and JComboBox");
        this.pickColorButton = pickColorButton;
        this.colorPickCombo = colorPickCombo;
        this.textPickAPixel = pickColorButton.getText();
    }

    public OverlayTrapMouse(OverlayListener listener) {
        super("Simple overlay");
        this.addOverlayListener(listener);
    }

    public void attachInterfaceElements(JButton pickColorButton, JComboBox<Color> colorPickCombo) {
        this.pickColorButton = pickColorButton;
        this.colorPickCombo = colorPickCombo;
        this.textPickAPixel = pickColorButton.getText();
    }

    public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (canvas instanceof IcyCanvas2D && imagePoint != null) {
            this.onMouseClicked(canvas.getSequence(), canvas.getPositionT(), imagePoint);
        }
    }

    public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (canvas instanceof IcyCanvas2D && imagePoint != null) {
            this.onMouseMoved(canvas.getSequence(), canvas.getPositionT(), imagePoint);
        }
    }

    private void onMouseClicked(Sequence seq, int posT, Point5D.Double imagePoint) {
        Color c = this.getRGB(seq, posT, imagePoint);
        if (c != null && this.pickColorButton != null) {
            this.pickColorButton.setBackground(c);
            boolean isnewcolor = true;
            int isel = 0;
            for (int i = 0; i < this.colorPickCombo.getItemCount(); ++i) {
                if (!c.equals(this.colorPickCombo.getItemAt(i))) continue;
                isnewcolor = false;
                isel = i;
            }
            if (isnewcolor) {
                this.colorPickCombo.addItem(c);
                isel = this.colorPickCombo.getItemCount() - 1;
            }
            this.colorPickCombo.setSelectedIndex(isel);
            this.pickColorButton.setBackground(Color.LIGHT_GRAY);
            this.pickColorButton.setText(this.textPickAPixel);
        }
    }

    private void onMouseMoved(Sequence seq, int posT, Point5D.Double imagePoint) {
        Color c = this.getRGB(seq, posT, imagePoint);
        if (c != null && this.pickColorButton != null) {
            this.pickColorButton.setBackground(c);
            String cs = Integer.toString(c.getRed()) + ":" + Integer.toString(c.getGreen()) + ":" + Integer.toString(c.getBlue());
            this.pickColorButton.setText(cs);
        }
    }

    private Color getRGB(Sequence seq, int posT, Point5D.Double imagePoint) {
        int x = (int)imagePoint.getX();
        int y = (int)imagePoint.getY();
        this.setPt(imagePoint);
        IcyBufferedImage image = seq.getImage(posT, 0);
        boolean isInside = image.isInside(new Point(x, y));
        if (isInside) {
            int argb = image.getRGB(x, y);
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb >> 0 & 0xFF;
            return new Color(r, g, b);
        }
        return null;
    }

    public Point5D.Double getPt() {
        return this.Pt;
    }

    public void setPt(Point5D.Double pt) {
        this.Pt = pt;
    }
}

