/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.viewer1D;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import plugins.fmp.multicafe.viewer1D.CheckComboBoxSelectionChangedListener;

class CheckComboBox
extends JComboBox<Object> {
    private static final long serialVersionUID = -7947410911737341771L;
    private List<ObjCheckBox> cbs;
    private Map<Object, Boolean> mapObjSelected;
    private List<CheckComboBoxSelectionChangedListener> changedListeners = new Vector<CheckComboBoxSelectionChangedListener>();
    private Object nullObject = new Object();

    public CheckComboBox(Set<?> objs) {
        this(objs, false);
    }

    public CheckComboBox(Set<?> objs, boolean selected) {
        this.resetObjs(objs, selected);
    }

    public CheckComboBox(Set<?> objs, Set<?> selected) {
        this.mapObjSelected = new LinkedHashMap<Object, Boolean>();
        for (Object obj : objs) {
            if (obj == null) {
                obj = this.nullObject;
            }
            this.mapObjSelected.put(obj, selected.contains(obj));
        }
        this.reset();
    }

    public CheckComboBox(Map<Object, Boolean> mapObjSelected) {
        this.mapObjSelected = mapObjSelected;
        this.reset();
    }

    public void addSelectionChangedListener(CheckComboBoxSelectionChangedListener l) {
        if (l == null) {
            return;
        }
        this.changedListeners.add(l);
    }

    public void removeSelectionChangedListener(CheckComboBoxSelectionChangedListener l) {
        this.changedListeners.remove(l);
    }

    public void resetObjs(Set<?> objs, boolean selected) {
        this.mapObjSelected = new LinkedHashMap<Object, Boolean>();
        for (Object obj : objs) {
            this.mapObjSelected.put(obj, selected);
        }
        this.reset();
    }

    public Object[] getSelectedItems() {
        TreeSet<Object> ret = new TreeSet<Object>();
        for (Map.Entry<Object, Boolean> entry : this.mapObjSelected.entrySet()) {
            Object obj = entry.getKey();
            Boolean selected = entry.getValue();
            if (!selected.booleanValue()) continue;
            ret.add(obj);
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new Object[ret.size()]);
    }

    public boolean isItemSelected(String text) {
        TreeSet ret = new TreeSet();
        for (Map.Entry<Object, Boolean> entry : this.mapObjSelected.entrySet()) {
            Object obj = entry.getKey();
            Boolean selected = entry.getValue();
            if (obj.toString().compareTo(text) != 0) continue;
            return selected;
        }
        return false;
    }

    public void setItemColor(String text, Color color) {
        block0: for (Map.Entry<Object, Boolean> entry : this.mapObjSelected.entrySet()) {
            Object obj = entry.getKey();
            if (!text.equals(obj)) continue;
            for (ObjCheckBox b : this.cbs) {
                if (!b.getObj().equals(obj)) continue;
                b.setBackground(color);
                continue block0;
            }
        }
    }

    public void addSelectedItems(Collection<?> c) {
        if (c == null) {
            return;
        }
        for (Object obj : c) {
            if (!this.mapObjSelected.containsKey(obj)) continue;
            this.mapObjSelected.put(obj, true);
        }
        this.reset();
        this.repaint();
    }

    public void addSelectedItems(Object[] objs) {
        if (objs == null) {
            return;
        }
        for (Object obj : objs) {
            if (!this.mapObjSelected.containsKey(obj)) continue;
            this.mapObjSelected.put(obj, true);
        }
        this.reset();
        this.repaint();
    }

    private void reset() {
        this.removeAllItems();
        this.initCBs();
        this.addItem(new String());
        for (JCheckBox jCheckBox : this.cbs) {
            this.addItem(jCheckBox);
        }
        this.setRenderer(new CheckBoxRenderer(this.cbs));
        this.addActionListener(this);
    }

    private void initCBs() {
        ObjCheckBox cb;
        this.cbs = new Vector<ObjCheckBox>();
        boolean selectedAll = true;
        boolean selectedNone = true;
        for (Map.Entry<Object, Boolean> entry : this.mapObjSelected.entrySet()) {
            Object obj = entry.getKey();
            Boolean selected = entry.getValue();
            if (selected.booleanValue()) {
                selectedNone = false;
            } else {
                selectedAll = false;
            }
            cb = new ObjCheckBox(obj);
            cb.setSelected(selected);
            this.cbs.add(cb);
        }
        cb = new ObjCheckBox("Select all");
        cb.setSelected(selectedAll);
        this.cbs.add(cb);
        cb = new ObjCheckBox("Select none");
        cb.setSelected(selectedNone);
        this.cbs.add(cb);
    }

    private void checkBoxSelectionChanged(int index) {
        int n = this.cbs.size();
        if (index < 0 || index >= n) {
            return;
        }
        if (index < n - 2) {
            ObjCheckBox cb = this.cbs.get(index);
            if (cb.getObj() == this.nullObject) {
                return;
            }
            if (cb.isSelected()) {
                cb.setSelected(false);
                this.mapObjSelected.put(cb.getObj(), false);
                this.cbs.get(n - 2).setSelected(false);
                this.cbs.get(n - 1).setSelected(this.getSelectedItems() == null);
            } else {
                cb.setSelected(true);
                this.mapObjSelected.put(cb.getObj(), true);
                Object[] sobjs = this.getSelectedItems();
                this.cbs.get(n - 2).setSelected(sobjs != null && sobjs.length == n - 2);
                this.cbs.get(n - 1).setSelected(false);
            }
        } else if (index == n - 2) {
            for (Object obj : this.mapObjSelected.keySet()) {
                if (obj == this.nullObject) continue;
                this.mapObjSelected.put(obj, true);
            }
            for (int i = 0; i < n - 1; ++i) {
                if (this.cbs.get(i) == this.nullObject) continue;
                this.cbs.get(i).setSelected(true);
            }
            this.cbs.get(n - 1).setSelected(false);
        } else {
            for (Object obj : this.mapObjSelected.keySet()) {
                this.mapObjSelected.put(obj, false);
            }
            for (int i = 0; i < n - 1; ++i) {
                this.cbs.get(i).setSelected(false);
            }
            this.cbs.get(n - 1).setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int sel = this.getSelectedIndex();
        if (sel == 0) {
            this.getUI().setPopupVisible(this, false);
        } else if (sel > 0) {
            this.checkBoxSelectionChanged(sel - 1);
            for (CheckComboBoxSelectionChangedListener l : this.changedListeners) {
                l.selectionChanged(sel - 1);
            }
        }
        this.setSelectedIndex(-1);
    }

    @Override
    public void setPopupVisible(boolean flag) {
    }

    class ObjCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = 1L;
        private final Object obj;

        public ObjCheckBox(Object obj) {
            super(obj.toString());
            this.obj = obj;
        }

        public Object getObj() {
            return this.obj;
        }
    }

    class CheckBoxRenderer
    implements ListCellRenderer<Object> {
        private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private JSeparator separator;
        private final List<ObjCheckBox> cbs;

        public CheckBoxRenderer(List<ObjCheckBox> cbs) {
            this.cbs = cbs;
            this.separator = new JSeparator(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            if (index > 0 && index <= this.cbs.size()) {
                ObjCheckBox cb = this.cbs.get(index - 1);
                if (cb.getObj() == CheckComboBox.this.nullObject) {
                    return this.separator;
                }
                return cb;
            }
            Object[] objs = CheckComboBox.this.getSelectedItems();
            Vector<String> strs = new Vector<String>();
            if (objs == null) {
                str = "Select display options";
            } else {
                for (Object obj : objs) {
                    strs.add(obj.toString());
                }
                str = strs.toString();
            }
            return this.defaultRenderer.getListCellRendererComponent(list, str, index, isSelected, cellHasFocus);
        }
    }
}

