/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.kymos;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.canvas.Layer;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceKymos;
import plugins.fmp.multicafe.experiment.capillaries.Capillaries;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.Canvas2D.Canvas2DWithTransforms;
import plugins.fmp.multicafe.tools.Directories;
import plugins.fmp.multicafe.tools.ViewerFMP;

public class Display
extends JPanel
implements ViewerListener {
    private static final long serialVersionUID = -2103052112476748890L;
    public int indexImagesCombo = -1;
    JComboBox<String> kymographsCombo = new JComboBox<String>(new String[]{"none"});
    JComboBox<String> viewsCombo = new JComboBox();
    JButton previousButton = new JButton("<");
    JButton nextButton = new JButton(">");
    JCheckBox viewLevelsCheckbox = new JCheckBox("top/bottom level (green)", true);
    JCheckBox viewDerivativeCheckbox = new JCheckBox("derivative (yellow)", true);
    JCheckBox viewGulpsCheckbox = new JCheckBox("gulps (red)", true);
    private MultiCAFE parent0 = null;
    private boolean isActionEnabled = true;
    private static Rectangle globalKymographViewerBounds = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(0);
        JPanel panel1 = new JPanel(layout);
        panel1.add(new JLabel("bin size"));
        panel1.add(this.viewsCombo);
        panel1.add(new JLabel(" kymograph from"));
        int bWidth = 30;
        int bHeight = 21;
        panel1.add((Component)this.previousButton, "West");
        this.previousButton.setPreferredSize(new Dimension(bWidth, bHeight));
        panel1.add(this.kymographsCombo, "Center");
        this.nextButton.setPreferredSize(new Dimension(bWidth, bHeight));
        panel1.add((Component)this.nextButton, "East");
        this.add(panel1);
        JPanel panel2 = new JPanel(layout);
        panel2.add(this.viewLevelsCheckbox);
        panel2.add(this.viewDerivativeCheckbox);
        panel2.add(this.viewGulpsCheckbox);
        this.add(panel2);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.kymographsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Display.this.isActionEnabled) {
                    Display.this.displayUpdateOnSwingThread();
                }
            }
        });
        this.viewDerivativeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display.this.displayROIs("deriv", Display.this.viewDerivativeCheckbox.isSelected());
            }
        });
        this.viewGulpsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display.this.displayROIs("gulp", Display.this.viewGulpsCheckbox.isSelected());
            }
        });
        this.viewLevelsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display.this.displayROIs("level", Display.this.viewLevelsCheckbox.isSelected());
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int isel = Display.this.kymographsCombo.getSelectedIndex() + 1;
                if (isel < Display.this.kymographsCombo.getItemCount()) {
                    isel = Display.this.selectKymographImage(isel);
                    Display.this.selectKymographComboItem(isel);
                }
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int isel = Display.this.kymographsCombo.getSelectedIndex() - 1;
                if (isel < Display.this.kymographsCombo.getItemCount()) {
                    isel = Display.this.selectKymographImage(isel);
                    Display.this.selectKymographComboItem(isel);
                }
            }
        });
        this.viewsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String localString = (String)Display.this.viewsCombo.getSelectedItem();
                if (localString != null && localString.contains(".")) {
                    localString = null;
                }
                if (Display.this.isActionEnabled) {
                    Display.this.changeBinSubdirectory(localString);
                }
            }
        });
    }

    public void transferCapillaryNamesToComboBox(final Experiment exp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.this.kymographsCombo.removeAllItems();
                Collections.sort(exp.capillaries.capillariesList);
                int ncapillaries = exp.capillaries.capillariesList.size();
                for (int i = 0; i < ncapillaries; ++i) {
                    Capillary cap = exp.capillaries.capillariesList.get(i);
                    Display.this.kymographsCombo.addItem(cap.getRoiName());
                }
            }
        });
    }

    public void displayROIsAccordingToUserSelection() {
        this.displayROIs("deriv", this.viewDerivativeCheckbox.isSelected());
        this.displayROIs("gulp", this.viewGulpsCheckbox.isSelected());
        this.displayROIs("level", this.viewLevelsCheckbox.isSelected());
    }

    private void displayROIs(String filter, boolean visible) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Viewer v = exp.seqKymos.seq.getFirstViewer();
        if (v == null) {
            return;
        }
        IcyCanvas canvas = v.getCanvas();
        List layers = canvas.getLayers(false);
        if (layers != null) {
            for (Layer layer : layers) {
                String cs;
                ROI roi = layer.getAttachedROI();
                if (roi == null || !(cs = roi.getName()).contains(filter)) continue;
                layer.setVisible(visible);
            }
        }
    }

    void displayON() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            SequenceKymos seqKymographs = exp.seqKymos;
            if (seqKymographs == null || seqKymographs.seq == null) {
                return;
            }
            Rectangle initialBounds = this.calculateKymographViewerBounds(exp);
            ArrayList vList = seqKymographs.seq.getViewers();
            if (vList.size() == 0) {
                ViewerFMP viewerKymographs = new ViewerFMP(seqKymographs.seq, false, true);
                List list = IcyCanvas.getCanvasPluginNames();
                String pluginName = list.stream().filter(s -> s.contains("Canvas2DWithTransforms")).findFirst().orElse(null);
                viewerKymographs.setCanvas(pluginName);
                viewerKymographs.setRepeat(false);
                viewerKymographs.addListener(this);
                JToolBar toolBar = viewerKymographs.getToolBar();
                Canvas2DWithTransforms canvas = (Canvas2DWithTransforms)viewerKymographs.getCanvas();
                canvas.customizeToolbarStep2(toolBar);
                if (initialBounds != null) {
                    viewerKymographs.setBounds(initialBounds);
                    ((Canvas2D)viewerKymographs.getCanvas()).setFitToCanvas(false);
                }
                viewerKymographs.setVisible(true);
                int isel = seqKymographs.currentFrame;
                isel = this.selectKymographImage(isel);
                this.selectKymographComboItem(isel);
            } else {
                Viewer existingViewer = (Viewer)vList.get(0);
                if (initialBounds != null) {
                    boolean wasVisible = existingViewer.isVisible();
                    if (wasVisible) {
                        existingViewer.setVisible(false);
                    }
                    existingViewer.setBounds(initialBounds);
                    if (existingViewer.getCanvas() instanceof Canvas2D) {
                        ((Canvas2D)existingViewer.getCanvas()).setFitToCanvas(false);
                    }
                    if (wasVisible) {
                        existingViewer.setVisible(true);
                    }
                }
                existingViewer.addListener((ViewerListener)this);
            }
        }
    }

    private Rectangle calculateKymographViewerBounds(Experiment exp) {
        if (globalKymographViewerBounds != null) {
            return globalKymographViewerBounds;
        }
        Sequence seqCamData = exp.seqCamData.seq;
        Viewer viewerCamData = seqCamData.getFirstViewer();
        if (viewerCamData == null) {
            return null;
        }
        Sequence seqKymograph = exp.seqKymos.seq;
        Rectangle rectViewerCamData = viewerCamData.getBounds();
        Rectangle rectImageKymograph = seqKymograph.getBounds2D();
        int desktopwidth = Icy.getMainInterface().getMainFrame().getDesktopWidth();
        Rectangle rectViewerKymograph = (Rectangle)rectViewerCamData.clone();
        rectViewerKymograph.width = (int)rectImageKymograph.getWidth();
        if (rectViewerKymograph.width + rectViewerKymograph.x > desktopwidth) {
            rectViewerKymograph.x = 0;
            rectViewerKymograph.y = rectViewerCamData.y + rectViewerCamData.height + 5;
            rectViewerKymograph.width = desktopwidth;
            rectViewerKymograph.height = rectImageKymograph.height;
        } else {
            rectViewerKymograph.translate(5 + rectViewerCamData.width, 0);
        }
        return rectViewerKymograph;
    }

    void placeKymoViewerNextToCamViewer(Experiment exp) {
        Sequence seqKymograph = exp.seqKymos.seq;
        Viewer viewerKymograph = seqKymograph.getFirstViewer();
        if (viewerKymograph == null) {
            return;
        }
        Rectangle bounds = this.calculateKymographViewerBounds(exp);
        if (bounds != null) {
            viewerKymograph.setBounds(bounds);
            ((Canvas2D)viewerKymograph.getCanvas()).setFitToCanvas(false);
        }
    }

    void displayOFF() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null || exp.seqKymos == null) {
            return;
        }
        ArrayList vList = exp.seqKymos.seq.getViewers();
        if (vList.size() > 0) {
            for (Viewer v : vList) {
                this.saveKymographViewerPosition(v);
                v.close();
            }
            vList.clear();
        }
    }

    private void saveKymographViewerPosition(Viewer viewer) {
        if (viewer != null) {
            globalKymographViewerBounds = viewer.getBounds();
        }
    }

    public void displayUpdateOnSwingThread() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int isel = Display.this.selectKymographImage(Display.this.displayUpdate());
                Display.this.selectKymographComboItem(isel);
            }
        });
    }

    int displayUpdate() {
        int item = -1;
        if (this.kymographsCombo.getItemCount() < 1) {
            return item;
        }
        this.displayON();
        item = this.kymographsCombo.getSelectedIndex();
        if (item < 0) {
            item = this.indexImagesCombo >= 0 ? this.indexImagesCombo : 0;
            this.indexImagesCombo = -1;
        }
        return item;
    }

    private void selectKymographComboItem(int isel) {
        int icurrent = this.kymographsCombo.getSelectedIndex();
        if (isel >= 0 && isel != icurrent) {
            this.kymographsCombo.setSelectedIndex(isel);
        }
    }

    public int selectKymographImage(int isel) {
        int selectedImageIndex = -1;
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return selectedImageIndex;
        }
        SequenceKymos seqKymos = exp.seqKymos;
        if (seqKymos == null || seqKymos.seq == null) {
            return selectedImageIndex;
        }
        if (seqKymos.seq.isUpdating()) {
            return selectedImageIndex;
        }
        if (isel < 0) {
            isel = 0;
        }
        if (isel >= seqKymos.seq.getSizeT()) {
            isel = seqKymos.seq.getSizeT() - 1;
        }
        seqKymos.seq.beginUpdate();
        Viewer v = seqKymos.seq.getFirstViewer();
        if (v != null) {
            int icurrent = v.getPositionT();
            if (icurrent != isel) {
                v.setPositionT(isel);
            }
            seqKymos.validateRoisAtT(seqKymos.currentFrame);
            seqKymos.currentFrame = isel;
        }
        seqKymos.seq.endUpdate();
        selectedImageIndex = seqKymos.currentFrame;
        this.parent0.paneKymos.tabDisplay.displayROIsAccordingToUserSelection();
        this.selectCapillary(exp, selectedImageIndex);
        return selectedImageIndex;
    }

    private void selectCapillary(Experiment exp, int isel) {
        Capillaries capillaries = exp.capillaries;
        for (Capillary cap : capillaries.capillariesList) {
            if (cap.getRoi() == null) continue;
            cap.getRoi().setSelected(false);
            Capillary capSel = capillaries.capillariesList.get(isel);
            capSel.getRoi().setSelected(true);
        }
    }

    public void viewerChanged(ViewerEvent event) {
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED && event.getDim() == DimensionId.T) {
            Viewer v = event.getSource();
            int t = v.getPositionT();
            if (t >= 0) {
                this.selectKymographComboItem(t);
            }
            String title = this.kymographsCombo.getItemAt(t) + "  :" + this.viewsCombo.getSelectedItem() + " s";
            v.setTitle(title);
        }
    }

    public void viewerClosed(Viewer viewer) {
        this.saveKymographViewerPosition(viewer);
        viewer.removeListener((ViewerListener)this);
    }

    public void updateResultsAvailable(Experiment exp) {
        this.isActionEnabled = false;
        this.viewsCombo.removeAllItems();
        List<String> list = Directories.getSortedListOfSubDirectoriesWithTIFF(exp.getExperimentDirectory());
        for (int i = 0; i < list.size(); ++i) {
            String dirName = list.get(i);
            if (dirName == null || dirName.contains("results")) {
                dirName = ".";
            }
            this.viewsCombo.addItem(dirName);
        }
        this.isActionEnabled = true;
        String select = exp.getBinSubDirectory();
        if (select == null) {
            select = ".";
        }
        this.viewsCombo.setSelectedItem(select);
    }

    private void changeBinSubdirectory(String localString) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null || localString == null || exp.getBinSubDirectory().contains(localString)) {
            return;
        }
        this.parent0.expListCombo.expListBinSubDirectory = localString;
        exp.setBinSubDirectory(localString);
        exp.seqKymos.seq.close();
        exp.loadKymographs();
        this.parent0.paneKymos.updateDialogs(exp);
    }
}

