/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.kymos;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;

public class Intervals
extends JPanel {
    private static final long serialVersionUID = -1530811745749103710L;
    private MultiCAFE parent0 = null;
    private JComboBox<String> binUnit = new JComboBox<String>(new String[]{"ms", "s", "min", "h", "day"});
    JButton applyButton = new JButton("Apply");
    JButton getFromCamDataButton = new JButton("Get from stack of images");
    JSpinner firstColumnJSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 10000.0, 1.0));
    JSpinner lastColumnJSpinner = new JSpinner(new SpinnerNumberModel(9.9999999E7, 0.0, 9.9999999E7, 1.0));
    JSpinner binColumnJSpinner = new JSpinner(new SpinnerNumberModel(1.0, 1.0, 1000.0, 1.0));

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layout1 = new FlowLayout(0);
        layout1.setVgap(0);
        JPanel panel1 = new JPanel(layout1);
        panel1.add(new JLabel("Column ", 4));
        panel1.add(this.firstColumnJSpinner);
        panel1.add(new JLabel(" to "));
        panel1.add(this.lastColumnJSpinner);
        panel1.add(this.getFromCamDataButton);
        this.add(panel1);
        JPanel panel2 = new JPanel(layout1);
        panel2.add(new JLabel("  bin size "));
        panel2.add(this.binColumnJSpinner);
        panel2.add(this.binUnit);
        this.binUnit.setSelectedIndex(2);
        panel2.add(this.applyButton);
        this.add(panel2);
        this.getFromCamDataButton.setEnabled(false);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Intervals.this.setKymoIntervalsFromDialog(exp);
                }
            }
        });
    }

    public int getBuildStep() {
        int buildStep = (Integer)this.binColumnJSpinner.getValue() * this.getBinSize_Ms();
        return buildStep;
    }

    private int getBinSize_Ms() {
        int binsize = 1;
        int iselected = this.binUnit.getSelectedIndex();
        switch (iselected) {
            case 1: {
                binsize = 1000;
                break;
            }
            case 2: {
                binsize = 60000;
                break;
            }
            case 3: {
                binsize = 3600000;
                break;
            }
            case 4: {
                binsize = 86400000;
                break;
            }
        }
        return binsize;
    }

    void setKymoIntervalsFromDialog(Experiment exp) {
        double binsize_Ms = this.getBinSize_Ms();
        exp.kymoFirst_ms = (long)((Double)this.firstColumnJSpinner.getValue() * binsize_Ms);
        exp.kymoLast_ms = (long)((Double)this.lastColumnJSpinner.getValue() * binsize_Ms);
        exp.kymoBin_ms = (long)((Double)this.binColumnJSpinner.getValue() * binsize_Ms);
    }

    void displayDlgKymoIntervals(Experiment exp) {
        double binsize_Ms = this.getBinSize_Ms();
        this.firstColumnJSpinner.setValue(0.0);
        this.lastColumnJSpinner.setValue(exp.seqKymos.imageWidthMax);
        if (exp.kymoBin_ms <= 0L) {
            exp.kymoBin_ms = (long)binsize_Ms;
        }
        this.binColumnJSpinner.setValue((double)exp.kymoBin_ms / binsize_Ms);
    }
}

