/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.levels;

import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceKymos;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.series.AdjustMeasuresToDimensions;
import plugins.fmp.multicafe.series.BuildSeriesOptions;
import plugins.fmp.multicafe.series.ClipCageMeasuresToSmallest;
import plugins.fmp.multicafe.series.CropMeasuresToDimensions;
import plugins.fmp.multicafe.series.CurvesRestoreLength;

public class Adjust
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 2580935598417087197L;
    private MultiCAFE parent0;
    private JCheckBox allSeriesCheckBox = new JCheckBox("ALL series", false);
    private final String adjustString = "Resize levels to Kymographs";
    private final String cropString = "Crop levels to Kymograph";
    private final String clipString = "Clip levels npts to the shortest curve";
    private final String restoreString = "Restore levels";
    private final String stopString = "STOP ";
    private JButton adjustButton = new JButton("Resize levels to Kymographs");
    private JButton restoreButton = new JButton("Restore levels");
    private JButton clipButton = new JButton("Clip levels npts to the shortest curve");
    private JButton cropButton = new JButton("Crop levels to Kymograph");
    private AdjustMeasuresToDimensions threadAdjust = null;
    private CurvesRestoreLength threadRestore = null;
    private ClipCageMeasuresToSmallest threadClip = null;
    private CropMeasuresToDimensions threadCrop = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(0);
        JPanel panel0 = new JPanel(layout);
        panel0.add(this.adjustButton);
        panel0.add(this.cropButton);
        this.add(panel0);
        JPanel panel1 = new JPanel(layout);
        panel1.add(this.clipButton);
        panel1.add(this.restoreButton);
        this.add(panel1);
        JPanel panel2 = new JPanel(layout);
        panel2.add(this.allSeriesCheckBox);
        this.add(panel2);
        this.defineListeners();
    }

    private void defineListeners() {
        this.adjustButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Adjust.this.adjustButton.getText().equals("Resize levels to Kymographs")) {
                    Adjust.this.series_adjustDimensionsStart();
                } else {
                    Adjust.this.series_adjustDimensionsStop();
                }
            }
        });
        this.cropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Adjust.this.cropButton.getText().equals("Crop levels to Kymograph")) {
                    Adjust.this.series_cropDimensionsStart();
                } else {
                    Adjust.this.series_cropDimensionsStop();
                }
            }
        });
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Adjust.this.restoreButton.getText().equals("Restore levels")) {
                    Adjust.this.series_restoreStart();
                } else {
                    Adjust.this.series_restoreStop();
                }
            }
        });
        this.clipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Adjust.this.restoreButton.getText().equals("Restore levels")) {
                    Adjust.this.series_clipStart();
                } else {
                    Adjust.this.series_clipStop();
                }
            }
        });
        this.allSeriesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (Adjust.this.allSeriesCheckBox.isSelected()) {
                    color = Color.RED;
                }
                Adjust.this.allSeriesCheckBox.setForeground(color);
                Adjust.this.adjustButton.setForeground(color);
                Adjust.this.clipButton.setForeground(color);
                Adjust.this.restoreButton.setForeground(color);
                Adjust.this.cropButton.setForeground(color);
            }
        });
    }

    void restoreClippedPoints(Experiment exp) {
        SequenceKymos seqKymos = exp.seqKymos;
        int t = seqKymos.currentFrame;
        Capillary cap = exp.capillaries.capillariesList.get(t);
        cap.restoreClippedMeasures();
        seqKymos.updateROIFromCapillaryMeasure(cap, cap.ptsTop);
        seqKymos.updateROIFromCapillaryMeasure(cap, cap.ptsBottom);
        seqKymos.updateROIFromCapillaryMeasure(cap, cap.ptsDerivative);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            if (this.adjustButton.getText().contains("STOP ")) {
                this.adjustButton.setText("Resize levels to Kymographs");
            } else if (this.restoreButton.getText().contains("STOP ")) {
                this.restoreButton.setText("Restore levels");
            } else if (this.clipButton.getText().contains("STOP ")) {
                this.clipButton.setText("Clip levels npts to the shortest curve");
            } else if (this.cropButton.getText().contains("STOP ")) {
                this.cropButton.setText("Crop levels to Kymograph");
            }
        }
    }

    private void series_adjustDimensionsStop() {
        if (this.threadAdjust != null && !this.threadAdjust.stopFlag) {
            this.threadAdjust.stopFlag = true;
        }
    }

    private void series_cropDimensionsStop() {
        if (this.threadCrop != null && !this.threadCrop.stopFlag) {
            this.threadCrop.stopFlag = true;
        }
    }

    private void series_restoreStop() {
        if (this.threadRestore != null && !this.threadRestore.stopFlag) {
            this.threadRestore.stopFlag = true;
        }
    }

    private void series_clipStop() {
        if (this.threadClip != null && !this.threadClip.stopFlag) {
            this.threadClip.stopFlag = true;
        }
    }

    private boolean initBuildParameters(BuildSeriesOptions options) {
        int index = this.parent0.expListCombo.getSelectedIndex();
        Experiment exp = (Experiment)this.parent0.expListCombo.getItemAt(index);
        if (exp == null) {
            return false;
        }
        this.parent0.paneBrowse.panelLoadSave.closeViewsForCurrentExperiment(exp);
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allSeriesCheckBox.isSelected() ? this.parent0.expListCombo.getItemCount() - 1 : options.expList.index0;
        options.isFrameFixed = this.parent0.paneExcel.tabCommonOptions.getIsFixedFrame();
        options.t_Ms_First = this.parent0.paneExcel.tabCommonOptions.getStartMs();
        options.t_Ms_Last = this.parent0.paneExcel.tabCommonOptions.getEndMs();
        options.t_Ms_BinDuration = this.parent0.paneExcel.tabCommonOptions.getBinMs();
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.binSubDirectory = exp.getBinSubDirectory();
        return true;
    }

    private void series_adjustDimensionsStart() {
        this.threadAdjust = new AdjustMeasuresToDimensions();
        BuildSeriesOptions options = this.threadAdjust.options;
        if (this.initBuildParameters(options)) {
            this.threadAdjust.addPropertyChangeListener(this);
            this.threadAdjust.execute();
            this.adjustButton.setText("STOP Resize levels to Kymographs");
        }
    }

    private void series_cropDimensionsStart() {
        this.threadCrop = new CropMeasuresToDimensions();
        BuildSeriesOptions options = this.threadCrop.options;
        if (this.initBuildParameters(options)) {
            this.threadCrop.addPropertyChangeListener(this);
            this.threadCrop.execute();
            this.cropButton.setText("STOP Crop levels to Kymograph");
        }
    }

    private void series_restoreStart() {
        this.threadRestore = new CurvesRestoreLength();
        BuildSeriesOptions options = this.threadRestore.options;
        if (this.initBuildParameters(options)) {
            this.threadRestore.addPropertyChangeListener(this);
            this.threadRestore.execute();
            this.restoreButton.setText("STOP Restore levels");
        }
    }

    private void series_clipStart() {
        this.threadClip = new ClipCageMeasuresToSmallest();
        BuildSeriesOptions options = this.threadClip.options;
        if (this.initBuildParameters(options)) {
            this.threadClip.addPropertyChangeListener(this);
            this.threadClip.execute();
            this.clipButton.setText("STOP Clip levels npts to the shortest curve");
        }
    }
}

