/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.levels;

import icy.gui.util.GuiUtil;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polyline2D;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceKymos;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.experiment.capillaries.CapillaryMeasure;
import plugins.fmp.multicafe.tools.Level2D;

public class EditLevels
extends JPanel {
    private static final long serialVersionUID = 2580935598417087197L;
    private MultiCAFE parent0;
    private boolean[] isInside = null;
    private JComboBox<String> roiTypeCombo = new JComboBox<String>(new String[]{" top level", "bottom level", "top & bottom levels", "derivative", "gulps"});
    private JButton cutAndInterpolateButton = new JButton("Cut & interpolate");
    private JButton cropButton = new JButton("Crop from left");
    private JButton restoreButton = new JButton("Restore");

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout());
        panel1.add((Component)new JLabel("Apply to ", 2), "West");
        panel1.add(this.roiTypeCombo, "Center");
        this.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel(" "), panel1}));
        this.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel(" "), this.cutAndInterpolateButton}));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.cropButton, "Center");
        panel2.add((Component)this.restoreButton, "East");
        this.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel(" "), panel2}));
        this.defineListeners();
    }

    private void defineListeners() {
        this.cutAndInterpolateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((EditLevels)EditLevels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    EditLevels.this.cutAndInterpolate(exp);
                }
            }
        });
        this.cropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((EditLevels)EditLevels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    EditLevels.this.cropPointsToLeftLimit(exp);
                }
            }
        });
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((EditLevels)EditLevels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    EditLevels.this.restoreCroppedPoints(exp);
                }
            }
        });
    }

    void cropPointsToLeftLimit(Experiment exp) {
        SequenceKymos seqKymos = exp.seqKymos;
        int t = seqKymos.currentFrame;
        ROI2D roiRef = seqKymos.seq.getSelectedROI2D();
        if (roiRef == null) {
            return;
        }
        Capillary cap = exp.capillaries.capillariesList.get(t);
        seqKymos.transferKymosRoisToCapillaries_Measures(exp.capillaries);
        int lastX = this.findLastXLeftOfRoi(cap, roiRef);
        cap.cropMeasuresToNPoints(lastX + 1);
        seqKymos.updateROIFromCapillaryMeasure(cap, cap.ptsTop);
        seqKymos.updateROIFromCapillaryMeasure(cap, cap.ptsBottom);
        seqKymos.updateROIFromCapillaryMeasure(cap, cap.ptsDerivative);
    }

    int findLastXLeftOfRoi(Capillary cap, ROI2D roiRef) {
        int lastX = -1;
        Rectangle2D rectRef = roiRef.getBounds2D();
        double xleft = rectRef.getX();
        Level2D polyline = cap.ptsTop.polylineLevel;
        for (int i = 0; i < polyline.npoints; ++i) {
            if (polyline.xpoints[i] < xleft) continue;
            lastX = i - 1;
            break;
        }
        return lastX;
    }

    void restoreCroppedPoints(Experiment exp) {
        SequenceKymos seqKymos = exp.seqKymos;
        int t = seqKymos.currentFrame;
        Capillary cap = exp.capillaries.capillariesList.get(t);
        cap.restoreClippedMeasures();
        seqKymos.updateROIFromCapillaryMeasure(cap, cap.ptsTop);
        seqKymos.updateROIFromCapillaryMeasure(cap, cap.ptsBottom);
        seqKymos.updateROIFromCapillaryMeasure(cap, cap.ptsDerivative);
    }

    List<ROI> selectGulpsWithinRoi(ROI2D roiReference, Sequence seq, int t) {
        ArrayList allRois = seq.getROIs();
        ArrayList<ROI> listGulpsSelected = new ArrayList<ROI>();
        for (ROI roi : allRois) {
            roi.setSelected(false);
            if (!(roi instanceof ROI2D) || ((ROI2D)roi).getT() != t || !roi.getName().contains("gulp")) continue;
            listGulpsSelected.add(roi);
            roi.setSelected(true);
        }
        return listGulpsSelected;
    }

    void deleteGulps(SequenceKymos seqKymos, List<ROI> listGulpsSelected) {
        Sequence seq = seqKymos.seq;
        if (seq == null || listGulpsSelected == null) {
            return;
        }
        for (ROI roi : listGulpsSelected) {
            seq.removeROI(roi);
        }
    }

    void cutAndInterpolate(Experiment exp) {
        SequenceKymos seqKymos = exp.seqKymos;
        int t = seqKymos.seq.getFirstViewer().getPositionT();
        ROI2D roi = seqKymos.seq.getSelectedROI2D();
        if (roi == null) {
            return;
        }
        seqKymos.transferKymosRoi_atT_ToCapillaries_Measures(t, exp.capillaries);
        Capillary cap = exp.capillaries.capillariesList.get(t);
        String optionSelected = (String)this.roiTypeCombo.getSelectedItem();
        if (optionSelected.contains("gulp")) {
            List<ROI> listGulpsSelected = this.selectGulpsWithinRoi(roi, seqKymos.seq, seqKymos.currentFrame);
            this.deleteGulps(seqKymos, listGulpsSelected);
            seqKymos.removeROIsPolylineAtT(t);
            List<ROI2D> listOfRois = cap.transferMeasuresToROIs();
            seqKymos.seq.addROIs(listOfRois, false);
            for (ROI rOI : listOfRois) {
                seqKymos.seq.roiChanged(rOI);
            }
        } else {
            if (optionSelected.contains("top")) {
                this.removeAndUpdate(seqKymos, cap, cap.ptsTop, roi);
            }
            if (optionSelected.contains("bottom")) {
                this.removeAndUpdate(seqKymos, cap, cap.ptsBottom, roi);
            }
            if (optionSelected.contains("deriv")) {
                this.removeAndUpdate(seqKymos, cap, cap.ptsDerivative, roi);
            }
        }
    }

    private void removeAndUpdate(SequenceKymos seqKymos, Capillary cap, CapillaryMeasure caplimits, ROI2D roi) {
        this.removeMeasuresEnclosedInRoi(caplimits, roi);
        seqKymos.updateROIFromCapillaryMeasure(cap, caplimits);
    }

    void removeMeasuresEnclosedInRoi(CapillaryMeasure caplimits, ROI2D roi) {
        Level2D polyline = caplimits.polylineLevel;
        int npointsOutside = polyline.npoints - this.getPointsWithinROI(polyline, roi);
        if (npointsOutside > 0) {
            double[] xpoints = new double[npointsOutside];
            double[] ypoints = new double[npointsOutside];
            int index = 0;
            for (int i = 0; i < polyline.npoints; ++i) {
                if (this.isInside[i]) continue;
                xpoints[index] = polyline.xpoints[i];
                ypoints[index] = polyline.ypoints[i];
                ++index;
            }
            caplimits.polylineLevel = new Level2D(xpoints, ypoints, npointsOutside);
        } else {
            caplimits.polylineLevel = null;
        }
    }

    int getPointsWithinROI(Polyline2D polyline, ROI2D roi) {
        this.isInside = new boolean[polyline.npoints];
        int npointsInside = 0;
        for (int i = 0; i < polyline.npoints; ++i) {
            this.isInside[i] = roi.contains(polyline.xpoints[i], polyline.ypoints[i]);
            npointsInside += this.isInside[i] ? 1 : 0;
        }
        return npointsInside;
    }
}

