/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools;

import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Bresenham {
    public static ArrayList<int[]> getPixelsBetween2Points(int x1, int y1, int x2, int y2) {
        int y;
        int x;
        int incy;
        int dy;
        int incx;
        int dx;
        ArrayList<int[]> line = new ArrayList<int[]>();
        if (x2 >= x1) {
            dx = x2 - x1;
            incx = 1;
        } else {
            dx = x1 - x2;
            incx = -1;
        }
        if (y2 >= y1) {
            dy = y2 - y1;
            incy = 1;
        } else {
            dy = y1 - y2;
            incy = -1;
        }
        if (dx >= dy) {
            int balance = (dy <<= 1) - dx;
            dx <<= 1;
            for (x = x1; x != x2; x += incx) {
                line.add(new int[]{x, y});
                if (balance >= 0) {
                    y += incy;
                    balance -= dx;
                }
                balance += dy;
            }
            line.add(new int[]{x, y});
        } else {
            int balance = (dx <<= 1) - dy;
            dy <<= 1;
            for (y = y1; y != y2; y += incy) {
                line.add(new int[]{x, y});
                if (balance >= 0) {
                    x += incx;
                    balance -= dy;
                }
                balance += dx;
            }
            line.add(new int[]{x, y});
        }
        return line;
    }

    public static ArrayList<int[]> getPixelsAlongLineFromROI2D(ArrayList<Point2D> pointsList) {
        ArrayList<int[]> line = new ArrayList<int[]>();
        for (int i = 1; i < pointsList.size(); ++i) {
            ArrayList<int[]> linei = Bresenham.getPixelsBetween2Points((int)pointsList.get(i - 1).getX(), (int)pointsList.get(i - 1).getY(), (int)pointsList.get(i).getX(), (int)pointsList.get(i).getY());
            line.addAll(linei);
        }
        return line;
    }
}

