/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.chart;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.fmp.multicafe.tools.toExcel.XLSExportCapillariesResults;
import plugins.fmp.multicafe.tools.toExcel.XLSExportOptions;
import plugins.fmp.multicafe.tools.toExcel.XLSResults;
import plugins.fmp.multicafe.tools.toExcel.XLSResultsArray;

public class ChartLevels
extends IcyFrame {
    public JPanel mainChartPanel = null;
    public IcyFrame mainChartFrame = null;
    private MultiCAFE parent0 = null;
    private Rectangle chartRectv = null;
    private boolean flagMaxMinSet = false;
    private double globalYMax = 0.0;
    private double globalYMin = 0.0;
    private double globalXMax = 0.0;
    private double ymax = 0.0;
    private double ymin = 0.0;
    private double xmax = 0.0;
    private List<JFreeChart> xyChartList = new ArrayList<JFreeChart>();
    private String title;

    public void createChartPanel(MultiCAFE parent, String cstitle, Rectangle rectv) {
        this.title = cstitle;
        this.parent0 = parent;
        this.mainChartPanel = new JPanel();
        this.mainChartPanel.setLayout(new BoxLayout(this.mainChartPanel, 2));
        this.mainChartFrame = GuiUtil.generateTitleFrame((String)this.title, (JPanel)new JPanel(), (Dimension)new Dimension(300, 70), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.mainChartFrame.add((Component)this.mainChartPanel);
        if (this.chartRectv == null) {
            this.chartRectv = rectv;
        }
    }

    public void displayData(Experiment exp, EnumXLSExport option, String title, boolean subtractEvaporation) {
        this.xyChartList.clear();
        this.ymax = 0.0;
        this.ymin = 0.0;
        this.flagMaxMinSet = false;
        List<XYSeriesCollection> xyDataSetList = this.getDataArrays(exp, option, subtractEvaporation);
        NumberAxis yAxis = new NumberAxis("volume (\u00b5l)");
        yAxis.setAutoRangeIncludesZero(false);
        yAxis.setInverted(true);
        CombinedRangeXYPlot combinedXYPlot = new CombinedRangeXYPlot((ValueAxis)yAxis);
        Paint[] color = ChartColor.createDefaultPaintArray();
        for (XYSeriesCollection xySeriesCollection : xyDataSetList) {
            String[] description = xySeriesCollection.getSeries(0).getDescription().split("_");
            NumberAxis xAxis = new NumberAxis(description[0]);
            XYLineAndShapeRenderer subPlotRenderer = new XYLineAndShapeRenderer(true, false);
            XYPlot subplot = new XYPlot((XYDataset)xySeriesCollection, (ValueAxis)xAxis, null, (XYItemRenderer)subPlotRenderer);
            int icolor = 0;
            int i = 0;
            while (i < xySeriesCollection.getSeriesCount()) {
                if (icolor > color.length) {
                    icolor = 0;
                }
                subPlotRenderer.setSeriesPaint(i, color[icolor]);
                ++i;
                ++icolor;
            }
            int nflies = Integer.valueOf(description[1]);
            if (nflies == 0) {
                subplot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
                subplot.setDomainGridlinePaint((Paint)Color.WHITE);
                subplot.setRangeGridlinePaint((Paint)Color.WHITE);
            } else if (nflies < 0) {
                subplot.setBackgroundPaint((Paint)Color.DARK_GRAY);
                subplot.setDomainGridlinePaint((Paint)Color.WHITE);
                subplot.setRangeGridlinePaint((Paint)Color.WHITE);
            } else if (nflies > 1) {
                subplot.setBackgroundPaint((Paint)new Color(173, 216, 230));
                subplot.setDomainGridlinePaint((Paint)Color.WHITE);
                subplot.setRangeGridlinePaint((Paint)Color.WHITE);
            } else {
                subplot.setBackgroundPaint((Paint)Color.WHITE);
                subplot.setDomainGridlinePaint((Paint)Color.GRAY);
                subplot.setRangeGridlinePaint((Paint)Color.GRAY);
            }
            combinedXYPlot.add(subplot);
        }
        JFreeChart chart = new JFreeChart(title, null, (Plot)combinedXYPlot, true);
        int width = 800;
        int height = 300;
        int minimumDrawWidth = width;
        int minimumDrawHeight = 300;
        int maximumDrawWidth = 800;
        int maximumDrawHeight = 500;
        boolean useBuffer = true;
        ChartPanel panel = new ChartPanel(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, true, true, true, false, true);
        panel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent e) {
                ChartLevels.this.selectKymoImage(ChartLevels.this.getSelectedCurve(e));
            }

            public void chartMouseMoved(ChartMouseEvent e) {
            }
        });
        this.mainChartPanel.add((Component)panel);
        this.mainChartFrame.pack();
        this.mainChartFrame.setLocation(this.chartRectv.getLocation());
        this.mainChartFrame.addToDesktopPane();
        this.mainChartFrame.setVisible(true);
    }

    private int getSelectedCurve(ChartMouseEvent e) {
        MouseEvent trigger = e.getTrigger();
        if (trigger.getButton() != 1) {
            return -1;
        }
        JFreeChart chart = e.getChart();
        ChartEntity chartEntity = e.getEntity();
        MouseEvent mouseEvent = e.getTrigger();
        int isel = 0;
        if (chartEntity != null && chartEntity instanceof XYItemEntity) {
            XYItemEntity xyItemEntity = (XYItemEntity)e.getEntity();
            isel += xyItemEntity.getSeriesIndex();
        }
        CombinedRangeXYPlot combinedXYPlot = (CombinedRangeXYPlot)chart.getPlot();
        List subplots = combinedXYPlot.getSubplots();
        ChartPanel panel = (ChartPanel)this.mainChartPanel.getComponent(0);
        PlotRenderingInfo plotInfo = panel.getChartRenderingInfo().getPlotInfo();
        Point2D p = panel.translateScreenToJava2D(mouseEvent.getPoint());
        int subplotindex = plotInfo.getSubplotIndex(p);
        for (int i = 0; i < subplotindex; ++i) {
            isel += ((XYPlot)subplots.get(i)).getSeriesCount();
        }
        return isel;
    }

    private void selectKymoImage(int isel) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        Viewer v = exp.seqKymos.seq.getFirstViewer();
        if (v != null && isel >= 0) {
            v.setPositionT(isel);
        }
    }

    private List<XYSeriesCollection> getDataArrays(Experiment exp, EnumXLSExport exportType, boolean subtractEvaporation) {
        XLSResultsArray resultsArray1 = this.getDataAsResultsArray(exp, exportType, subtractEvaporation);
        XLSResultsArray resultsArray2 = null;
        if (exportType == EnumXLSExport.TOPLEVEL) {
            resultsArray2 = this.getDataAsResultsArray(exp, EnumXLSExport.BOTTOMLEVEL, subtractEvaporation);
        }
        XYSeriesCollection xyDataset = null;
        int oldCage = -1;
        ArrayList<XYSeriesCollection> xyList = new ArrayList<XYSeriesCollection>();
        for (int iRow = 0; iRow < resultsArray1.size(); ++iRow) {
            XLSResults xlsResults = resultsArray1.getRow(iRow);
            if (oldCage != xlsResults.cageID) {
                xyDataset = new XYSeriesCollection();
                oldCage = xlsResults.cageID;
                xyList.add(xyDataset);
            }
            XYSeries seriesXY = this.getXYSeries(xlsResults, xlsResults.name.substring(4));
            seriesXY.setDescription("cell " + xlsResults.cageID + "_" + xlsResults.nflies);
            if (resultsArray2 != null) {
                this.appendDataToXYSeries(seriesXY, resultsArray2.getRow(iRow));
            }
            xyDataset.addSeries(seriesXY);
            this.updateGlobalMaxMin();
        }
        return xyList;
    }

    private XLSResultsArray getDataAsResultsArray(Experiment exp, EnumXLSExport exportType, boolean subtractEvaporation) {
        XLSExportOptions options = new XLSExportOptions();
        options.buildExcelStepMs = 60000;
        options.t0 = true;
        options.subtractEvaporation = subtractEvaporation;
        XLSExportCapillariesResults xlsExport = new XLSExportCapillariesResults();
        return xlsExport.getCapDataFromOneExperiment(exp, exportType, options);
    }

    private void updateGlobalMaxMin() {
        if (!this.flagMaxMinSet) {
            this.globalYMax = this.ymax;
            this.globalYMin = this.ymin;
            this.globalXMax = this.xmax;
            this.flagMaxMinSet = true;
        } else {
            if (this.globalYMax < this.ymax) {
                this.globalYMax = this.ymax;
            }
            if (this.globalYMin >= this.ymin) {
                this.globalYMin = this.ymin;
            }
            if (this.globalXMax < this.xmax) {
                this.globalXMax = this.xmax;
            }
        }
    }

    private XYSeries getXYSeries(XLSResults results, String name) {
        XYSeries seriesXY = new XYSeries((Comparable)((Object)name), false);
        if (results.valuesOut != null && results.valuesOut.length > 0) {
            this.xmax = results.valuesOut.length;
            this.ymin = this.ymax = results.valuesOut[0];
            this.addPointsAndUpdateExtrema(seriesXY, results, 0);
        }
        return seriesXY;
    }

    private void appendDataToXYSeries(XYSeries seriesXY, XLSResults results) {
        if (results.valuesOut != null && results.valuesOut.length > 0) {
            seriesXY.add(Double.NaN, Double.NaN);
            this.addPointsAndUpdateExtrema(seriesXY, results, 0);
        }
    }

    private void addPointsAndUpdateExtrema(XYSeries seriesXY, XLSResults results, int startFrame) {
        int x = 0;
        for (double y : results.valuesOut) {
            seriesXY.add((double)(x + startFrame), y);
            if (this.ymax < y) {
                this.ymax = y;
            }
            if (this.ymin > y) {
                this.ymin = y;
            }
            ++x;
        }
    }
}

