/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.toExcel;

import icy.gui.frame.progress.ProgressFrame;
import java.awt.Point;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import plugins.fmp.multicafe.experiment.CombinedExperiment;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.experiment.cages.FlyPosition;
import plugins.fmp.multicafe.tools.toExcel.EnumMeasure;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.fmp.multicafe.tools.toExcel.XLSExport;
import plugins.fmp.multicafe.tools.toExcel.XLSExportOptions;
import plugins.fmp.multicafe.tools.toExcel.XLSUtils;

public class XLSExportMoveResults
extends XLSExport {
    public void exportToFile(String filename, XLSExportOptions opt) {
        System.out.println("XLSExpoportMove:exportToFile() start output");
        this.options = opt;
        this.expList = this.options.expList;
        boolean loadCapillaries = true;
        boolean loadDrosoTrack = true;
        this.expList.loadListOfMeasuresFromAllExperiments(loadCapillaries, loadDrosoTrack);
        this.expList.chainExperimentsUsingKymoIndexes(this.options.collateSeries);
        this.expList.setFirstImageForAllExperiments(this.options.collateSeries);
        this.expAll = this.expList.get_MsTime_of_StartAndEnd_AllExperiments(this.options);
        ProgressFrame progress = new ProgressFrame("Export data to Excel");
        int nbexpts = this.expList.getItemCount();
        progress.setLength((double)nbexpts);
        try {
            int iSeries = 0;
            this.workbook = this.xlsInitWorkbook();
            for (int index = this.options.firstExp; index <= this.options.lastExp; ++index) {
                Experiment exp = (Experiment)this.expList.getItemAt(index);
                if (exp.chainToPreviousExperiment != null) continue;
                CombinedExperiment combinedExp = new CombinedExperiment(exp, this.options.collateSeries);
                combinedExp.loadExperimentDescriptors();
                combinedExp.loadExperimentCamFileNames();
                combinedExp.loadFlyPositions();
                progress.setMessage("Export experiment " + (index + 1) + " of " + nbexpts);
                String charSeries = CellReference.convertNumToColString((int)iSeries);
                if (this.options.xyImage) {
                    this.exportMoveDataFromExpCombined(combinedExp, charSeries, this.options, EnumXLSExport.XYIMAGE);
                }
                if (this.options.xyCage) {
                    this.exportMoveDataFromExpCombined(combinedExp, charSeries, this.options, EnumXLSExport.XYTOPCELL);
                }
                if (this.options.xyCapillaries) {
                    this.exportMoveDataFromExpCombined(combinedExp, charSeries, this.options, EnumXLSExport.XYTIPCAPS);
                }
                if (this.options.ellipseAxes) {
                    this.exportMoveDataFromExpCombined(combinedExp, charSeries, this.options, EnumXLSExport.ELLIPSEAXES);
                }
                if (this.options.distance) {
                    this.exportMoveDataFromExpCombined(combinedExp, charSeries, this.options, EnumXLSExport.DISTANCE);
                }
                if (this.options.alive) {
                    this.exportMoveDataFromExpCombined(combinedExp, charSeries, this.options, EnumXLSExport.ISALIVE);
                }
                if (this.options.sleep) {
                    this.exportMoveDataFromExpCombined(combinedExp, charSeries, this.options, EnumXLSExport.SLEEP);
                }
                ++iSeries;
                progress.incPosition();
            }
            progress.setMessage("Save Excel file to disk... ");
            FileOutputStream fileOut = new FileOutputStream(filename);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
            this.workbook.close();
            progress.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("XLSExpoportMove:exportToFile() - output finished");
    }

    private void exportMoveDataFromExpCombined(CombinedExperiment combinedExp, String charSeries, XLSExportOptions options, EnumXLSExport xlsExportOption) {
        XSSFSheet sheet = this.xlsGetSheet(xlsExportOption.toString(), xlsExportOption);
        CellAddress cellAddress = sheet.getActiveCell();
        int x = cellAddress.getRow();
        int y = 0;
        x = this.writeSeparator_Between_Experiments(sheet, new Point(x, y), options.transpose);
        ArrayList<EnumMeasure> measures = xlsExportOption.toMeasures();
        ArrayList<Cage> cellList = combinedExp.cages.cageList;
        for (int index = 0; index < cellList.size(); ++index) {
            Cage cell = (Cage)cellList.get(index);
            for (int j = 0; j < measures.size(); ++j) {
                y = 0;
                this.XLSExportExperimentParameters(sheet, options.transpose, x, y, charSeries, combinedExp);
                this.xlsExportCageParameters(sheet, options.transpose, x, y, charSeries, combinedExp, cell);
                XLSUtils.setValue(sheet, x, y += EnumXLSColumnHeader.DUM4.getValue(), options.transpose, measures.get(j).toString());
                this.writeData(sheet, cell, x, ++y, measures.get(j));
                ++x;
            }
        }
        sheet.setActiveCell(new CellAddress(x, y));
    }

    private void writeData(XSSFSheet sheet, Cage cell, int x, int y, EnumMeasure exportType) {
        int i_from;
        boolean transpose = this.options.transpose;
        Point pt = new Point(x, y);
        if (cell.cageNFlies < 1) {
            return;
        }
        long last = this.expAll.camImageLast_ms - this.expAll.camImageFirst_ms;
        if (this.options.fixedIntervals) {
            last = this.options.endAll_Ms - this.options.startAll_Ms;
        }
        if (exportType == EnumMeasure.TI) {
            cell.flyPositions.computeDistanceBetweenConsecutivePoints();
        } else if (exportType == EnumMeasure.SLEEP) {
            cell.flyPositions.computeSleep();
        } else if (exportType == EnumMeasure.ALIVE) {
            cell.flyPositions.computeIsAlive();
        }
        long coltime = 0L;
        while (coltime <= last && (i_from = (int)(coltime / (long)this.options.buildExcelStepMs)) < cell.flyPositions.flyPositionList.size()) {
            double value = Double.NaN;
            FlyPosition pos = cell.flyPositions.flyPositionList.get(i_from);
            switch (exportType) {
                case TI: {
                    value = pos.flyIndexT;
                    break;
                }
                case TS: {
                    value = (double)pos.tMs / 60000.0;
                    break;
                }
                case X: {
                    value = pos.x;
                    break;
                }
                case Y: {
                    value = pos.y;
                    break;
                }
                case W: {
                    value = pos.w;
                    break;
                }
                case H: {
                    value = pos.h;
                    break;
                }
                case DISTANCE: {
                    value = pos.distance;
                    break;
                }
                case ALIVE: {
                    value = pos.bAlive ? 1.0 : 0.0;
                    break;
                }
                case SLEEP: {
                    value = pos.bSleep ? 1.0 : 0.0;
                    break;
                }
            }
            if (!Double.isNaN(value)) {
                XLSUtils.setValue(sheet, pt, transpose, value);
                if (pos.bPadded) {
                    XLSUtils.getCell(sheet, pt, transpose).setCellStyle((CellStyle)this.xssfCellStyle_red);
                }
            }
            coltime += (long)this.options.buildExcelStepMs;
            ++pt.y;
        }
        pt.x += 2;
    }
}

