/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.viewer1D;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import plugins.fmp.multicafe.viewer1D.Pannable;

public class PanningChartPanel
extends ChartPanel
implements MouseWheelListener {
    private static final long serialVersionUID = 7137545362221062062L;
    public static final int MOUSE_ZOOM = 1;
    public static final int MOUSE_PAN = 2;
    private int mouseMode = 1;
    private int lastPanX = -1;
    private int lastPanY = -1;
    private Point2D panStartPoint = null;
    double zoomFactor = 0.9;

    public PanningChartPanel(JFreeChart chart) {
        super(chart);
        this.addMouseWheelListener(this);
    }

    public PanningChartPanel(JFreeChart chart, boolean useBuffer) {
        super(chart, useBuffer);
        this.addMouseWheelListener(this);
    }

    public PanningChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, properties, save, print, zoom, tooltips);
        this.addMouseWheelListener(this);
    }

    public PanningChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, save, print, zoom, tooltips);
        this.addMouseWheelListener(this);
    }

    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Point getPointInRectangle(int x, int y, Rectangle2D area) {
        x = (int)Math.max(Math.ceil(area.getMinX()), Math.min((double)x, Math.floor(area.getMaxX())));
        y = (int)Math.max(Math.ceil(area.getMinY()), Math.min((double)y, Math.floor(area.getMaxY())));
        return new Point(x, y);
    }

    public void mousePressed(MouseEvent e) {
        if (e.isControlDown()) {
            this.mouseMode = 2;
            Rectangle2D screenDataArea = this.getScreenDataArea(e.getX(), e.getY());
            if (screenDataArea != null) {
                Point point = this.getPointInRectangle(e.getX(), e.getY(), screenDataArea);
                this.panStartPoint = point;
                this.lastPanX = point.x;
                this.lastPanY = point.y;
            }
        } else {
            this.mouseMode = 1;
        }
        super.mousePressed(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.mouseMode == 2) {
            if (this.panStartPoint == null) {
                Rectangle2D screenDataArea = this.getScreenDataArea(e.getX(), e.getY());
                if (screenDataArea != null) {
                    Point point = this.getPointInRectangle(e.getX(), e.getY(), screenDataArea);
                    this.panStartPoint = point;
                }
            } else {
                this.move(this.panStartPoint, this.lastPanX, this.lastPanY, e.getX(), e.getY());
            }
            this.lastPanX = e.getX();
            this.lastPanY = e.getY();
            return;
        }
        super.mouseDragged(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(Point2D startPoint, int oldX, int oldY, int newX, int newY) {
        double moveDirection = -1.0;
        double diffX = moveDirection * (double)(newX - oldX);
        double diffY = -1.0 * moveDirection * (double)(newY - oldY);
        if (diffX == 0.0 && diffY == 0.0) {
            return;
        }
        try {
            this.getChart().setNotify(false);
            if (this.getChart().getPlot() instanceof Pannable) {
                Pannable panningPlot = (Pannable)this.getChart().getPlot();
                if (panningPlot.isDomainPannable()) {
                    if (panningPlot.getOrientation() == PlotOrientation.VERTICAL) {
                        panningPlot.panDomainAxis(diffX, this.getChartRenderingInfo().getPlotInfo(), startPoint);
                    } else {
                        panningPlot.panDomainAxis(diffY, this.getChartRenderingInfo().getPlotInfo(), startPoint);
                    }
                }
                if (panningPlot.isRangePannable()) {
                    if (panningPlot.getOrientation() == PlotOrientation.VERTICAL) {
                        panningPlot.panRangeAxis(diffY, this.getChartRenderingInfo().getPlotInfo(), startPoint);
                    } else {
                        panningPlot.panRangeAxis(diffX, this.getChartRenderingInfo().getPlotInfo(), startPoint);
                    }
                }
            }
        }
        finally {
            this.getChart().setNotify(true);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Point2D p = this.translateScreenToJava2D(e.getPoint());
        if (!this.getChartRenderingInfo().getPlotInfo().getDataArea().contains(p.getX(), p.getY())) {
            return;
        }
        int increment = e.getWheelRotation() < 0 ? 1 : (e.getWheelRotation() > 0 ? -1 : 0);
        boolean oldNotify = this.getChart().isNotify();
        this.getChart().setNotify(false);
        if (increment > 0) {
            this.zoomIn(p);
        } else if (increment < 0) {
            this.zoomOut(p);
        }
        this.getChart().setNotify(oldNotify);
    }

    private void zoomIn(Point2D point) {
        int subPlot = this.getChartRenderingInfo().getPlotInfo().getSubplotIndex(point);
        PlotRenderingInfo plotInfo = subPlot >= 0 ? this.getChartRenderingInfo().getPlotInfo().getSubplotInfo(subPlot) : this.getChartRenderingInfo().getPlotInfo();
        Rectangle2D dataArea = plotInfo.getDataArea();
        double mouseXPxl = point.getX() - dataArea.getX();
        double mouseYPxl = point.getY() - dataArea.getY();
        double relPosX = mouseXPxl / dataArea.getWidth();
        double relPosY = 1.0 - mouseYPxl / dataArea.getHeight();
        PlotOrientation orientation = this.getChart().getXYPlot().getOrientation();
        double domainRelPos = orientation == PlotOrientation.VERTICAL ? relPosX : relPosY;
        double rangeRelPos = orientation == PlotOrientation.VERTICAL ? relPosY : relPosX;
        for (int di = 0; di < this.getChart().getXYPlot().getDomainAxisCount(); ++di) {
            ValueAxis domainAxis = this.getChart().getXYPlot().getDomainAxis(di);
            if (domainAxis == null) continue;
            domainAxis.zoomRange(domainRelPos * (1.0 - this.getZoomFactor()), domainRelPos + this.getZoomFactor() * (1.0 - domainRelPos));
        }
        for (int ri = 0; ri < this.getChart().getXYPlot().getRangeAxisCount(); ++ri) {
            ValueAxis rangeAxis = this.getChart().getXYPlot().getRangeAxis(ri);
            if (rangeAxis == null) continue;
            rangeAxis.zoomRange(rangeRelPos * (1.0 - this.getZoomFactor()), rangeRelPos + this.getZoomFactor() * (1.0 - rangeRelPos));
        }
    }

    private void zoomOut(Point2D point) {
        int subPlot = this.getChartRenderingInfo().getPlotInfo().getSubplotIndex(point);
        PlotRenderingInfo plotInfo = subPlot >= 0 ? this.getChartRenderingInfo().getPlotInfo().getSubplotInfo(subPlot) : this.getChartRenderingInfo().getPlotInfo();
        Rectangle2D dataArea = plotInfo.getDataArea();
        double mouseXPxl = point.getX() - dataArea.getX();
        double mouseYPxl = point.getY() - dataArea.getY();
        double relPosX = mouseXPxl / dataArea.getWidth();
        double relPosY = 1.0 - mouseYPxl / dataArea.getHeight();
        PlotOrientation orientation = this.getChart().getXYPlot().getOrientation();
        double domainRelPos = orientation == PlotOrientation.VERTICAL ? relPosX : relPosY;
        double rangeRelPos = orientation == PlotOrientation.VERTICAL ? relPosY : relPosX;
        for (int di = 0; di < this.getChart().getXYPlot().getDomainAxisCount(); ++di) {
            ValueAxis domainAxis = this.getChart().getXYPlot().getDomainAxis(di);
            if (domainAxis == null) continue;
            domainAxis.zoomRange(-1.0 * domainRelPos * (1.0 - this.getZoomFactor()), 1.0 + (1.0 - domainRelPos) * (1.0 - this.getZoomFactor()));
        }
        for (int ri = 0; ri < this.getChart().getXYPlot().getRangeAxisCount(); ++ri) {
            ValueAxis rangeAxis = this.getChart().getXYPlot().getRangeAxis(ri);
            if (rangeAxis == null) continue;
            rangeAxis.zoomRange(-1.0 * rangeRelPos * (1.0 - this.getZoomFactor()), 1.0 + (1.0 - rangeRelPos) * (1.0 - this.getZoomFactor()));
        }
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }
}

