/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.viewer1D.plugins.adufour.viewers;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.PluginActionable;
import icy.plugin.interface_.PluginCanvas;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.type.DataType;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class Montage2D
extends PluginActionable
implements PluginCanvas {
    public static Sequence makeMontage2D(Sequence sequence) {
        int oldWidth = sequence.getSizeX();
        int oldHeight = sequence.getSizeY();
        int oldDepth = sequence.getSizeZ();
        int xCount = (int)Math.ceil(Math.sqrt(oldDepth));
        int yCount = (int)Math.rint(Math.sqrt(oldDepth));
        Sequence result = new Sequence();
        for (int t = 0; t < sequence.getSizeT(); ++t) {
            IcyBufferedImage montage = new IcyBufferedImage(oldWidth * xCount, oldHeight * yCount, sequence.getSizeC(), sequence.getDataType_());
            for (int z = 0; z < oldDepth; ++z) {
                montage.copyData(sequence.getImage(t, z), null, new Point(oldWidth * (z % xCount), oldHeight * (int)Math.floor(z / xCount)));
            }
            result.setImage(t, 0, (BufferedImage)montage);
        }
        return result;
    }

    public void run() {
        Sequence input = this.getActiveSequence();
        if (input == null) {
            return;
        }
        this.addSequence(Montage2D.makeMontage2D(this.getActiveSequence()));
    }

    public String getCanvasClassName() {
        return Montage2DCanvas.class.getName();
    }

    public IcyCanvas createCanvas(Viewer viewer) {
        return new Montage2DCanvas(viewer);
    }

    public class Montage2DCanvas
    extends Canvas2D {
        private static final long serialVersionUID = 1L;
        private Sequence sequence;
        private int oldWidth;
        private int oldHeight;
        private int oldDepth;
        private int xCount;
        private int yCount;
        private int newWidth;
        private int newHeight;

        public Montage2DCanvas(Viewer viewer) {
            super(viewer);
            this.updateInternals(this.getSequence());
        }

        private void updateInternals(Sequence newSequence) {
            this.sequence = newSequence;
            this.oldWidth = this.sequence.getWidth();
            this.oldHeight = this.sequence.getHeight();
            this.oldDepth = this.sequence.getSizeZ();
            this.xCount = (int)Math.ceil(Math.sqrt(this.oldDepth));
            this.yCount = (int)Math.rint(Math.sqrt(this.oldDepth));
            this.newWidth = this.oldWidth * this.xCount;
            this.newHeight = this.oldHeight * this.yCount;
        }

        public IcyBufferedImage getImage(int t, int z, int c) {
            DataType type;
            if (z != -1) {
                return super.getImage(t, z, c);
            }
            if (this.getSequence() == null) {
                return null;
            }
            if (this.sequence != this.getSequence() || this.oldDepth != this.getSequence().getSizeZ()) {
                this.updateInternals(this.getSequence());
            }
            if ((type = this.sequence.getDataType_()) == DataType.UNDEFINED) {
                throw new IcyHandledException("Unsupported data type (" + type + "). Try converting the sequence to another data type first.");
            }
            IcyBufferedImage montage = new IcyBufferedImage(this.newWidth, this.newHeight, this.sequence.getSizeC(), type);
            Point point = new Point();
            for (int k = 0; k < this.oldDepth; ++k) {
                IcyBufferedImage src = this.sequence.getImage(t, k);
                point.x = this.oldWidth * (k % this.xCount);
                point.y = this.oldHeight * (k / this.xCount);
                montage.copyData(src, null, point);
            }
            return montage;
        }

        public int getImageSizeX() {
            return this.newWidth;
        }

        public int getImageSizeY() {
            return this.newHeight;
        }

        public int getImageSizeZ() {
            return 1;
        }

        public int getPositionZ() {
            return -1;
        }

        public int getMaxZ() {
            return -1;
        }

        public double getMouseImagePosX() {
            return super.getMouseImagePosX();
        }

        public double getMouseImagePosY() {
            return super.getMouseImagePosY();
        }

        public double getMouseImagePosZ() {
            return super.getMouseImagePosZ();
        }
    }
}

