package plugins.ylemontag.sequencecomparator.comparators;

/**
 * 
 * @author Yoann Le Montagner
 *
 */
public class GlobalL1 extends PixelSeparableGlobalComparator
{
	/**
	 * Constructor
	 */
	public GlobalL1(String distanceName)
	{
		super(distanceName);
	}
	
	@Override
	protected double aggregateInsideXY(double accu, double refPixel, double seqPixel)
	{
		return accu + Math.abs(seqPixel - refPixel);
	}

	@Override
	protected double aggregateOutsideXY(double accu, double errorOverPlane)
	{
		return accu + errorOverPlane;
	}
}
