package plugins.ylemontag.sequencecomparator.comparators;

import plugins.ylemontag.ssim.SSIMCalculator;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Local SSIM error map 
 */
public class LocalSSIM extends PlaneSeparableLocalComparator
{
	private SSIMCalculator _calculator;
	
	/**
	 * Constructor
	 */
	public LocalSSIM(String distanceName, SSIMCalculator calculator)
	{
		super(distanceName);
		if(calculator==null) {
			throw new IllegalArgumentException("No SSIM calculator specified");
		}
		_calculator = calculator.clone();
	}
	
	@Override
	protected void computePlaneError(int sizeX, int sizeY, double[] refPlane, double[] seqPlane, double[] outPlane)
	{
		_calculator.computeMap(sizeX, sizeY, refPlane, seqPlane, outPlane);
	}
}
