package plugins.tprovoost.slicetraveler;

import icy.canvas.Canvas3D;
import icy.canvas.IcyCanvas;
import icy.image.IcyBufferedImage.FilterType;
import icy.main.Icy;
import icy.painter.AbstractPainter;
import icy.painter.Painter;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class SliceTraveler extends PluginActionable {

	private static int MAXIMUM_SLICES = 20;

	@Override
	public void run() {
		Sequence s = getFocusedSequence();
		if (s != null) {
			Painter p = new myPainter();
			s.addPainter(p);
			Icy.getMainInterface().getFocusedViewer().getCanvas().getLayer(p).setName("Slice Traveler");
		}
	}

	private class myPainter extends AbstractPainter {

		@Override
		public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
			super.paint(g, sequence, canvas);
			if (canvas instanceof Canvas3D)
				return;
			int w = sequence.getWidth();
			int h = sequence.getHeight();
			int sizeZ = sequence.getSizeZ();
			int zIdx = canvas.getPositionZ();
			int squareSize = w / 20;

			if (sizeZ > MAXIMUM_SLICES) {
				zIdx = zIdx * MAXIMUM_SLICES / sizeZ;
				sizeZ = 20;
			}

			for (int i = 0; i < sizeZ; ++i) {
				Graphics2D g2 = (Graphics2D) g.create();
				AffineTransform at = AffineTransform.getScaleInstance(1.5, 1);
				at.translate(w / 2 + squareSize * 2, h - squareSize * 1.5 - i * 2);
				at.rotate(Math.PI / 4);
				g2.transform(at);
				g2.setColor(new Color(150, 150, 150, 40));
				if (i == zIdx) {
					g2.drawImage(canvas.getImage(canvas.getPositionT(), canvas.getPositionZ()).getScaledCopy(squareSize, squareSize, FilterType.NEAREST), 0, 0,
							null);
				} else {
					Rectangle2D r = new Rectangle2D.Double(0, 0, squareSize, squareSize);
					g2.fill(r);
				}
				g2.dispose();
			}
		}
	}
}
