package plugins.spop.clahe;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;


public class Clahe extends EzPlug implements Block{

	EzVarSequence input = new EzVarSequence("Input");
	
	EzVarText	type = new EzVarText("Type", new String[] { "2D", "Multi 2D","3D" },2, false);
	EzVarInteger bins_menu = new EzVarInteger("No.bins",255, 2, 255, 1);
	EzVarInteger half_size = new EzVarInteger("Half size XY",15, 1, 10000, 1);
	EzVarInteger half_sizeZ = new EzVarInteger("Half size Z",3, 1, 63, 1);
	EzVarDouble slope_menu = new EzVarDouble("Maximum slope",3,1,255,0.1);
	
	EzVarSequence output = new EzVarSequence("Output");
	
	@Override
	public void initialize() {
		// TODO Auto-generated method stub
		addEzComponent(input);
		addEzComponent(type);
		addEzComponent(bins_menu);
		addEzComponent(half_size);
		addEzComponent(half_sizeZ);
		
		addEzComponent(slope_menu);
		
		setTimeDisplay(true);
		
	}

	@Override
	public void execute() {
		Sequence out = null;
		// TODO Auto-generated method stub
		int blockRadius = half_size.getValue();
		int block_z = half_sizeZ.getValue();
		int bins = bins_menu.getValue();
		double slope = slope_menu.getValue();
		Sequence seq_in=input.getValue().convertToType(DataType.UBYTE, true);
		
		
		if(type.getValue().equalsIgnoreCase("2D"))
		{
			out=clahe_run2D(seq_in,blockRadius,bins,slope,0);
			out.setName("Clahe 2D");
		}
		if(type.getValue().equalsIgnoreCase("Multi 2D"))
		{
			out=clahe_run2D(seq_in,blockRadius,bins,slope,1);
			out.setName("Clahe multi2D");
		}
		if(type.getValue().equalsIgnoreCase("3D"))
		{		
			out=clahe_run3D(seq_in,blockRadius,block_z,bins,slope);
			out.setName("Clahe 3D");
		}
		 if(getUI()!=null)
				addSequence(out);
			output.setValue(out);
		
		
	}

	
	private Sequence clahe_run2D(Sequence seqIn, int blockRadius, int bins,
			double slope, int type) {
		// TODO Auto-generated method stub
		Sequence seq_out=new Sequence();
		int dim_x=seqIn.getSizeX();
		int dim_y=seqIn.getSizeY();
		int dim_z=seqIn.getSizeZ();
		int dim_t=seqIn.getSizeT();
		int dim_c=seqIn.getSizeC();
		int z_init=0;
		if(type==0)//the 2D case
		{
			z_init=input.getValue().getFirstViewer().getZ();
			dim_z=z_init+1;			
		}
		int[][] src=new int[dim_z][dim_x*dim_y];
		int[][] dst=new int[dim_z][dim_x*dim_y];
		
		/* initialize box if necessary */
		
		
		for(int t=0;t<dim_t;t++)
		{
			IcyBufferedImage[] icy_img = new IcyBufferedImage[dim_z];
			for(int z=z_init;z<dim_z;z++)
				icy_img[z] = new IcyBufferedImage(dim_x, dim_y, dim_c, DataType.UBYTE);
			
			for(int c=0;c<dim_c;c++)
			{
				ExecutorService service = Executors.newCachedThreadPool();		
				ArrayList<Future<?>> tasks = new ArrayList<Future<?>>();
				for(int z=0;z<dim_z;z++)
				{			
					
					src[z] = Array1DUtil.arrayToIntArray(seqIn.getDataXY(t,z,c), false);
					dst[z] = Array1DUtil.arrayToIntArray(seqIn.getDataXY(t,z,c), false);
				}
				
				for(int z=z_init;z<dim_z;z++)
				{
					Rectangle box;
					box = new Rectangle( 0, 0, dim_x, dim_y );
					/* make sure that the box is not larger than the image */
					box.width = Math.min( dim_x - box.x, box.width );
					box.height = Math.min( dim_y - box.y, box.height );
					
					int boxXMax = box.x + box.width;
					int boxYMax = box.y + box.height;
					
					
					tasks.add(service.submit(new Clahe_m2D_slice(src, dst, blockRadius, bins, slope, box, z, dim_x, dim_y, dim_z, boxXMax, boxYMax)));	
					
						
				}
				for(Future<?> task : tasks)
				{
					try {
						task.get();
					} catch (InterruptedException e) {
					} catch (ExecutionException e) {
					}
				}			
				tasks.clear();
				for(int z=z_init;z<dim_z;z++)
				{			
					Array1DUtil.intArrayToSafeArray(dst[z], icy_img[z].getDataXY(c), icy_img[z].isSignedDataType());
				}
			}
			for(int z=z_init;z<dim_z;z++)
				seq_out.setImage(t, z-z_init, icy_img[z]);
		}
		
		return seq_out;
	}
	
	private Sequence clahe_run3D(Sequence seqIn, int blockRadius, int block_z, int bins,double slope) {
		// TODO Auto-generated method stub
		Sequence seq_out=new Sequence();
		
		int dim_x=seqIn.getSizeX();
		int dim_y=seqIn.getSizeY();
		int dim_z=seqIn.getSizeZ();
		int dim_t=seqIn.getSizeT();
		int dim_c=seqIn.getSizeC();
		
		Cube box= new Cube(0,0,0,dim_x, dim_y, dim_z);
		int[][] src=new int[dim_z][dim_x*dim_y];
		int[][] dst=new int[dim_z][dim_x*dim_y];
		
		
		
		for(int t=0;t<dim_t;t++)
		{
			ExecutorService service = Executors.newCachedThreadPool();//newFixedThreadPool(MAX_NB_THREAD);//.newCachedThreadPool();		
			ArrayList<Future<?>> tasks = new ArrayList<Future<?>>();
			IcyBufferedImage[] icy_img = new IcyBufferedImage[dim_z];
			for(int z=0;z<dim_z;z++)
				icy_img[z] = new IcyBufferedImage(dim_x, dim_y, dim_c, DataType.UBYTE);
			/* initialize box if necessary */
			box.width = Math.min( dim_x - box.x, box.width );
			box.height = Math.min( dim_y - box.y, box.height );
			box.depth= Math.min( dim_z - box.z, box.depth );
			
			int boxXMax = box.x + box.width;
			int boxYMax = box.y + box.height;
			int boxZMax = box.z + box.depth;
			
			for(int c=0;c<dim_c;c++)
			{
				for(int z=0;z<dim_z;z++)
				{			
					
					src[z] = Array1DUtil.arrayToIntArray(seqIn.getDataXY(t,z,c), false);			
				}
				
				
				
				
				for(int z = box.z; z < boxZMax; ++z)
					dst[z] = Array1DUtil.arrayToIntArray(seqIn.getDataXY(t,z,c),false);
				
				for(int z = box.z; z < boxZMax; ++z)
				{
					tasks.add(service.submit(new Clahe_3D_slice(src, dst, blockRadius,block_z, bins, slope, box, z, dim_x, dim_y, dim_z, boxXMax, boxYMax)));	
					
					
				}
				for(Future<?> task : tasks)
				{
					try {
						task.get();
					} catch (InterruptedException e) {
					} catch (ExecutionException e) {
					}
				}			
				tasks.clear();
				
				for(int z = box.z; z < boxZMax; ++z)
				{
								
					
					Array1DUtil.intArrayToSafeArray(dst[z], icy_img[z].getDataXY(c), icy_img[z].isSignedDataType());
					
				}
			}
			for(int z = box.z; z < boxZMax; ++z)
				seq_out.setImage(t, z, icy_img[z]);
		}	
		
		
		return seq_out;
	}
	
	public void clean()
	{
	}

	@Override
	public void declareInput(VarList inputMap) {
		// TODO Auto-generated method stub
		inputMap.add(input.getVariable());
		
		inputMap.add(type.getVariable());
		inputMap.add(bins_menu.getVariable());
		inputMap.add(half_size.getVariable());
		inputMap.add(half_sizeZ.getVariable());
		inputMap.add(slope_menu.getVariable());
		
	}

	@Override
	public void declareOutput(VarList outputMap) {
		// TODO Auto-generated method stub
		outputMap.add(output.getVariable());
	}

	
}
class Clahe_3D_slice implements Runnable
{
	Cube box;
	int z,dim_x,dim_y,dim_z;
	int blockRadius;
	int block_z;
	int bins;
	double slope;
	int[][] src;
	int[][] dst;
	int boxXMax;
	int boxYMax;

	public Clahe_3D_slice(int[][] src, int[][] dst, int blockRadius, int block_z, int bins,double slope, Cube box, int z, int dim_x, int dim_y, int dim_z, int boxXMax, int boxYMax)
	{
		this.box=box;
		this.z=z;
		this.dim_x=dim_x;
		this.dim_y=dim_y;
		this.dim_z=dim_z;
		this.blockRadius=blockRadius;
		this.block_z=block_z;
		this.bins=bins;
		this.slope=slope;
		this.boxXMax=boxXMax;
		this.boxYMax=boxYMax;
		this.src=src;
		this.dst=dst;
		
	}
	@Override
	public void run() {
		// TODO Auto-generated method stub
		compute_slice();
		
	}
	private void compute_slice()
	{
		int zMin = Math.max( 0, z - block_z );
		int zMax = Math.min( dim_z, z + block_z + 1 );
		int d = zMax - zMin;			
		
				
		for ( int y = box.y; y < boxYMax; ++y )
		{
			int yMin = Math.max( 0, y - blockRadius );
			int yMax = Math.min( dim_y, y + blockRadius + 1 );
			//int h = yMax - yMin;
			int h = Math.min( dim_y, yMax ) - yMin;
			
			int xMin0 = Math.max( 0, box.x - blockRadius );
			int xMax0 = Math.min( dim_x - 1, box.x + blockRadius );
			
						
			/* initially fill histogram */
			int[] hist = new int[ bins + 1 ];
			int[] clippedHist = new int[ bins + 1 ];
			for ( int zi = zMin; zi < zMax; ++zi )
			for ( int yi = yMin; yi < yMax; ++yi )
				for ( int xi = xMin0; xi < xMax0; ++xi )
					++hist[ roundPositive( src[zi][yi*dim_x+xi] / 255.0f * bins ) ];
			
			
			
			
			for ( int x = box.x; x < boxXMax; ++x )
			{
				int v = roundPositive( src[z][y*dim_x+x] / 255.0f * bins );
			
				int xMin = Math.max( 0, x - blockRadius );
				int xMax = x + blockRadius + 1;
				//int w = xMax - xMin;
				int w = Math.min( dim_x, xMax ) - xMin;
				int n = h * w * d;
				
				int limit;
				limit = ( int )( slope * n / bins + 0.5f );
				
				/* remove left behind values from histogram */
				if ( xMin > 0 )
				{
					int xMin1 = xMin - 1;
					for ( int zi = zMin; zi < zMax; ++zi )
					for ( int yi = yMin; yi < yMax; ++yi )
						--hist[ roundPositive( src[zi][yi*dim_x+xMin1] / 255.0f * bins ) ];						
				}
					
				/* add newly included values to histogram */
				if ( xMax <= dim_x )
				{
					int xMax1 = xMax - 1;
					for ( int zi = zMin; zi < zMax; ++zi )
					for ( int yi = yMin; yi < yMax; ++yi )
						++hist[ roundPositive( src[zi][yi*dim_x+xMax1] / 255.0f * bins ) ];						
				}
									
				/* clip histogram and redistribute clipped entries */
				System.arraycopy( hist, 0, clippedHist, 0, hist.length );
				int clippedEntries = 0, clippedEntriesBefore;
				do
				{
					clippedEntriesBefore = clippedEntries;
					clippedEntries = 0;
					for ( int i = 0; i <= bins; ++i )
					{
						int dold = clippedHist[ i ] - limit;
						if ( dold > 0 )
						{
							clippedEntries += dold;
							clippedHist[ i ] = limit;
						}
					}
					
					int dold = clippedEntries / ( bins + 1 );
					int m = clippedEntries % ( bins + 1 );
					for ( int i = 0; i <= bins; ++i)
						clippedHist[ i ] += dold;
					
					if ( m != 0 )
					{
						int s = bins / m;
						for ( int i = 0; i <= bins; i += s )
							++clippedHist[ i ];
					}
				}
				while ( clippedEntries != clippedEntriesBefore );
				
				/* build cdf of clipped histogram */
				int hMin = bins;
				for ( int i = 0; i < hMin; ++i )
					if ( clippedHist[ i ] != 0 ) hMin = i;
				
				int cdf = 0;
				for ( int i = hMin; i <= v; ++i )
					cdf += clippedHist[ i ];
				
				int cdfMax = cdf;
				for ( int i = v + 1; i <= bins; ++i )
					cdfMax += clippedHist[ i ];
				
				int cdfMin = clippedHist[ hMin ];
				
				dst[z][y*dim_x+x]=roundPositive( ( cdf - cdfMin ) / ( float )( cdfMax - cdfMin ) * 255.0f );
				
			}
		}
		
	}
	private int roundPositive( float a )
	{
		return ( int )( a + 0.5f );
	}
	
}

class Clahe_m2D_slice implements Runnable
{
	Rectangle box;
	int z,dim_x,dim_y,dim_z;
	int blockRadius;
	int bins;
	double slope;
	int[][] src;
	int[][] dst;
	int boxXMax;
	int boxYMax;

	public Clahe_m2D_slice(int[][] src, int[][] dst, int blockRadius, int bins,double slope, Rectangle box, int z, int dim_x, int dim_y, int dim_z, int boxXMax, int boxYMax)
	{
		this.box=box;
		this.z=z;
		this.dim_x=dim_x;
		this.dim_y=dim_y;
		this.dim_z=dim_z;
		this.blockRadius=blockRadius;
		this.bins=bins;
		this.slope=slope;
		this.boxXMax=boxXMax;
		this.boxYMax=boxYMax;
		this.src=src;
		this.dst=dst;
		
	}
	@Override
	public void run() {
		// TODO Auto-generated method stub
		compute_slice();
		
	}
	private void compute_slice()
	{
					
		
				
		for ( int y = box.y; y < boxYMax; ++y )
		{
			int yMin = Math.max( 0, y - blockRadius );
			int yMax = Math.min( dim_y, y + blockRadius + 1 );
			int h = yMax - yMin;
			
			int xMin0 = Math.max( 0, box.x - blockRadius );
			int xMax0 = Math.min( dim_x - 1, box.x + blockRadius );
						
			/* initially fill histogram */
			int[] hist = new int[ bins + 1 ];
			int[] clippedHist = new int[ bins + 1 ];
			for ( int yi = yMin; yi < yMax; ++yi )
				for ( int xi = xMin0; xi < xMax0; ++xi )
					++hist[ roundPositive( src[z][yi*dim_x+xi] / 255.0f * bins ) ];
			
			for ( int x = box.x; x < boxXMax; ++x )
			{
				int v = roundPositive( src[z][y*dim_x+x] / 255.0f * bins );
				
				int xMin = Math.max( 0, x - blockRadius );
				int xMax = x + blockRadius + 1;
				int w = Math.min( dim_x, xMax ) - xMin;
				int n = h * w;
				
				int limit;
				limit = ( int )( slope * n / bins + 0.5f );
				
				/* remove left behind values from histogram */
				if ( xMin > 0 )
				{
					int xMin1 = xMin - 1;
					for ( int yi = yMin; yi < yMax; ++yi )
						--hist[ roundPositive( src[z][yi*dim_x+xMin1] / 255.0f * bins ) ];						
				}
					
				/* add newly included values to histogram */
				if ( xMax <= dim_x )
				{
					int xMax1 = xMax - 1;
					for ( int yi = yMin; yi < yMax; ++yi )
						++hist[ roundPositive( src[z][yi*dim_x+xMax1] / 255.0f * bins ) ];						
				}
				
				/* clip histogram and redistribute clipped entries */
				System.arraycopy( hist, 0, clippedHist, 0, hist.length );
				int clippedEntries = 0, clippedEntriesBefore;
				do
				{
					clippedEntriesBefore = clippedEntries;
					clippedEntries = 0;
					for ( int i = 0; i <= bins; ++i )
					{
						int d = clippedHist[ i ] - limit;
						if ( d > 0 )
						{
							clippedEntries += d;
							clippedHist[ i ] = limit;
						}
					}
					
					int d = clippedEntries / ( bins + 1 );
					int m = clippedEntries % ( bins + 1 );
					for ( int i = 0; i <= bins; ++i)
						clippedHist[ i ] += d;
					
					if ( m != 0 )
					{
						int s = bins / m;
						for ( int i = 0; i <= bins; i += s )
							++clippedHist[ i ];
					}
				}
				while ( clippedEntries != clippedEntriesBefore );
				
				/* build cdf of clipped histogram */
				int hMin = bins;
				for ( int i = 0; i < hMin; ++i )
					if ( clippedHist[ i ] != 0 ) hMin = i;
				
				int cdf = 0;
				for ( int i = hMin; i <= v; ++i )
					cdf += clippedHist[ i ];
				
				int cdfMax = cdf;
				for ( int i = v + 1; i <= bins; ++i )
					cdfMax += clippedHist[ i ];
				
				int cdfMin = clippedHist[ hMin ];
				
				//dst.set( x, y, roundPositive( ( cdf - cdfMin ) / ( float )( cdfMax - cdfMin ) * 255.0f ) );
				dst[z][y*dim_x+x]=roundPositive( ( cdf - cdfMin ) / ( float )( cdfMax - cdfMin ) * 255.0f );
			}
		}
		
	}
	private int roundPositive( float a )
	{
		return ( int )( a + 0.5f );
	}
	
}



