package plugins.ylemontag.matlabblocks;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;

import java.io.IOException;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.BlockInfo;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import plugins.ylemontag.matlabio.ComplexMode;
import plugins.ylemontag.matlabio.MatlabImporter;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Block that takes an .mat file and a Matlab variable ID (i.e. a string) in
 * input and return the imported sequence
 */
public class MatlabImporterBlock extends Plugin implements Block, BlockInfo, PluginBundled
{
	private VarFile              _file    = new VarFile("File", null);
	private VarString            _key     = new VarString("Variable ID", "");
	private VarDimensionMapping  _mapping = new VarDimensionMapping("Dimension mapping", null);
	private VarEnum<ComplexMode> _complex = new VarEnum<ComplexMode>("Complex mode", ComplexMode.BOTH);
	private VarSequence          _out     = new VarSequence("Data", null);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		_file.setDefaultEditorModel(MatlabBlockUtil.makeMatFileEditor());
		inputMap.add(_file   );
		inputMap.add(_key    );
		inputMap.add(_mapping);
		inputMap.add(_complex);
	}
	
	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_out);
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return MatlabBlockLibrary.class.getName();
	}
	
	@Override
	public String getName()
	{
		return "Matlab importer";
	}

	@Override
	public String getDescription()
	{
		return "Import a sequence from a Matlab .mat file";
	}
	
	@Override
	public void run()
	{
		try {
			MatlabImporter importer = new MatlabImporter(_file.getValue());
			_out.setValue(importer.getSequence(_key.getValue(), _mapping.getValue(), _complex.getValue()));
		}
		catch(IOException err) {
			MatlabBlockUtil.reportError(err);
		}
	}
}
