/*
 * Copyright 2010, 2011 Institut Pasteur.
 * 
 * This file is part of ICY.
 * 
 * ICY is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * ICY is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ICY. If not, see <http://www.gnu.org/licenses/>.
 */

package plugins.tlecomte.rectangularFEM;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;

public class BoundaryTools {
	// take a Nq2 vector and returns a Nq2_Omega0 vector with only the interior points
	public static SparseRCDoubleMatrix2D assembleAInterior(Mesh mesh) {
	    System.out.println("Assembling A interior matrix");

	    int N = mesh.nodes.length; // number of biquadratic nodes
	    int Nfree = mesh.freeNodes.length; // number of free biquadratic nodes
	    
	    int[] row = new int[Nfree];
	    int[] col = new int[Nfree];
	    double[] data = new double[Nfree];
	    // ...and build them by summing over all the elements contributions
	    int j = 0;
	    for (Node node : mesh.nodes) {
	    	if (node.pointer != -1) {
		        row[j] = node.pointer;
		        col[j] = node.index;
		        data[j] = 1.;
		    	j++;	
	    	}
	    }
	        
	    SparseRCDoubleMatrix2D A = new SparseRCDoubleMatrix2D(Nfree, N, row, col, data, true /* remove duplicates */, true /* remove zeroes */, false /* sort column indices */);
	
	    return A;  
	}
	
	// take a Nq2 vector and returns a Nq2 vector with values zeroed-out at interior points
	public static SparseRCDoubleMatrix2D assembleABoundary(SparseRCDoubleMatrix2D Ainterior) {
	    System.out.println("Assembling A boundary matrix");

	    final SparseRCDoubleMatrix2D I = ((SparseDoubleMatrix2D) DoubleFactory2D.sparse.identity(Ainterior.columns())).getRowCompressed(true);
	    
	    // I = -Aexterior*Ainterior + I
	    // FIXME Contrary to the documentation, the following line gives a wrong result, the initial value of I does not seem to be taken into account, as if beta equals to zero !
	    // I = (SparseRCDoubleMatrix2D) Ainterior.getTranspose().zMult(Ainterior, I, -1., 1., false, false);
	    // The dense version works:
	    // DenseDoubleMatrix2D denseAinterior = Ainterior.getDense();
	    // DenseDoubleMatrix2D denseAexterior = Ainterior.getTranspose().getDense();
	    // DenseDoubleMatrix2D denseI = (DenseDoubleMatrix2D) DoubleFactory2D.dense.identity(denseAinterior.columns());
	    // denseI = (DenseDoubleMatrix2D) denseAexterior.zMult(denseAinterior, denseI, -1., 1., false, false);

	    Ainterior.getTranspose().zMult(Ainterior, null).forEachNonZero(new IntIntDoubleFunction() {
	        public double apply(int row, int column, double value) {
	            I.setQuick(row, column, I.getQuick(row, column) - value);
	            return value;
	        }
	    });
	    
	    return I;
	}
}
