package plugins.spop.advancefilters;

import icy.image.IcyBufferedImage;
import icy.math.ArrayMath;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.filtering.Convolution1D;
import plugins.adufour.filtering.Kernels1D;


public class MembraneFilter extends EzPlug  implements Block{

	EzVarSequence input = new EzVarSequence("Input");
	EzVarSequence output = new EzVarSequence("Output");
	
	EzVarInteger iterations = new EzVarInteger("Iterations",20, 1, 10000, 1);
	EzVarDouble sigma = new EzVarDouble("Sigma",1,0.1,10,0.01);
	EzVarDouble ro = new EzVarDouble("Ro",2,0.1,10,0.01);
	
	EzVarDouble  k_PM = new EzVarDouble("K PM",5,0.01,100000,0.01);
	EzVarDouble thr = new EzVarDouble("Threshold",0.25,0.001,1,0.001);
	EzVarDouble z_rezolution = new EzVarDouble("Z/X ratio",2.64,0.001,10,0.001);//2.64 pt JF
	
	EzVarBoolean stack4D= new EzVarBoolean("4D stack", false);
	EzVarInteger no_thread = new EzVarInteger("No objects",3, 1, 20, 1);

	
	//VarSequence output = new VarSequence("Output", false);
	
	long time = 0;
	@Override
	public void initialize() {
		// TODO Auto-generated method stub
		addEzComponent(input);
		
		addEzComponent(iterations);
		
		addEzComponent(sigma);
		addEzComponent(ro);
		
		
		addEzComponent(z_rezolution);
		
		//addEzComponent(coh_3D);		
		addEzComponent(k_PM);
		addEzComponent(thr);
		addEzComponent(stack4D);
		addEzComponent(no_thread);
		stack4D.addVisibilityTriggerTo(no_thread, true);
		
		setTimeDisplay(true);
	}

	
	@Override
	public void execute() {
		// TODO Auto-generated method stub
		int NO_THREAD = no_thread.getValue();
		
        int iterationsIN=iterations.getValue();
        
        double sigmaIN=sigma.getValue();
        double roIN=ro.getValue();
        double k_PMin=k_PM.getValue();
        double thrIN=thr.getValue();
      
        
                      
		
		double dt=0.15;		
		
		double z_res=z_rezolution.getValue();
		
		Sequence seq_in = input.getValue();	
		System.out.println("Sequence: " + seq_in.getName());
		
		Sequence seq_out_t[]= new Sequence[seq_in.getSizeT()];
		
		
		
	
		ExecutorService service = Executors.newFixedThreadPool(NO_THREAD);//.newCachedThreadPool();		
		ArrayList<Future<?>> tasks = new ArrayList<Future<?>>();
	   
		for(int t=0;t<seq_in.getSizeT();t++)
		{
			Sequence seq_in_t = DiffusionTools.extractT(seq_in, t);
			seq_out_t[t] = new Sequence();
			
			tasks.add(service.submit(new Icip_3D(seq_in_t,iterationsIN,dt,sigmaIN,roIN,k_PMin,thrIN,z_res, seq_out_t[t])));
			
		}		

		for(Future<?> task : tasks)
		{
			try {
				task.get();
			} catch (InterruptedException e) {
			} catch (ExecutionException e) {
			}
		}
		
		tasks.clear();
      
		Sequence seq_out = new Sequence();
		for(int t=0;t<seq_in.getSizeT();t++)
			DiffusionTools.putT(seq_out, seq_out_t[t], t);
		
			
		if(getUI()!=null)
			addSequence(seq_out);
		output.setValue(seq_out);
		
						
		
	}

	
	public void clean()
	{
	}

	@Override
	public void declareInput(VarList inputMap) {
		// TODO Auto-generated method stub
		inputMap.add(input.getVariable());
		inputMap.add(iterations.getVariable());
		inputMap.add(sigma.getVariable());
		inputMap.add(ro.getVariable());
		
		inputMap.add(z_rezolution.getVariable());
		
		inputMap.add(k_PM.getVariable());
		inputMap.add(thr.getVariable());
		
		inputMap.add(stack4D.getVariable());
		inputMap.add(no_thread.getVariable());
		

		
		
		
		addEzComponent(stack4D);
		addEzComponent(no_thread);
		stack4D.addVisibilityTriggerTo(no_thread, true);
		

		
	}

	@Override
	public void declareOutput(VarList outputMap) {
		// TODO Auto-generated method stub
		outputMap.add(output.getVariable());
		
	}

}

class Icip_3D implements Runnable
{
	Sequence sequence;
	int  iter;
	double dt,  sigma,  ro,thr_PM, thr,hz_inv;
	
	Sequence seq_out;	
	static int index_constr=0;
	int object_no=0;
	
	double[] terebes;//=new double[1001];
	public Icip_3D()
	{
		System.out.println("One Object");
	}
			
	
	
	public Icip_3D(Sequence sequence, int iter, double dt,  double sigma, double ro,  double thr_PM,double thr, double z_res, Sequence seq_out) {
		
		this.sequence=sequence;
		
		this.iter=iter;
		this.dt=dt;
		this.sigma=sigma;
		this.ro=ro;
		this.thr_PM=thr_PM*thr_PM;
		double terebes_gain=10;
		this.terebes=DiffusionTools.fonction_Terebes_LUT(terebes_gain, thr);	 
	      
		this.hz_inv=(1.0/z_res);
		this.seq_out=seq_out;
	
		index_constr++;
		object_no=index_constr;
		
		System.out.println("Icip_3D object:" + index_constr );		
	}

	public void run()
	{
		System.out.println("Run object:"+object_no);
		int z=0;
		//z=sequence.getFirstViewer().getZ();
		double sigmaZ=sigma*hz_inv;
		double roZ=ro*hz_inv;
		
		
		int dim_x=sequence.getSizeX();
		int dim_y=sequence.getSizeY();
		int dim_z=sequence.getSizeZ();
		
		
		
		Sequence kernel1 = Kernels1D.CUSTOM_GAUSSIAN.createGaussianKernel1D(sigma).toSequence();
		Sequence kernel2= Kernels1D.CUSTOM_GAUSSIAN.createGaussianKernel1D(ro).toSequence();//keep in mind to make them ellipsoidal
		
		Sequence kernel1Z = Kernels1D.CUSTOM_GAUSSIAN.createGaussianKernel1D(sigmaZ).toSequence();
		Sequence kernel2Z= Kernels1D.CUSTOM_GAUSSIAN.createGaussianKernel1D(roZ).toSequence();
		
		int ker_test=(int) Math.ceil(roZ * 3.0f);
		ker_test=2*ker_test+3;
		
			
		if(ker_test>dim_z)
		{
			roZ=(((double)(dim_z)-3.0)/2.0)/3.0;
			if(roZ<sigmaZ)
			{
				sigmaZ=roZ;
				kernel1Z = Kernels1D.CUSTOM_GAUSSIAN.createGaussianKernel1D(sigmaZ).toSequence();
				kernel2Z = Kernels1D.CUSTOM_GAUSSIAN.createGaussianKernel1D(roZ).toSequence();
			}
			else
				kernel2 = Kernels1D.CUSTOM_GAUSSIAN.createGaussianKernel1D(roZ).toSequence();	
			
		}
					
		double[] ker1= kernel1.getDataXYAsDouble(0, 0, 0);
		double[] ker2= kernel2.getDataXYAsDouble(0, 0, 0);
		double[] ker1Z= kernel1Z.getDataXYAsDouble(0, 0, 0);
		double[] ker2Z= kernel2Z.getDataXYAsDouble(0, 0, 0);
		
		Sequence kernel_x = Kernels1D.GRADIENT.toSequence();        
            
        double[] kerX= kernel_x.getDataXYAsDouble(0, 0, 0);
        double[] kerZ=new double[kerX.length];
        for(int l_ker=0;l_ker<kerX.length;l_ker++)
        	kerZ[l_ker]=kerX[l_ker]*hz_inv;
		
							
		double[][] tab = new double[dim_z][dim_x*dim_y];
		double[][] tab_gauss = new double[dim_z][dim_x*dim_y];
		double[][] tab_a = new double[dim_z][dim_x*dim_y];
		double[][] tab_b = new double[dim_z][dim_x*dim_y];
		double[][] tab_c = new double[dim_z][dim_x*dim_y];
		double[][] tab_d = new double[dim_z][dim_x*dim_y];
		double[][] tab_e = new double[dim_z][dim_x*dim_y];
		double[][] tab_f = new double[dim_z][dim_x*dim_y];
		
			
		for(z=0;z<dim_z;z++)
		{
			tab[z] = Array1DUtil.arrayToDoubleArray(sequence.getDataXY(0,z,0), false);
			System.arraycopy(tab[z], 0, tab_gauss[z], 0, dim_x*dim_y);
		}
		
		
		for (int t = 0; t < iter; t++)
		{
			try{
			Convolution1D.convolve(tab_gauss, dim_x,dim_y,ker1, ker1, ker1Z);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
			
			for(z=0;z<dim_z;z++)
			{	
				
				System.arraycopy(tab_gauss[z], 0, tab_a[z], 0, dim_x*dim_y);
				System.arraycopy(tab_gauss[z], 0, tab_b[z], 0, dim_x*dim_y);
				System.arraycopy(tab_gauss[z], 0, tab_c[z], 0, dim_x*dim_y);
			}
			//first derivative - central ones
			try{
			Convolution1D.convolve(tab_a, dim_x,dim_y,kerX, null, null);
			Convolution1D.convolve(tab_b, dim_x,dim_y,null, kerX, null);
			Convolution1D.convolve(tab_c, dim_x,dim_y,null, null, kerZ);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
		
		//Tensor
		
			for(z=0;z<dim_z;z++)
			{
				
				
				ArrayMath.multiply(tab_b[z], tab_c[z],tab_f[z]);
				ArrayMath.multiply(tab_a[z], tab_c[z],tab_e[z]);
				ArrayMath.multiply(tab_a[z], tab_b[z],tab_d[z]);
				
				ArrayMath.multiply(tab_c[z], tab_c[z],tab_c[z]);
				ArrayMath.multiply(tab_b[z], tab_b[z],tab_b[z]);
				ArrayMath.multiply(tab_a[z], tab_a[z],tab_a[z]);
				
			}			
			try{
			Convolution1D.convolve(tab_a, dim_x,dim_y,ker2, ker2, ker2Z);
			Convolution1D.convolve(tab_b, dim_x,dim_y,ker2, ker2, ker2Z);
			Convolution1D.convolve(tab_c, dim_x,dim_y,ker2, ker2, ker2Z);
			Convolution1D.convolve(tab_d, dim_x,dim_y,ker2, ker2, ker2Z);
			Convolution1D.convolve(tab_e, dim_x,dim_y,ker2, ker2, ker2Z);
			Convolution1D.convolve(tab_f, dim_x,dim_y,ker2, ker2, ker2Z);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
			
			ExecutorService service = Executors.newCachedThreadPool();//newFixedThreadPool(MAX_NB_THREAD);//.newCachedThreadPool();		
			ArrayList<Future<?>> tasks = new ArrayList<Future<?>>();
			for(z=0;z<dim_z;z++)
				tasks.add(service.submit(new Icip_core(tab_a,tab_b,tab_c,tab_d,tab_e,tab_f,dim_x,dim_y,z,terebes,thr_PM,hz_inv)));			
			
			for(Future<?> task : tasks)
			{
				try {
					task.get();
				} catch (InterruptedException e) {
				} catch (ExecutionException e) {
				}
			}			
			tasks.clear();
			
			DiffusionTools.Anisotropic_3d_update_Zres(tab,tab_a,tab_b,tab_c,tab_d,tab_e,tab_f,dim_x,dim_y,dim_z,dt,hz_inv, tab_gauss);
			
			
			for(z=0;z<dim_z;z++)
				System.arraycopy(tab_gauss[z], 0, tab[z], 0, dim_x*dim_y);
			System.out.println("End iteration "+ (t+1)+"/"+iter+ " for Icip_3D object:"+object_no);
						
			
	        
		}
		//ArrayMath.rescale(tab[0], 0, 255, true);
		
		for(z=0;z<dim_z;z++)
		{	
			IcyBufferedImage icy = new IcyBufferedImage(dim_x, dim_y, 1, sequence.getDataType());
			
			Array1DUtil.doubleArrayToSafeArray(tab[z], icy.getDataXY(0), icy.isSignedDataType());
			seq_out.setImage(0, z, icy);//IcyBufferedImage.convertToType(Icy, sequence.getDataType(), false));
			
			
		}
		
				
		
	}
	
	
}
class Icip_core implements Runnable
{
	double[][] a;
	double[][] b;
	double[][] c;
	double[][] d;
	double[][] e;
	double[][] f;
	int width, height, z;
 
	double[] terebes;
	double thr_PM, hz_inv;
	
	public Icip_core()
	{
		System.out.println("One Object");
	}
	public Icip_core(double[][] a,double[][] b,double[][] c, double[][] d,double[][] e,double[][] f,int width, int height, int z,  double[] terebes, double thr_PM,double hz_inv)
	{
		this.a=a;this.b=b;this.c=c;this.d=d;this.e=e;this.f=f;
		this.width=width;this.height=height;
		this.z=z;
		
		this.terebes=terebes;
		this.thr_PM=thr_PM;
		this.hz_inv=hz_inv;
		
	}
	@Override
	public void run() {
		// TODO Auto-generated method stub
		double  lambda2=0, lambda=0,coh_value=0,lambdaalfa=0;
		double val0,val1;
		
		double a1, b1, c1, d1, e1, f1;
		
		double[] valeur=new double[3];
		double[] vector=new double[9];
		for (int temp=0; temp<height*width; temp++)			
		{
			
			a1=a[z][temp];
			b1=b[z][temp];
			c1=c[z][temp];
			d1=d[z][temp];
			e1=e[z][temp];
			f1=f[z][temp];
			DiffusionTools.eigenvalues_computation(a1, b1, c1, d1, e1, f1,valeur);
			DiffusionTools.eigenvectors_computation(a1, b1, c1, d1, e1, f1,valeur,vector);
			val0=Math.abs(valeur[0]);
			val1=Math.abs(valeur[1]);
			
						
							
		            
        	coh_value=((val0-val1)/(val0+val1));
			coh_value=terebes[(int) Math.round(coh_value*1000)];
			lambda=1;
			lambdaalfa=DiffusionTools.PM_function_fluxDerive(val0, thr_PM);
			lambda2=Math.max(lambdaalfa,0)-(Math.max(lambdaalfa,0)-lambda)*coh_value;
    	
			
			a[z][temp]=lambdaalfa*vector[0]*vector[0]+lambda2*vector[3]*vector[3]+lambda*vector[6]*vector[6];
			b[z][temp]=lambdaalfa*vector[1]*vector[1]+lambda2*vector[4]*vector[4]+lambda*vector[7]*vector[7];
			c[z][temp]=lambdaalfa*vector[2]*vector[2]+lambda2*vector[5]*vector[5]+lambda*vector[8]*vector[8];
			d[z][temp]=lambdaalfa*vector[0]*vector[1]+lambda2*vector[3]*vector[4]+lambda*vector[6]*vector[7];
			e[z][temp]=lambdaalfa*vector[0]*vector[2]+lambda2*vector[3]*vector[5]+lambda*vector[6]*vector[8];
			f[z][temp]=lambdaalfa*vector[1]*vector[2]+lambda2*vector[4]*vector[5]+lambda*vector[7]*vector[8];			
				

		}
		
	}
}

