package plugins.fab.connectedcomponentexportxls;

import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.connectedcomponents.ConnectedComponent;
import plugins.adufour.connectedcomponents.ConnectedComponentDescriptor;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;

public class ConnectedComponentExportXLSBlock extends Plugin implements Block {

	// computation of intensities and ROIs are performed based on the input sequence
	
    protected VarGenericArray<ConnectedComponent[]> inputConnectedComponents = 
    		new VarGenericArray<ConnectedComponent[]>("components", ConnectedComponent[].class, null);
	VarSequence inputSequenceVar = new VarSequence("input Sequence", null);
	VarFile excelFile = new VarFile("Excel file", null );
	
	@Override
	public void run() {
	

		ConnectedComponent[] cc = inputConnectedComponents.getValue();
	
		XlsManager xlsManager = null;
		
		if ( excelFile.getValue() == null )
		{
			System.out.println("You need to set an Excel File for output.");
			return;		
		}
		
		File xlsFile = new File ( FileUtil.setExtension( excelFile.getValue().getAbsolutePath() , ".xls" ) );
		
		try {
			xlsManager = new XlsManager( xlsFile );
		} catch (IOException e) {
			throw new VarException("Can't write XLS file. File already opened ?");
		}
		
		// export all components
		
		exportAllComponents( xlsManager,  cc );
		
		// sort components by t.
		
		exportAllComponentsByT( xlsManager,  cc );
		
		// sort component by ROI.

		exportAllComponentsByROI( xlsManager,  cc );

		
		xlsManager.SaveAndClose();		
		
		
		
		
	}
	
	private void exportAllComponents(XlsManager xls,
			ConnectedComponent[] ccArray ) {
		
		//System.out.println("Exporting all components...");
		
		Sequence inputSequence = inputSequenceVar.getValue(); 
				
		xls.createNewPage("All results");
		
		writeTitle( xls , "All results" );
		
		writeXLSCCLabel( xls , inputSequence );
		 
		int index = 1;
		
		for ( ConnectedComponent cc : ccArray )
		{
//			System.out.print(".");
			writeXLS(xls, cc, index , inputSequence );			
			index++;
		}
//		System.out.println(".");

	}

	private void exportAllComponentsByROI(XlsManager xlsManager,
			ConnectedComponent[] ccArray ) {

		//System.out.println("Exporting all components by ROI...");
		
		Sequence inputSequence = inputSequenceVar.getValue(); 
		
		xlsManager.createNewPage("sort by ROI");

		ArrayList<ROI2D> roiList = inputSequence.getROI2Ds();

		if (roiList.size() == 0 )
		{
			writeTitle( xlsManager , "No ROI in sequence" );
			return;
		}
		
		//System.out.println("Writing ROI summary");
		// ROI Summary
		{
			writeTitle( xlsManager , "ROI Summary" );
			writeROILabel( xlsManager , true );
			
			for ( ROI2D roi : roiList )
			{
				int nbDetection = 0;
				for ( ConnectedComponent cc : ccArray )
				{
					if ( roi.contains( new Point2D.Double( cc.getX() , cc.getY() ) ) )
					{
						nbDetection++;	
					}					
				}

				writeROI( xlsManager , roi , nbDetection );

			}

		}
		//System.out.println("Writing ROI details");
		
		// ROI Details

		writeTitle( xlsManager , "ROI Detail" );
		
		for ( ROI2D roi : roiList )
		{
			writeTitle( xlsManager , "ROI" );
			writeROILabel( xlsManager , false );
			writeROI( xlsManager , roi );
			
			writeXLSCCLabel( xlsManager , inputSequence );
			int index = 1;
			for ( ConnectedComponent cc : ccArray )
			{
				if ( roi.contains( new Point2D.Double( cc.getX() , cc.getY() ) ) )
				{
					writeXLS(xlsManager, cc, index , inputSequence );					
					index++;
				}
			}
		}
		
		
	}

	private void exportAllComponentsByT(XlsManager xlsManager,
			ConnectedComponent[] ccArray ) {

		//System.out.println("Exporting all components by T...");
		
		Sequence inputSequence = inputSequenceVar.getValue(); 
		
		xlsManager.createNewPage("sort by T");
		
		// create map over T and find maxT
		
		HashMap<Integer , ArrayList<ConnectedComponent> >mapT = new HashMap< Integer , ArrayList<ConnectedComponent> >();
		
		int maxT = 0;
		for ( ConnectedComponent cc : ccArray )
		{
			int t = cc.getT();
			if ( t > maxT ) maxT = t;

			ArrayList<ConnectedComponent> alcc = mapT.get( t );
			if ( alcc == null )
			{
				alcc = new ArrayList<ConnectedComponent>();
				mapT.put( t , alcc );
			}
			alcc.add( cc );
		}
		
		// summary for each t
		{
			writeTitle( xlsManager , "Summary for each t" );
			int y = xlsManager.getExcelPage().getRows();
			xlsManager.setLabel( 0 , y, "t");	
			xlsManager.setLabel( 1 , y, "nb object");
			for ( int t=0; t<=maxT ; t++)
			{
				y++;
				xlsManager.setNumber( 0, y, t );
				if ( mapT.get( t ) == null ) continue;
				xlsManager.setNumber( 1, y, mapT.get( t ).size() );			
			}
		}
		
		writeTitle( xlsManager , "Detail for each t" );
		
		writeXLSCCLabel( xlsManager , inputSequence );

		for ( int t=0; t<=maxT ; t++)
		{
			writeTitle( xlsManager , "t = "+t );
			int index = 1;
			
			if ( mapT.get( t ) == null ) continue;
			
			for ( ConnectedComponent cc : mapT.get( t ) )
			{
				writeXLS(xlsManager, cc, index , inputSequence );
				index++;
			}
		}
		
	}

	private void writeROILabel( XlsManager xls,  boolean writeNbDetection ) {

		int y = xls.getExcelPage().getRows();
		xls.setLabel( 0 , y, "ROI Id");	
		xls.setLabel( 1 , y, "ROI Name");	
		xls.setLabel( 2 , y, "ROI Area");	
		if ( writeNbDetection )
		{
			xls.setLabel( 3 , y, "ROI NbDetection");
		}

	}
	
	private void writeTitle( XlsManager xls,  String text ) {

		int y = xls.getExcelPage().getRows();
		xls.setLabel( 0 , y++, "--------" );	
		xls.setLabel( 0 , y++, text );	
		xls.setLabel( 0 , y, "----" );	

	}
	
	private void writeROI(XlsManager xls, ROI2D roi, int nbDetection ) {
		
		int y = xls.getExcelPage().getRows();

		xls.setLabel( 0 , y, ""+roi.getId() );	
		xls.setLabel( 1 , y, roi.getName() );	
		xls.setNumber( 2 , y, computeROISurface( roi ) );	
		xls.setNumber( 3 , y, nbDetection );	

	}

	private void writeROI(XlsManager xls, ROI2D roi ) {
		
		int y = xls.getExcelPage().getRows();

		xls.setLabel( 0 , y, ""+roi.getId() );	
		xls.setLabel( 1 , y, roi.getName() );	
		xls.setNumber( 2 , y, computeROISurface( roi ) );	
		

	}

	
	private void writeXLSCCLabel( XlsManager xls , Sequence sequence )
	{
		int y = xls.getExcelPage().getRows();
		
		xls.setLabel( 0 , y, "#");
		xls.setLabel( 1 , y, "t");
		xls.setLabel( 2 , y, "x");
		xls.setLabel( 3 , y, "y");
		xls.setLabel( 4 , y, "z");
		xls.setLabel( 5 , y, "area");
		xls.setLabel( 6 , y, "sphericity");
		xls.setLabel( 7 , y, "eccentricity");
		xls.setLabel( 8 , y, "M100");
		xls.setLabel( 9 , y, "M010");
		xls.setLabel( 10 , y, "M001");
		xls.setLabel( 11 , y, "M110");
		xls.setLabel( 12 , y, "M101");
		xls.setLabel( 13 , y, "M011");
		xls.setLabel( 14 , y, "M111");
		xls.setLabel( 15 , y, "M200");
		xls.setLabel( 16 , y, "M020");
		xls.setLabel( 17 , y, "M002");
		xls.setLabel( 18 , y, "M220");
		xls.setLabel( 19 , y, "M202");
		xls.setLabel( 20 , y, "M022");
		xls.setLabel( 21 , y, "M222");
		
		if ( sequence == null ) return;
		
		int x = 22;
		for ( int c = 0 ; c < sequence.getSizeC() ; c++ )
		{
			xls.setLabel(x, y, "Min chan#"+c );
			x++;
		}
		for ( int c = 0 ; c < sequence.getSizeC() ; c++ )
		{
			xls.setLabel(x, y, "Max chan#"+c );
			x++;
		}
		for ( int c = 0 ; c < sequence.getSizeC() ; c++ )
		{
			xls.setLabel(x, y, "Mean chan#"+c );
			x++;
		}
		
	}

	private void writeXLS( XlsManager xls , ConnectedComponent cc , int index , Sequence sequence )
	{
		int y = xls.getExcelPage().getRows();
		
		ConnectedComponentDescriptor shapeDescriptor = new ConnectedComponentDescriptor( );
		
        boolean is2D = shapeDescriptor.is2D(cc);

		xls.setNumber( 0 , y, index );
		xls.setNumber( 1 , y, cc.getT() );
		xls.setNumber( 2 , y, cc.getX() );
		xls.setNumber( 3 , y, cc.getY() );
		xls.setNumber( 4 , y, cc.getZ() );
		xls.setNumber( 5 , y, cc.getSize() );
		xls.setNumber( 6 , y, shapeDescriptor.computeSphericity(cc) );
		xls.setNumber( 7 , y, shapeDescriptor.computeEccentricity(cc) );
		xls.setNumber( 8 , y, shapeDescriptor.computeGeometricMoment(cc, 1, 0, 0) );
		xls.setNumber( 9 , y, shapeDescriptor.computeGeometricMoment(cc, 0, 1, 0) );
		if (!is2D) xls.setNumber( 10 , y, shapeDescriptor.computeGeometricMoment(cc, 0, 0, 1) );
		xls.setNumber( 11 , y, shapeDescriptor.computeGeometricMoment(cc, 1, 1, 0) );
		if (!is2D) xls.setNumber( 12 , y, shapeDescriptor.computeGeometricMoment(cc, 1, 0, 1) );
		if (!is2D) xls.setNumber( 13 , y, shapeDescriptor.computeGeometricMoment(cc, 0, 1, 1) );
		if (!is2D) xls.setNumber( 14 , y, shapeDescriptor.computeGeometricMoment(cc, 1, 1, 1) );
		xls.setNumber( 15 , y, shapeDescriptor.computeGeometricMoment(cc, 2, 0, 0) );
		xls.setNumber( 16 , y, shapeDescriptor.computeGeometricMoment(cc, 0, 2, 0) );
		if (!is2D) xls.setNumber( 17 , y, shapeDescriptor.computeGeometricMoment(cc, 0, 0, 2) );
		xls.setNumber( 18 , y, shapeDescriptor.computeGeometricMoment(cc, 2, 2, 0) );
		if (!is2D) xls.setNumber( 19 , y, shapeDescriptor.computeGeometricMoment(cc, 2, 0, 2) );
		if (!is2D) xls.setNumber( 20 , y, shapeDescriptor.computeGeometricMoment(cc, 0, 2, 2) );
		if (!is2D) xls.setNumber( 21 , y, shapeDescriptor.computeGeometricMoment(cc, 2, 2, 2) );
		
		if ( sequence == null ) return;
		
		int x = 22;
		
		double[] min = cc.computeMinIntensity( sequence );
		for ( int c = 0 ; c < min.length ; c++ )
		{
			xls.setNumber(x, y, min[c] );
			x++;
		}
		
		double[] max = cc.computeMaxIntensity( sequence );
		for ( int c = 0 ; c < sequence.getSizeC() ; c++ )
		{
			xls.setNumber(x, y, max[c] );
			x++;
		}
		
		double[] mean = cc.computeMeanIntensity( sequence );
		for ( int c = 0 ; c < sequence.getSizeC() ; c++ )
		{
			xls.setNumber(x, y, mean[c] );
			x++;
		}
		
		
		
	}
	
	int computeROISurface( ROI roi )
	{
		return (int) roi.getVolume();
//		if( roi instanceof ROI2D )
//		{
//			ROI2D roi2D = (ROI2D) roi;
//			boolean[] bool = roi2D.getAsBooleanMask( roi2D.getBounds() );
//
//			int surface = 0;
//			for ( int x = 0 ; x < bool.length ; x++ )
//			{
//				if ( bool[x] ) surface++;
//			}
//			return surface;
//		}
//		return 0;
	}
	

	@Override
	public void declareInput(VarList inputMap) {

		inputMap.add( inputConnectedComponents );
		inputMap.add( inputSequenceVar );
		inputMap.add( excelFile );
		
	}

	@Override
	public void declareOutput(VarList outputMap) {

		//outputMap.islinked( inputSequenceVar );
		
		
	}


}
