package plugins.fab.protractorroicutter;

import icy.gui.frame.progress.AnnounceFrame;
import icy.painter.Painter;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI2DPolygon;
import icy.roi.ROI2DRectangle;
import icy.sequence.Sequence;
import icy.util.ShapeUtil.ShapeOperation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.fab.protractor.ProtractorPainter;

public class ProtractorROICutter extends EzPlug {
	
	EzVarSequence varSequence = new EzVarSequence("Input sequence");
	EzVarDouble varMinAngle = new EzVarDouble("min Angle", -45, -360, 360, 0.1 );
	EzVarDouble varMaxAngle = new EzVarDouble("max Angle", 45 , -360, 360, 0.1 );
	
	EzVarBoolean useStepVar = new EzVarBoolean("Use step cut", false );
	EzVarInteger nbStep = new EzVarInteger("number of step", 10 , 1, 360, 1 );
	
	
	
	EzButton undoButton = new EzButton("Undo", new ActionListener() {
			
		@Override
		public void actionPerformed(ActionEvent arg0) {
			
			if ( roiUndoList.size() == 0 ) return;
			
			Sequence inputSequence = varSequence.getValue();
			inputSequence.removeAllROI();
			for ( ROI roi : roiUndoList )
			{
				inputSequence.addROI(roi);
			}			
		}
	} );
	
	EzButton createProtractorButton = new EzButton("Add a protractor", new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			new ProtractorPainter( varSequence.getValue() );
		}
	} );
	
	
	ArrayList<ROI> roiUndoList = new ArrayList<ROI>();

	@Override
	protected void initialize() {

		addEzComponent( varSequence );
		addEzComponent( varMinAngle );
		addEzComponent( varMaxAngle );
		addEzComponent( useStepVar );
		addEzComponent( nbStep );
		
		addEzComponent( createProtractorButton );
		addEzComponent( undoButton );
		
	}

	
	@Override
	public void clean() {
		
	}

	@Override
	protected void execute() {
		
		Sequence inputSequence = varSequence.getValue();
		
		// create undo data
		
		roiUndoList.clear();
		for ( ROI roi : inputSequence.getROIs() )
		{
			roiUndoList.add ( roi.getCopy() );
		}
		
		double minAngle = varMinAngle.getValue();
		double maxAngle = varMaxAngle.getValue();
		
		// get Protractor from Sequence
		
		ProtractorPainter protractorPainter = null;
		
		for ( Painter painter : inputSequence.getPainters() )
		{
			if ( painter instanceof ProtractorPainter )
			{
				protractorPainter = (ProtractorPainter) painter;
				break;
			}
		}
		
		if ( protractorPainter == null )
		{
			new AnnounceFrame("You had no protractor on the sequence.");			
			return;
		}				
		
		// compute sectors ------------------------------------------------------------
		
		// compute the ROI of the sector.

		ArrayList<Sector> sectorList = new ArrayList<Sector>();
		
						
		if ( !useStepVar.getValue() )
		{
			Sector sector = getSector( minAngle , maxAngle , protractorPainter );
			sectorList.add( sector );
		}else
		{
			double step = ( maxAngle - minAngle ) / (double) nbStep.getValue();
			for ( int s = 0 ; s < nbStep.getValue() ; s++ )
			{
				sectorList.add( 
				getSector( minAngle + s*step , minAngle + (s+1)*step, protractorPainter )
						);
			}
		}

		// compute opposite of the sector

		Sector antiSector = getSector( maxAngle , minAngle + 360, protractorPainter );
		sectorList.add( antiSector );
		
		// end of compute sectors ------------------------------------------------------
		
		
		
		// store existing ROIs
		
		ArrayList<ROI2D> roiInputList = inputSequence.getROI2Ds();
		
		// remove existing ROIs
				
		inputSequence.removeAllROI();
		
		// for each ROI
		
		for ( ROI2D roi2D : roiInputList )
		{
			for ( Sector sector : sectorList )
			{				
				ROI2D resultROI = roiAnd( roi2D , sector.roi );		
				resultROI.setColor( roi2D.getColor() );
				resultROI.setName( roi2D.getName() + " "+sector.minAngle + " to " + sector.maxAngle );
				if ( !resultROI.getBounds().isEmpty() )
				{
					inputSequence.addROI( resultROI );
				}
			}

		}
		
	}

		

	private Sector getSector(double minAngle, double maxAngle, ProtractorPainter protractorPainter ) {

		Sequence inputSequence = varSequence.getValue();
		double sequenceMaxSideDistance = Math.max( inputSequence.getSizeX() , inputSequence.getSizeY() );
		sequenceMaxSideDistance *=2;
		
		ArrayList<Point2D>pointList = new ArrayList<Point2D>();		

		Point2D center = protractorPainter.getPointLocation( 0 , 0 );
		pointList.add( center );

		Point2D minAnglePoint = protractorPainter.getPointLocation( minAngle , sequenceMaxSideDistance );
		pointList.add( minAnglePoint );

		for ( double angle = minAngle ; angle<=maxAngle ; angle++ )
		{
			Point2D anglePoint = protractorPainter.getPointLocation( angle , sequenceMaxSideDistance );
			pointList.add( anglePoint );	
		}		

		Point2D maxAnglePoint = protractorPainter.getPointLocation( maxAngle , sequenceMaxSideDistance );
		pointList.add( maxAnglePoint );				
		
		ROI2DPolygon polygonROI = new ROI2DPolygon();
		polygonROI.setPoints( pointList );
						
		ROI2DRectangle roiRectangleOfSequence = new ROI2DRectangle( new Rectangle2D.Float( 0, 0, inputSequence.getWidth(), inputSequence.getHeight() ) ); 

		ROI2D[] roiArray = { roiRectangleOfSequence , polygonROI };		
		ROI2D sector =  ROI2D.merge( roiArray , ShapeOperation.AND );
		
		Sector sectorR = new Sector( sector , minAngle , maxAngle );
		return sectorR;
	}


	ROI2D roiAnd( ROI2D roi1 , ROI2D roi2 )
	{
		ROI2D[] roiArray = { roi1 , roi2 };		
		ROI2D resultROI =  ROI2D.merge( roiArray , ShapeOperation.AND );
		return resultROI;
	}

}
