package plugins.fab.scriptblockv1;

import icy.plugin.abstract_.Plugin;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.model.TypeSelectionModel;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;

public class ScriptBlockV1 extends Plugin implements Block {

	VarMutable input1Var = new VarMutable("input 1", Integer.class );
	VarMutable input2Var = new VarMutable("input 2", Integer.class );
	
	VarString inputScript = new VarString("Script",
			"print('Hello, World');\n" +			
					"output1 = input1 * 2;"
					, 10 );
		
	VarMutable output1Var = new VarMutable("output 1", Integer.class );
	VarMutable output2Var = new VarMutable("output 2", Integer.class );
	
	@Override
	public void run() {
		
		ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");

        Object input1 = input1Var.getValue();
        Object input2 = input2Var.getValue();
        
        engine.put( "input1", input1 );
        engine.put( "input2", input2 );
                        
        try {
        	
        	String script = inputScript.getValue();			
        	engine.eval( script );
			
		} catch (ScriptException e) {
			
			throw new VarException( e.getMessage() );

		}
               
        output1Var.setValue( engine.get( "output1" ) );
        output2Var.setValue( engine.get( "output2" ) );
        
	}

	@Override
	public void declareInput(VarList inputMap) {

		inputMap.add( input1Var );
		inputMap.add( input2Var );
				
	    input1Var.setDefaultEditorModel( new TypeSelectionModel() );
	    input2Var.setDefaultEditorModel( new TypeSelectionModel() );
	        
		inputMap.add( inputScript );

	}

	@Override
	public void declareOutput(VarList outputMap) {

		output1Var.setDefaultEditorModel( new TypeSelectionModel() );
		output2Var.setDefaultEditorModel( new TypeSelectionModel() );

		outputMap.add( output1Var );
		outputMap.add( output2Var );

	}


}
