package plugins.fab.ptprg;

import icy.canvas.IcyCanvas;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.painter.Painter;
import icy.roi.ROI2D;
import icy.roi.ROI2DArea;
import icy.sequence.Sequence;
import icy.type.TypeUtil;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.vecmath.Point3i;

import plugins.adufour.connectedcomponents.ConnectedComponent;
import plugins.adufour.connectedcomponents.ConnectedComponents;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.Point3D;
import plugins.fab.spotDetector.detector.wavelets.UDWT.B3SplineUDWT;
import plugins.fab.spotDetector.detector.wavelets.UDWT.WaveletConfigException;

public class Ptprg extends EzPlug implements Painter {

	IcyFrame mainFrame ;

	//JButton startButton = new JButton("Start");
	EzVarInteger sensitivity = new EzVarInteger("Sensitivity" , 100 , 1 , 1000 , 1 );
	EzVarInteger scaleTextField = new EzVarInteger("Scale" , 2 , 1 , 5 , 1 );
	EzVarSequence inSequence = new EzVarSequence("input sequence");
	
//	JTextField sensitivityTextField = new JTextField("100");
//	JTextField scaleTextField = new JTextField("2");
	
	class Result
	{
		ROI2D roi;
		int meanRed;
		int meanGreen;
		public Result( ROI2D roi , int meanRed , int meanGreen )
		{
			this.roi = roi;
			this.meanGreen = meanGreen;
			this.meanRed = meanRed;
		}
	}
	
	ArrayList<Result> resultList = new ArrayList<Ptprg.Result>();
	
//	public void run() {
//		
//		JPanel mainPanel = new JPanel();
//		mainFrame = GuiUtil.generateTitleFrame("GHFC",
//				mainPanel, new Dimension(300,100), false, true, false ,false );
//
//		//startButton.addActionListener( this );
//
//		mainPanel.setLayout( new BoxLayout( mainPanel , BoxLayout.PAGE_AXIS ) );
//		mainPanel.add( GuiUtil.createLineBoxPanel( new JLabel("scale:") ,scaleTextField ) );
//		mainPanel.add( GuiUtil.createLineBoxPanel( new JLabel("sensitivity:") , sensitivityTextField ) );
//		mainPanel.add( GuiUtil.createLineBoxPanel( startButton ) );
//
//		mainFrame.addToMainDesktopPane();
//		mainFrame.pack();
//		mainFrame.center();		
//		mainFrame.setVisible( true );
//		mainFrame.requestFocus();
//		
//	}

//	@Override
//	public void actionPerformed(ActionEvent e) {
//
//		if ( e.getSource() == startButton )
//		{
//			performAnalysis();
//		}
//		
//	}

	private void performAnalysis() {

		// creation de la ROI en fonction du canal rouge
		// mean sur le rouge
		// mean sur le bleu

		Sequence inputSequence = inSequence.getValue();
		if ( inputSequence == null )
		{
			MessageDialog.showDialog("This plugin needs a sequence as input.", MessageDialog.INFORMATION_MESSAGE );
			return;			
		}

		if ( inputSequence.getSizeC() < 2 )
		{
			MessageDialog.showDialog("This plugin needs a sequence with two channels.", MessageDialog.INFORMATION_MESSAGE );
			return;			
		}

		
		ArrayList<DetectionSpot> detectionList = new ArrayList<DetectionSpot>();
				
		// perform wavelet threshold
		
		boolean detectNegative = false;
		int numScales = getNumberOfScale();
		IcyBufferedImage image = inputSequence.getImage( 0, 0);
	
		if (image!=null)
		{
			// compute scales

			final float dataIn[] = Array1DUtil.arrayToFloatArray(image.getDataXY(0), image.isSignedDataType() );
			//decompose the image
			B3SplineUDWT waveletTransform = new B3SplineUDWT();

			float[][] scales;
			try {
				scales = waveletTransform.b3WaveletScales2D(dataIn, image.getWidth(), image.getHeight(), numScales );
			} catch (WaveletConfigException e1) {
				e1.printStackTrace();
				// TODO: manage error
				System.out.println("error");
				return;
			}
			float[][] coefficients = waveletTransform.b3WaveletCoefficients2D(scales, dataIn, numScales, image.getWidth()*image.getHeight());
			Sequence resultSequence = new Sequence();
			resultSequence.setName("WaveletCoefficients");

			// Apply threshold to coefficients but not last one ( residual )

			// Filtering
			for ( int i = 0 ; i < coefficients.length-1 ; i++ )
			{
				if ( detectNegative )
				{
					for ( int ii = 0 ; ii < coefficients[i].length ; ii++ )
					{
						coefficients[i][ii]=-coefficients[i][ii];
					}
				}

				filter_wat( coefficients[i] , i , inputSequence.getWidth() , inputSequence.getHeight() );

			}

			// TODO: Instead of putting it to residual image 0 , remove it from reconstruction
			{ // fill of 0 the residual image
				float c[] = coefficients[coefficients.length-1];
				for ( int i = 0 ; i < c.length ; i++ )
				{
					c[i]=0;
				}					
			}

			//Icy.addSequence(resultSequence);
			resultSequence.dataChanged();
			//reconstruct the image from the wavelet coefficients
			final IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, TypeUtil.TYPE_BYTE );
			float[] binaryDetectionResult = new float[image.getWidth()*image.getHeight()];

			waveletTransform.b3WaveletReconstruction2D(coefficients, coefficients[numScales], binaryDetectionResult, numScales, image.getWidth()*image.getHeight());

			// Binarisation de la reconstruction.
			{
				for ( int i = 0 ; i < binaryDetectionResult.length ; i++ )
				{
					if ( binaryDetectionResult[i] != 0 ) // >
					{
						binaryDetectionResult[i] = 255;
					}else
					{
						binaryDetectionResult[i] = 0;
					}				
				}
			}

			ArrayUtil.arrayToArray( binaryDetectionResult, imageOut.getDataXY(0), image.isSignedDataType() );

			Sequence binarySequenceForConnectedComponentExtraction = new Sequence();
			binarySequenceForConnectedComponentExtraction.setImage(0, 0, imageOut);
			addConnectedComponentDetection( binarySequenceForConnectedComponentExtraction , detectionList , 0 );
			
//			if ( true )
//			{
//				Sequence reconstructionSequence = new Sequence();
//				reconstructionSequence.setImage(0, 0, imageOut);
//				addSequence( reconstructionSequence );
//			}
		
			//remove any ROI2DArea existing
			
			ArrayList<ROI2D> roiList = inputSequence.getROI2Ds();
			for ( ROI2D roi : roiList )
			{
				if ( roi instanceof ROI2DArea )
				{
					inputSequence.removeROI( roi );
				}
			}
			
			
			byte[] data = imageOut.getDataXYAsByte( 0 );
			
			boolean[] dataBoolean = new boolean[data.length];
			
			for ( int i = 0 ; i < data.length ; i++ )
			{
				dataBoolean[i] = ( data[i] != 0 );
			}
			
			// remove boolean which are not in any green ROI
			
//			if ( inputSequence.getROI2Ds().size()>0 )
//			{
//				//if ( inputSequence.getROI2Ds().get( 0 ) != null )
//				{
//					ROI2D inputROI = inputSequence.getROI2Ds().get( 0 );
//
//					for ( int x=0 ; x<imageOut.getWidth() ; x++ )
//						for ( int y=0 ; y<imageOut.getHeight() ; y++ )
//						{
//							if ( !inputROI.contains(x, y) )
//							{
//								dataBoolean[x+y*imageOut.getWidth()] = false;
//							}
//						}
//
//
//				}
//			}
			
			// creates the proper roiArea
			
			ROI2DArea roiArea = new ROI2DArea();
			roiArea.setAsBooleanMask( 0 , 0 , imageOut.getWidth(), imageOut.getHeight(), dataBoolean );
			roiArea.setColor( Color.white );
			inputSequence.addROI( roiArea );
			
			// computation for each ROI.
			
			double[] dataRed = Array1DUtil.arrayToDoubleArray( image.getDataXY( 0 ) , image.isSignedDataType() );
			double[] dataGreen = Array1DUtil.arrayToDoubleArray( image.getDataXY( 1 ) , image.isSignedDataType() );

			resultList.clear();
			
			for ( ROI2D roi : inputSequence.getROI2Ds() )
			{
				if (!( roi instanceof ROI2DArea ))
				{
					
					double nbRed = 0;
					double totalRed = 0;
					double nbGreen = 0;
					double totalGreen = 0;
					double meanGreen = 0;
					double meanRed = 0;	

					for ( int x = roi.getBounds().x ; x < roi.getBounds().width+roi.getBounds().x ; x++ )
					{
						for ( int y = roi.getBounds().y ; y < roi.getBounds().height+roi.getBounds().y ; y++ )
						{
							if ( roi.contains( x , y) )
							{
								nbRed++;
								totalRed+= dataRed[y*imageOut.getWidth()+x];						
								nbGreen++;
								totalGreen+= dataGreen[y*imageOut.getWidth()+x];						
							}
							
							
						}
					}
				
					if ( nbRed != 0 )
					{
						meanRed = totalRed / nbRed;
						meanGreen = totalGreen / nbGreen;
					}				
					
					resultList.add( new Result( roi , (int)meanRed, (int)meanGreen ) );
				}
			}
			
			
			
			// compute le mean rouge.

//			double[] dataRed = Array1DUtil.arrayToDoubleArray( image.getDataXY( 0 ) , image.isSignedDataType() );
//			double[] dataGreen = Array1DUtil.arrayToDoubleArray( image.getDataXY( 1 ) , image.isSignedDataType() );
//		
//			nbRed = 0;
//			totalRed = 0;
//			nbGreen = 0;
//			totalGreen = 0;
//			meanGreen = 0;
//			meanRed = 0;
//
//			for ( int x = roiArea.getBounds().x ; x < roiArea.getBounds().width+roiArea.getBounds().x ; x++ )
//			{
//				for ( int y = roiArea.getBounds().y ; y < roiArea.getBounds().height+roiArea.getBounds().y ; y++ )
//				{
//					if ( roiArea.contains( x , y) )
//					{
//						nbRed++;
//						totalRed+= dataRed[y*imageOut.getWidth()+x];						
//						nbGreen++;
//						totalGreen+= dataGreen[y*imageOut.getWidth()+x];						
//					}
//					
//					
//				}
//			}
//		
//			if ( nbRed != 0 )
//			{
//				meanRed = totalRed / nbRed;
//				meanGreen = totalGreen / nbGreen;
//			}
			
			inputSequence.removePainter( this );
			inputSequence.addPainter( this );
			
			
		}
		
		
	}
	
//	double nbRed = 0;
//	double totalRed = 0;
//	double meanRed = 0;
//	double nbGreen = 0;
//	double totalGreen = 0;
//	double meanGreen = 0;
	
	/**
	 * filters coefficients with the lambda computation
	 * 
	 */
	private void filter_wat( float[] coefficients, int depth , int width , int height ) 
	{

		if ( !isScaleEnabled( depth ) ) // if the scale is not selected, fill of 0. could be optimized by not rebuilding it.
		{
			for ( int i = 0 ; i<coefficients.length; i++)
			{
				coefficients[i] = 0;
			}
			return;
		}
		
		// Init lambda value
		double lambdac[] = new double[getNumberOfScale() + 2];

		for ( int i = 0 ; i < getNumberOfScale() + 2 ; i++ )
		{
			// ( 1 << (2*i) ) ) gives 1 , 4 , 16 , 64 , 256 , 1024 ...
			lambdac[i] = Math.sqrt(2 * Math.log(width * height / ( 1 << (2*i) ) ) );
		}
				
		ImageMathInfo imageCaract = avesigma( coefficients );

		double dcoeff[] = new double[5];

		for ( int i = 0 ; i < getNumberOfMaxEnabledScale() ; i++ )
		{
			dcoeff[i] = getScaleThreshold( i ) / 100.0d;
		}
		double coeffThr = ( lambdac[depth +1] * imageCaract.mad) / dcoeff[depth];		  
		
		for ( int i = 0 ; i < coefficients.length ; i++ )
		{
			if ( coefficients[ i ] >= coeffThr )
			{
				coefficients[ i ] = 255 ;
			}else
			{
				coefficients[ i ] = 0 ;
			}
		}

	}
	
	private int getNumberOfMaxEnabledScale() {
		
		return scaleTextField.getValue() ;
	}
	private double getScaleThreshold(int i) {
		
		return sensitivity.getValue() ;
	}
	private int getNumberOfScale() {
		
		return scaleTextField.getValue() ;
	}
	private boolean isScaleEnabled(int scale) {
		if ( scale == getNumberOfScale()-1 ) return true;
		return false;
	}

	private void addConnectedComponentDetection( Sequence binarySequence , ArrayList<DetectionSpot> detectionList , int t )
	{
		Map<Integer, List<ConnectedComponent>> result = 
			ConnectedComponents.extractConnectedComponents( binarySequence, 0, ConnectedComponents.ExtractionType.BACKGROUND , 0 , Integer.MAX_VALUE , null );
		
		detectionList.addAll( convert2detectionList( result , t ) );
		
	}
	private ArrayList<DetectionSpot> convert2detectionList(
			Map<Integer, List<ConnectedComponent>> result , int t ) {

		ArrayList<DetectionSpot> detectionList = new ArrayList<DetectionSpot>();
		
		for ( int i : result.keySet() )
		{
			List<ConnectedComponent> list = result.get( i );
			for ( ConnectedComponent cc : list ){
				DetectionSpot detection = new DetectionSpot();
				
				for ( Point3i point : cc.getPoints() )
				{
					detection.points.add( new Point3D( point.x, point.y , point.z ) );
				}
				detection.setT( t );
				
				detection.computeMassCenter();

				detectionList.add( detection ); 

			}
		}
			
		return detectionList;
		
	}



	private class ImageMathInfo
	{
		double mad ;
	}
	
	private ImageMathInfo avesigma( float[] coefficients )
	{
		ImageMathInfo ic = new ImageMathInfo();
		ic.mad = getMeanAverageDistance( coefficients );        
		return ic;
	}
	public double getMeanAverageDistance( float[] coefficients )
	{
		double mean = getMean( coefficients );
		double a = 0;
		double s ;

		for ( int i = 0 ; i < coefficients.length ; i++ )
		{
			s = coefficients[i] - mean;
			a = a + Math.abs( s );
		}
				
		if ( coefficients.length > 0 ) return a/coefficients.length ;
		return 0;
	}	
	public double getMean( float[] coefficients )
	{
		double mean = 0;
		double sum = 0;
		
		for ( int i = 0 ; i < coefficients.length ; i++ )
		{
			sum+= coefficients[i];
		}
		
		if ( coefficients.length > 0 ) mean = sum/coefficients.length;
		
		return mean;
	}


	@Override
	public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {}
	@Override
	public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {}
	@Override
	public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {}
	@Override
	public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {}
	@Override
	public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {}
	@Override
	public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {}
	@Override
	public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {}

	double convertScale( IcyCanvas canvas , double value )
	{
		return ROI2D.canvasToImageLogDeltaX(canvas, value ); 
	}


	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {

		
		for ( Result result : resultList )
		{
			
			String txt1 = "Mean Red: "+ result.meanRed ;
			String txt2 = "Mean Green: "+ result.meanGreen;
			
			int fontSize =  (int)convertScale(canvas, 15 );
			Font font =  new Font( "Arial" , Font.BOLD , fontSize );
			g.setFont( font );
			
			Rectangle2D pixelBounds1 = GuiUtil.getStringBounds( g , font, txt1 );
			Rectangle2D pixelBounds2 = GuiUtil.getStringBounds( g , font, txt2 );
			
			int x=0;
			int y=0;
			int yCenter = 0;
			try
			{
				x = result.roi.getBounds().x + result.roi.getBounds().width /2;
				y = result.roi.getBounds().y ;
				y = result.roi.getBounds().y + result.roi.getBounds().height /2 ;
			}catch ( Exception e)
			{
				
			}
			
			g.setColor( Color.white );	
			//g.setFont( new Font("Arial", Font.PLAIN, 10 ) );
			g.drawString( txt1, (int)(x - pixelBounds1.getWidth()/2), (int)( y - pixelBounds1.getHeight() ) );
			g.drawString( txt2, (int)(x - pixelBounds2.getWidth()/2) , (int)( y  ) );
			//g.drawString( txt2, x, y - pixelBounds1.getHeight() );
			
			
		}


	}

	@Override
	public void clean() {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void execute() {

				performAnalysis();
			
	}

	@Override
	protected void initialize() {

		addEzComponent( inSequence );
		addEzComponent( sensitivity );
		addEzComponent( scaleTextField );

	}


	
	
	

	
}
