package plugins.fab.UDWTWaveletResidualRemover;

import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;

import java.util.ArrayList;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.fab.spotDetector.detector.UDWTScale;
import plugins.fab.spotDetector.detector.wavelets.UDWT.B3SplineUDWT;
import plugins.fab.spotDetector.detector.wavelets.UDWT.WaveletConfigException;

public class UDWTWaveletResidualRemover extends EzPlug implements Block {

	ArrayList<UDWTScale> UDWTScaleArrayList = new ArrayList<UDWTScale>();
	
	EzVarInteger nbScaleVar = new EzVarInteger( "Number of Scales" , 2 , 0 , 10 , 1 );
	EzVarBoolean removeNegativeValueVar = new EzVarBoolean( "Remove negative values", true );
	EzVarSequence sequenceInputVar = new EzVarSequence("Input sequence" );
	EzVarSequence sequenceOutPutVar = new EzVarSequence("Output sequence" );
	
	@Override
	public void clean() {
		
	}

	@Override
	protected void execute() {

		final int nbScale = nbScaleVar.getValue();
		UDWTScaleArrayList.clear();
		
			ThreadUtil.invokeNow( new Runnable() {
				
				@Override
				public void run() {
					
					for ( int i = 0 ; i<= nbScale ; i++ )
					{

					UDWTScale scale = new UDWTScale( i+1 , true , 100 );	
					UDWTScaleArrayList.add( scale );										
					}
				}
			});
				
			if ( sequenceInputVar.getValue() == null )
			{
				System.err.println("UDWTWaveletResidualRemover: Can't process: Input sequence is null.");
				return;
			}
			
		Sequence outputSequence = removeResidual( sequenceInputVar.getValue() , removeNegativeValueVar.getValue() );
		
		// copy ROI from input to output.
		for ( ROI roi : sequenceInputVar.getValue().getROIs() )
		{
			ROI roiCopy = roi.getCopy();
			roiCopy.setColor( roi.getColor() );
			outputSequence.addROI( roiCopy );
		}
		
		if ( isHeadLess() ) // called by blocks.
		{
			sequenceOutPutVar.setValue( outputSequence );			
		}
		else
		{ // called by EzPlug
			addSequence( outputSequence );
		}
		
		
//		UDWTScale s1 = new UDWTScale( 1 , true , 100 );
//		UDWTScale s2 = new UDWTScale( 2 , true , 100 );
//		UDWTScale s3 = new UDWTScale( 3 , true , 100 );
//		UDWTScale s4 = new UDWTScale( 4 , true , 100 );
//		UDWTScale s5 = new UDWTScale( 5 , true , 100 );
//		UDWTScale s6 = new UDWTScale( 6 , true , 100 );
		
//		UDWTScaleArrayList.add( s1 );
//		UDWTScaleArrayList.add( s2 );
//		UDWTScaleArrayList.add( s3 );
//		UDWTScaleArrayList.add( s4 );
//		UDWTScaleArrayList.add( s5 );
//		UDWTScaleArrayList.add( s6 );
		
		
	}
	
	@Override
	protected void initialize() {
	
		addEzComponent( sequenceInputVar );
		addEzComponent( nbScaleVar );
		addEzComponent( removeNegativeValueVar );
		
	}
	
	@Override
	public void declareInput(VarList inputMap) {
		
		inputMap.add( sequenceInputVar.getVariable() );
		inputMap.add( nbScaleVar.getVariable() );
		inputMap.add( removeNegativeValueVar.getVariable() );	
		
	}

	@Override
	public void declareOutput(VarList outputMap) {

		outputMap.add( sequenceOutPutVar.getVariable() );	
		
	}

	int getNumberOfMaxEnabledScale()
	{
		int maxScale = 0;
		for ( UDWTScale scale : UDWTScaleArrayList )
		{
			if ( scale.isEnabled() ){
				if ( scale.scaleNumber > maxScale ) maxScale = scale.scaleNumber;
			}
		}
		return maxScale;
		
	}

	Sequence removeResidual( Sequence inputSequence , boolean removeNegativeValue )
	{
		
		int numScales = getNumberOfMaxEnabledScale();
		System.out.println("input sequence : " + inputSequence );
		Sequence rebuildSequence = new Sequence(inputSequence.getName() + " - residual removed");			
		
		if ( inputSequence.getSizeZ()>1 )
		{
			System.out.println("The plugin UDWTWaveletResidualRemover only works with 2D images");
			return null;
		}
		
		//
		// 2D Image
		//		
		
		if ( inputSequence.getSizeZ()==1 )
		{					
			
			{
				B3SplineUDWT waveletTransform = new B3SplineUDWT();
				if ( waveletTransform.isNumberOfScaleOkForImage2D( 
						inputSequence.getSizeX(),
						inputSequence.getSizeY(), getNumberOfMaxEnabledScale() ) == false )
				{
					System.err.println("Scale configuration error" );
					return null;
				}
			}
			
			for ( int t = 0 ; t < inputSequence.getSizeT() ; t++ )
			{
				//IcyBufferedImage image = inputSequence.getFirstImage();
				IcyBufferedImage image = inputSequence.getImage(t, 0);

				if (image!=null)
				{
					// compute scales

					final float dataIn[] = Array1DUtil.arrayToFloatArray(image.getDataXY(0), image.isSignedDataType() );
					//decompose the image
					B3SplineUDWT waveletTransform = new B3SplineUDWT();

					float[][] scales;
					try {
						scales = waveletTransform.b3WaveletScales2D(dataIn, image.getWidth(), image.getHeight(), numScales);
					} catch (WaveletConfigException e1) {
						e1.printStackTrace();
						return null;
					}
					
					float[][] coefficients = waveletTransform.b3WaveletCoefficients2D(scales, dataIn, numScales, image.getWidth()*image.getHeight());
//					Sequence resultSequence = new Sequence();
//					resultSequence.setName("WaveletCoefficients");
					
					// Apply threshold to coefficients but not last one ( residual )
				
//					// Filtering
//					for ( int i = 0 ; i < coefficients.length-1 ; i++ )
//					{
//						if ( detectNegative )
//						{
//							for ( int ii = 0 ; ii < coefficients[i].length ; ii++ )
//							{
//								coefficients[i][ii]=-coefficients[i][ii];
//							}
//						}					
//						
//						filter_wat( coefficients[i] , i , inputSequence.getWidth() , inputSequence.getHeight() , mask );
//
//					}									

					// putting it to residual image 0 , remove it from reconstruction
//					{ // fill of 0 the residual image
//						float c[] = coefficients[coefficients.length-1];
//						for ( int i = 0 ; i < c.length ; i++ )
//						{
//							c[i]=0;
//						}					
//					}

					
					float[] cumulatedImage = new float[image.getWidth()*image.getHeight()];
					
					// --------------------										
					// display coefficients
					
//					System.out.println( "Coef length: " +coefficients.length );
					for ( int i = 0 ; i < coefficients.length -1  ; i++ ) // +1 for residual
					{
//						System.out.println("Rebuilding with scale " + i );
						float c[] = coefficients[i];
						
						for ( int a = 0 ; a < cumulatedImage.length ; a++ )
						{
							cumulatedImage[a]+=c[a];
						}
						
						//FIXME mettre le type d'entre au lieu de flaot
//						final IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, DataType.FLOAT ); 						
						//float[] reconstructedImage = new float[image.getWidth()*image.getHeight()];
//						Array1DUtil.arrayToArray( c , imageOut.getDataXY( 0 ), imageOut.isSignedDataType() );
//						imageOut.dataChanged();
//						Sequence sequence = new Sequence( imageOut );
//						addSequence( sequence );
//						sequence.setName( "Scale " + i );
//						
//						if ( i == coefficients.length -1 )
//						{
//							sequence.setName("Residual");
//						}
												
					}
					
					// remove negative values
					
					if ( removeNegativeValue )
					{
						for ( int a = 0 ; a < cumulatedImage.length ; a++ )
						{
							if ( cumulatedImage[a] <0 )
							{
								cumulatedImage[a] = 0 ;
							}
						}
					}
					
					// display cumulated image
					
					{					
						final IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, DataType.FLOAT );
						
						Array1DUtil.arrayToArray( cumulatedImage , imageOut.getDataXY( 0 ), imageOut.isSignedDataType() );
						imageOut.dataChanged();			
						rebuildSequence.setImage( t , 0 , imageOut );
								
					
					}
					
					// --------------------
					
					
					// Icy.addSequence(resultSequence);
//					resultSequence.dataChanged();
					// reconstruct the image from the wavelet coefficients
					
					// final IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, TypeUtil.TYPE_BYTE );
					
					// final IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, DataType.BYTE );					
					
					// inputSequence.getDataType_()
					
//					final IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, DataType.FLOAT );
//					float[] reconstructedImage = new float[image.getWidth()*image.getHeight()];
//
//					//waveletTransform.b3WaveletReconstruction2D(coefficients, coefficients[numScales], binaryDetectionResult, numScales, image.getWidth()*image.getHeight());
//					waveletTransform.b3SpotConstruction2D( coefficients, reconstructedImage, numScales, image.getWidth()*image.getHeight() , UDWTScaleArrayList );
//
//					
//					Array1DUtil.arrayToArray( reconstructedImage , imageOut.getDataXY( 0 ), imageOut.isSignedDataType() );
					
					
//					resultSequence.addImage(t, imageOut);
					
					
					// Binarisation de la reconstruction.
//					{
//						for ( int i = 0 ; i < binaryDetectionResult.length ; i++ )
//						{							
//							if ( binaryDetectionResult[i] != 0 ) // >
//							{
//								binaryDetectionResult[i] = 255;
//							}else
//							{
//								binaryDetectionResult[i] = 0;
//							}				
//						}
//					}
//
//					ArrayUtil.arrayToArray( binaryDetectionResult, imageOut.getDataXY(0), image.isSignedDataType() );

//					Sequence binarySequenceForConnectedComponentExtraction = new Sequence();
//					binarySequenceForConnectedComponentExtraction.setImage(0, 0, imageOut);
//					addConnectedComponentDetection( binarySequenceForConnectedComponentExtraction , detectionList , t , inputSequence );
					
//					if ( computeBinaryDetection )
//					{
//						binarySequence.setImage(t, 0, imageOut);
//					}
					
//					addSequence( resultSequence );
				}
			}
			
			
			
		}
		return rebuildSequence;
		
	}



	
	

}
