package plugins.fab.connectedcomponentpainter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

import plugins.adufour.connectedcomponents.ConnectedComponent;

import icy.canvas.IcyCanvas;
import icy.painter.Painter;
import icy.sequence.Sequence;

public class ConnectedComponentPainter implements Painter {

	ConnectedComponent[] ccArray ;
	Color color;
	
	public ConnectedComponentPainter(ConnectedComponent[] ccArray , Color color ) {

		this.ccArray = ccArray;
		this.color = color;
		
	}

	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {

		if ( ccArray == null ) return;
		if ( g == null ) return; // 2D only
		
		g = (Graphics2D) g.create();
		g.translate( 0.5f , 0.5f );
		
		g.setColor( color );
		int t = canvas.getPositionT();
		
		for ( ConnectedComponent cc : ccArray )
		{
			if ( cc == null )
			{
				System.err.println("connected component warning: one of the cc is null.");
				continue;
			}
			if ( t != cc.getT() ) continue;
				
			Ellipse2D ellipse2d = new Ellipse2D.Double(
					cc.getMassCenter().x-3,
					cc.getMassCenter().y-3,
					6,6
					);
			g.draw( ellipse2d );
		}
		
		
	}

	@Override
	public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}
	
	

}
