/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import mcib3d.Jama.EigenvalueDecomposition;
import mcib3d.Jama.Matrix;
import mcib3d.geom.MereoObject3D;
import mcib3d.geom.Object3DLabel;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.processing.BinaryMorpho;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.KDTreeC;

public abstract class Object3D {
    protected String name = "";
    protected int type = 0;
    protected String comment = "";
    protected int xmin;
    protected int ymin;
    protected int zmin;
    protected int xmax;
    protected int ymax;
    protected int zmax;
    protected double bx = Double.NaN;
    protected double by = Double.NaN;
    protected double bz = Double.NaN;
    protected double cx = Double.NaN;
    protected double cy = Double.NaN;
    protected double cz = Double.NaN;
    protected double areaNbVoxels = -1.0;
    protected double areaContactUnit = -1.0;
    protected double areaContactVoxels = -1.0;
    protected int volume = -1;
    protected double feret = Double.NaN;
    protected Voxel3D feret1 = null;
    protected Voxel3D feret2 = null;
    double distcentermin = Double.NaN;
    double distcentermax = Double.NaN;
    double distcentermean = Double.NaN;
    double distcentersigma = Double.NaN;
    protected double integratedDensity = Double.NaN;
    protected double sigma = Double.NaN;
    protected double pixmin = Double.NaN;
    protected double pixmax = Double.NaN;
    protected int value;
    protected ArrayList<Voxel3D> contours = null;
    protected KDTreeC kdtreeContours;
    protected boolean touchBorders;
    public double s200 = Double.NaN;
    protected double s110;
    protected double s101;
    protected double s020;
    protected double s011;
    protected double s002;
    protected double s300 = Double.NaN;
    protected double s210;
    protected double s201;
    protected double s030;
    protected double s120;
    protected double s021;
    protected double s003;
    protected double s102;
    protected double s012;
    protected double s111;
    protected double s400 = Double.NaN;
    protected double s040;
    protected double s004;
    protected double s220;
    protected double s202;
    protected double s022;
    protected double s121;
    protected double s112;
    protected double s211;
    protected double s103;
    protected double s301;
    protected double s130;
    protected double s310;
    protected double s013;
    protected double s031;
    protected EigenvalueDecomposition eigen = null;
    protected ImageInt miniLabelImage = null;
    protected ImageInt labelImage = null;
    protected ImageHandler currentQuantifImage = null;
    protected double resXY = 1.0;
    protected double resZ = 1.0;
    protected String units = "pixels";
    public boolean verbose = false;
    public boolean multiThread = false;
    public static final byte MEASURE_NONE = 0;
    public static final byte MEASURE_VOLUME_PIX = 1;
    public static final byte MEASURE_VOLUME_UNIT = 2;
    public static final byte MEASURE_MAIN_ELONGATION = 3;
    public static final byte MEASURE_COMPACTNESS_VOXELS = 4;
    public static final byte MEASURE_COMPACTNESS_UNITS = 12;
    public static final byte MEASURE_SPHERICITY = 5;
    public static final byte MEASURE_AREA_PIX = 6;
    public static final byte MEASURE_AREA_UNIT = 7;
    public static final byte MEASURE_DC_AVG = 8;
    public static final byte MEASURE_DC_SD = 9;
    public static final byte MEASURE_INTENSITY_AVG = 10;
    public static final byte MEASURE_INTENSITY_SD = 11;

    public void setResXY(double d) {
        this.resXY = d;
    }

    public void setResZ(double d) {
        this.resZ = d;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public double getResXY() {
        return this.resXY;
    }

    public double getResZ() {
        return this.resZ;
    }

    public String getUnits() {
        return this.units;
    }

    public Calibration getCalibration() {
        Calibration calibration = new Calibration();
        calibration.pixelWidth = this.resXY;
        calibration.pixelHeight = this.resXY;
        calibration.pixelDepth = this.resZ;
        calibration.setUnit(this.units);
        return calibration;
    }

    public void setCalibration(Calibration calibration) {
        this.resXY = calibration.pixelWidth;
        this.resZ = calibration.pixelDepth;
        this.units = calibration.getUnits();
    }

    public final void setCalibration(double d, double d2, String string) {
        this.resXY = d;
        this.resZ = d2;
        this.units = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public ImageInt getLabelImage() {
        if (this.labelImage == null) {
            this.labelImage = this.createSegImage();
        }
        return this.labelImage;
    }

    public void setLabelImage(ImageInt imageInt) {
        this.labelImage = imageInt;
    }

    public int getVolumePixels() {
        if (this.volume == -1) {
            this.computeVolume();
        }
        return this.volume;
    }

    public double getMeasure(int n) {
        if (n == 1) {
            return this.getVolumePixels();
        }
        if (n == 2) {
            return this.getVolumeUnit();
        }
        if (n == 6) {
            return this.getAreaPixels();
        }
        if (n == 7) {
            return this.getAreaUnit();
        }
        if (n == 3) {
            return this.getMainElongation();
        }
        if (n == 4) {
            return this.getCompactness(false);
        }
        if (n == 12) {
            return this.getCompactness(true);
        }
        if (n == 8) {
            return this.getDistCenterMean();
        }
        if (n == 9) {
            return this.getDistCenterSigma();
        }
        if (n == 10) {
            if (this.currentQuantifImage != null) {
                return this.getMeanPixValue(this.currentQuantifImage);
            }
            return 0.0;
        }
        if (n == 11) {
            if (this.currentQuantifImage != null) {
                return this.getStDevPixValue(this.currentQuantifImage);
            }
            return 0.0;
        }
        return Double.NaN;
    }

    private void computeVolume() {
        this.volume = this.getVoxels().size();
    }

    public double getVolumeUnit() {
        return (double)this.getVolumePixels() * this.resXY * this.resXY * this.resZ;
    }

    protected abstract void computeCenter();

    protected abstract void computeMassCenter(ImageHandler var1);

    public float[] getArrayValues(ImageHandler imageHandler) {
        ArrayList<Voxel3D> arrayList = this.getVoxels();
        float[] fArray = new float[arrayList.size()];
        int n = 0;
        for (Voxel3D voxel3D : arrayList) {
            int n2;
            int n3;
            int n4 = voxel3D.getRoundX();
            if (!imageHandler.contains(n4, n3 = voxel3D.getRoundY(), n2 = voxel3D.getRoundZ())) continue;
            fArray[n++] = imageHandler.getPixel(n4, n3, n2);
        }
        return fArray;
    }

    public double getQuantilePixValue(ImageHandler imageHandler, double d) {
        if (d == 1.0) {
            return this.getPixMaxValue(imageHandler);
        }
        if (d == 0.0) {
            return this.getPixMinValue(imageHandler);
        }
        float[] fArray = this.getArrayValues(imageHandler);
        if (fArray.length == 0) {
            return Double.NaN;
        }
        Arrays.sort(fArray);
        double d2 = d * (double)fArray.length;
        if (d2 <= 0.0) {
            return fArray[0];
        }
        if (d2 >= (double)(fArray.length - 1)) {
            return fArray[fArray.length - 1];
        }
        double d3 = d2 - (double)((int)d2);
        if (d3 == 0.0) {
            return fArray[(int)d2];
        }
        double d4 = fArray[(int)d2];
        double d5 = fArray[(int)(d2 + 1.0)];
        return d3 * d5 + (1.0 - d3) * d4;
    }

    protected abstract void computeBounding();

    public abstract void computeContours();

    protected abstract void computeMoments2(boolean var1);

    protected abstract void computeMoments3();

    protected abstract void computeMoments4();

    public double[] getMomentsRaw2() {
        if (Double.isNaN(this.s200)) {
            this.computeMoments2(false);
        }
        return new double[]{this.s200, this.s020, this.s002, this.s110, this.s101, this.s011};
    }

    public double[] getMomentsRaw3() {
        if (Double.isNaN(this.s300)) {
            this.computeMoments3();
        }
        return new double[]{this.s300, this.s030, this.s003, this.s210, this.s201, this.s120, this.s021, this.s102, this.s012, this.s111};
    }

    public double[] getMomentsRaw4() {
        if (Double.isNaN(this.s400)) {
            this.computeMoments4();
        }
        return new double[]{this.s400, this.s040, this.s004, this.s220, this.s202, this.s022, this.s121, this.s112, this.s211, this.s103, this.s301, this.s130, this.s310, this.s013, this.s031};
    }

    public double[] getGeometricInvariants() {
        if (Double.isNaN(this.s200)) {
            this.computeMoments2(false);
        }
        if (Double.isNaN(this.s300)) {
            this.computeMoments3();
        }
        if (Double.isNaN(this.s400)) {
            this.computeMoments4();
        }
        double[] dArray = new double[6];
        double d = this.getVolumeUnit();
        dArray[0] = (this.s400 + this.s040 + this.s004 + 2.0 * this.s220 + 2.0 * this.s202 + 2.0 * this.s022) / Math.pow(d, 2.3333333333333335);
        dArray[1] = (this.s400 * this.s040 + this.s400 * this.s004 + this.s004 * this.s040 + 3.0 * this.s220 * this.s220 + 3.0 * this.s202 * this.s202 + 3.0 * this.s022 * this.s022 - 4.0 * this.s103 * this.s301 - 4.0 * this.s130 * this.s310 - 4.0 * this.s013 * this.s031 + 2.0 * this.s022 * this.s202 + 2.0 * this.s022 * this.s220 + 2.0 * this.s220 * this.s202 + 2.0 * this.s022 * this.s400 + 2.0 * this.s004 * this.s220 + 2.0 * this.s040 * this.s202 - 4.0 * this.s103 * this.s121 - 4.0 * this.s130 * this.s112 - 4.0 * this.s013 * this.s211 - 4.0 * this.s121 * this.s301 - 4.0 * this.s112 * this.s310 - 4.0 * this.s211 * this.s031 + 4.0 * this.s211 * this.s211 + 4.0 * this.s112 * this.s112 + 4.0 * this.s121 * this.s121) / Math.pow(d, 4.666666666666667);
        dArray[2] = (this.s400 * this.s400 + this.s040 * this.s040 + this.s004 * this.s004 + 4.0 * this.s130 * this.s130 + 4.0 * this.s103 * this.s103 + 4.0 * this.s013 * this.s013 + 4.0 * this.s031 * this.s031 + 4.0 * this.s310 * this.s310 + 4.0 * this.s301 * this.s301 + 6.0 * this.s220 * this.s220 + 6.0 * this.s202 * this.s202 + 6.0 * this.s022 * this.s022 + 12.0 * this.s112 * this.s112 + 12.0 * this.s121 * this.s121 + 12.0 * this.s211 * this.s211) / Math.pow(d, 4.666666666666667);
        dArray[3] = (this.s300 * this.s300 + this.s030 * this.s030 + this.s003 * this.s003 + 3.0 * (this.s210 * this.s210 + this.s201 * this.s201 + this.s120 * this.s120 + this.s021 * this.s021 + this.s102 * this.s102 + this.s012 * this.s012) + 6.0 * this.s111) / Math.pow(d, 4.0);
        dArray[4] = (this.s300 * this.s300 + this.s030 * this.s030 + this.s003 * this.s003 + this.s210 * this.s210 + this.s201 * this.s201 + this.s120 * this.s120 + this.s021 * this.s021 + this.s102 * this.s102 + this.s012 * this.s012 + 2.0 * (this.s300 * this.s120 + this.s300 * this.s102 + this.s030 * this.s210 + this.s030 * this.s012 + this.s003 * this.s201 + this.s003 * this.s021 + this.s120 * this.s102 + this.s021 * this.s201 + this.s012 * this.s210)) / Math.pow(d, 4.0);
        dArray[5] = (this.s200 * (this.s400 + this.s220 + this.s202) + this.s020 * (this.s220 + this.s040 + this.s022) + this.s002 * (this.s202 + this.s022 + this.s004) + 2.0 * this.s110 * (this.s310 + this.s130 + this.s112) + 2.0 * this.s101 * (this.s301 * this.s121 + this.s103) + 2.0 * this.s011 * (this.s211 + this.s031 + this.s013)) / Math.pow(d, 4.0);
        return dArray;
    }

    public double[] getHomogeneousInvariants() {
        if (Double.isNaN(this.s200)) {
            this.computeMoments2(false);
        }
        if (Double.isNaN(this.s300)) {
            this.computeMoments3();
        }
        if (Double.isNaN(this.s400)) {
            this.computeMoments4();
        }
        double[] dArray = new double[5];
        double d = this.getVolumeUnit();
        dArray[0] = (this.s200 + this.s020 + this.s002) / (d * d);
        dArray[1] = (this.s200 * this.s200 + this.s020 * this.s020 + this.s002 * this.s002 + 2.0 * this.s101 * this.s101 + 2.0 * this.s110 * this.s110 + 2.0 * this.s011 * this.s011) / (d * d * d * d);
        dArray[2] = (this.s200 * this.s200 * this.s200 + 3.0 * this.s200 * this.s110 * this.s110 + 3.0 * this.s200 * this.s101 * this.s101 + 3.0 * this.s110 * this.s110 * this.s020 + 3.0 * this.s101 * this.s101 * this.s020 + this.s020 * this.s020 * this.s020 + 3.0 * this.s020 * this.s011 * this.s011 + 3.0 * this.s011 * this.s011 * this.s002 + this.s002 * this.s002 * this.s002 + 6.0 * this.s110 * this.s101 * this.s011) / Math.pow(d, 6.0);
        dArray[3] = (this.s300 * this.s300 + this.s030 * this.s030 + this.s003 * this.s003 + 3.0 * this.s210 * this.s201 + 3.0 * this.s201 * this.s201 + 3.0 * this.s120 * this.s120 + 3.0 * this.s102 * this.s102 + 3.0 * this.s021 * this.s021 + 3.0 * this.s012 * this.s012 + 6.0 * this.s111 * this.s111) / Math.pow(d, 5.0);
        dArray[4] = (this.s300 * this.s300 + 2.0 * this.s300 * this.s120 + 2.0 * this.s300 * this.s102 + 2.0 * this.s210 * this.s030 + 2.0 * this.s201 * this.s003 + this.s030 * this.s030 + 2.0 * this.s030 * this.s012 + 2.0 * this.s021 * this.s003 + this.s003 * this.s003 + this.s210 * this.s210 + 2.0 * this.s210 * this.s012 + this.s201 * this.s201 + 2.0 * this.s201 * this.s021 + this.s120 * this.s120 + 2.0 * this.s120 + this.s102 + this.s102 * this.s102 + this.s021 * this.s021 + this.s012 + this.s012) / Math.pow(d, 5.0);
        return dArray;
    }

    public double[] getMoments3D() {
        this.computeMoments2(false);
        double d = this.getVolumeUnit();
        double d2 = Math.pow(d, 1.0);
        this.s200 /= d2;
        this.s020 /= d2;
        this.s002 /= d2;
        this.s011 /= d2;
        this.s101 /= d2;
        this.s110 /= d2;
        double d3 = this.s200 + this.s020 + this.s002;
        double d4 = this.s020 * this.s002 - this.s011 * this.s011 + this.s200 * this.s002 - this.s101 * this.s101 + this.s200 * this.s020 - this.s110 * this.s110;
        double d5 = this.s200 * this.s020 * this.s002 + 2.0 * this.s110 * this.s101 * this.s011 - this.s002 * this.s110 * this.s110 - this.s020 * this.s101 * this.s101 - this.s200 * this.s011 * this.s011;
        double d6 = d3 * d3 / d4;
        double d7 = d5 / (d3 * d3 * d3);
        return new double[]{d3, d4, d5, d6, d7};
    }

    public abstract Voxel3D getPixelMax(ImageHandler var1);

    public ArrayList<Voxel3D> listVoxels(ImageHandler imageHandler) {
        return this.listVoxels(imageHandler, Double.NEGATIVE_INFINITY);
    }

    public abstract ArrayUtil listValues(ImageHandler var1);

    public abstract ArrayList<Voxel3D> listVoxels(ImageHandler var1, double var2);

    public Object3DVoxels getObject3DVoxels() {
        if (this instanceof Object3DVoxels) {
            return (Object3DVoxels)this;
        }
        if (this instanceof Object3DLabel) {
            return ((Object3DLabel)this).buildObject3DVoxels();
        }
        return null;
    }

    public double pcColoc(Object3D object3D) {
        if (this.disjointBox(object3D)) {
            return 0.0;
        }
        int n = this.getColoc(object3D);
        if (n == 0) {
            return 0.0;
        }
        return 100.0 * (double)n / (double)this.getVolumePixels();
    }

    public abstract void draw(ByteProcessor var1, int var2, int var3);

    public abstract void draw(ImageStack var1, int var2);

    public abstract void draw(ImageHandler var1, int var2);

    public void draw(ImageHandler imageHandler) {
        this.draw(imageHandler, this.getValue());
    }

    public abstract void draw(ImageStack var1, int var2, int var3, int var4);

    public abstract Roi createRoi(int var1);

    public void init() {
        this.cx = Double.NaN;
        this.cy = Double.NaN;
        this.cz = Double.NaN;
        this.bx = Double.NaN;
        this.by = Double.NaN;
        this.bz = Double.NaN;
        this.s200 = Double.NaN;
        this.s110 = Double.NaN;
        this.s101 = Double.NaN;
        this.s020 = Double.NaN;
        this.s011 = Double.NaN;
        this.s002 = Double.NaN;
        this.eigen = null;
        this.distcentermin = Double.NaN;
        this.distcentermax = Double.NaN;
        this.distcentermean = Double.NaN;
        this.distcentersigma = Double.NaN;
        this.feret = Double.NaN;
        this.feret1 = null;
        this.feret2 = null;
        this.integratedDensity = Double.NaN;
        this.pixmax = Double.NaN;
        this.pixmin = Double.NaN;
        this.sigma = Double.NaN;
        this.volume = -1;
        this.areaNbVoxels = -1.0;
        this.areaContactUnit = -1.0;
        this.miniLabelImage = null;
        this.computeBounding();
        this.computeCenter();
    }

    public ArrayList<Voxel3D> getContours() {
        if (this.contours == null) {
            this.computeContours();
        }
        return this.contours;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getXmin() {
        return this.xmin;
    }

    public int getYmin() {
        return this.ymin;
    }

    public int getZmin() {
        return this.zmin;
    }

    public int getXmax() {
        return this.xmax;
    }

    public int getYmax() {
        return this.ymax;
    }

    public int getZmax() {
        return this.zmax;
    }

    public int[] getBoundingBox() {
        return new int[]{this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax};
    }

    public double getCenterX() {
        Vector3D vector3D = this.getCenterAsVector();
        return vector3D.getX();
    }

    public double getCenterY() {
        Vector3D vector3D = this.getCenterAsVector();
        return vector3D.getY();
    }

    public double getCenterZ() {
        Vector3D vector3D = this.getCenterAsVector();
        return vector3D.getZ();
    }

    public boolean isEmpty() {
        return this.getVolumePixels() == 0;
    }

    public double getIntegratedDensity(ImageHandler imageHandler) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != imageHandler) {
            this.computeMassCenter(imageHandler);
            this.currentQuantifImage = imageHandler;
        }
        return this.integratedDensity;
    }

    public double getMassCenterX(ImageHandler imageHandler) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != imageHandler) {
            this.computeMassCenter(imageHandler);
            this.currentQuantifImage = imageHandler;
        }
        return this.cx;
    }

    public void setNewCenter(double d, double d2, double d3) {
        this.translate(d - this.getCenterX(), d2 - this.getCenterY(), d3 - this.getCenterZ());
    }

    public abstract void translate(double var1, double var3, double var5);

    public void translate(Vector3D vector3D) {
        this.translate(vector3D.getX(), vector3D.getY(), vector3D.getZ());
    }

    public double getMassCenterY(ImageHandler imageHandler) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != imageHandler) {
            this.computeMassCenter(imageHandler);
            this.currentQuantifImage = imageHandler;
        }
        return this.cy;
    }

    public double getMassCenterZ(ImageHandler imageHandler) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != imageHandler) {
            this.computeMassCenter(imageHandler);
            this.currentQuantifImage = imageHandler;
        }
        return this.cz;
    }

    public Vector3D getCenterAsVector() {
        if (Double.isNaN(this.bx)) {
            this.computeCenter();
        }
        return new Vector3D(this.bx, this.by, this.bz);
    }

    public Vector3D getCenterAsVectorUnit() {
        if (Double.isNaN(this.bx)) {
            this.computeCenter();
        }
        return new Vector3D(this.bx * this.resXY, this.by * this.resXY, this.bz * this.resZ);
    }

    public Point3D getCenterAsPoint() {
        if (Double.isNaN(this.bx)) {
            this.computeCenter();
        }
        return new Point3D(this.bx, this.by, this.bz);
    }

    public double[] getCenterAsArray() {
        if (Double.isNaN(this.bx)) {
            this.computeCenter();
        }
        return this.getCenterAsPoint().getArray();
    }

    public double getAreaPixels() {
        if (this.areaNbVoxels == -1.0) {
            this.computeContours();
        }
        return this.areaContactVoxels;
    }

    public double getAreaUnit() {
        if (this.areaContactUnit == -1.0) {
            this.computeContours();
        }
        return this.areaContactUnit;
    }

    public double getCompactness(boolean bl) {
        if (bl) {
            double d = Math.pow(this.getAreaUnit(), 3.0);
            double d2 = Math.pow(this.getVolumeUnit(), 2.0);
            return d2 * 36.0 * Math.PI / d;
        }
        double d = Math.pow(this.getAreaPixels(), 3.0);
        double d3 = Math.pow(this.getVolumePixels(), 2.0);
        return d3 * 36.0 * Math.PI / d;
    }

    public double getCompactness() {
        return this.getCompactness(false);
    }

    public double getSphericity() {
        return this.getSphericity(false);
    }

    public double getSphericity(boolean bl) {
        return Math.pow(this.getCompactness(bl), 0.333333);
    }

    public double getRatioBox() {
        double d = this.getVolumePixels();
        double d2 = this.getVolumeBoundingBoxPixel();
        return d / d2;
    }

    public double getRatioEllipsoid() {
        double d = this.getVolumeUnit();
        double d2 = this.getVolumeEllipseUnit();
        return d / d2;
    }

    public double getVolumeBoundingBoxPixel() {
        return (this.zmax - this.zmin + 1) * (this.xmax - this.xmin + 1) * (this.ymax - this.ymin + 1);
    }

    public double getVolumeBoundingBoxOrientedPixel() {
        ArrayList<Voxel3D> arrayList = this.getBoundingOriented();
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        for (Voxel3D voxel3D : arrayList) {
            double d7 = voxel3D.getX();
            double d8 = voxel3D.getY();
            double d9 = voxel3D.getZ();
            if (d7 > d2) {
                d2 = d7;
            }
            if (d7 < d) {
                d = d7;
            }
            if (d8 > d4) {
                d4 = d8;
            }
            if (d8 < d3) {
                d3 = d8;
            }
            if (d9 > d6) {
                d6 = d9;
            }
            if (!(d9 < d5)) continue;
            d5 = d9;
        }
        Object object = new double[]{d, d2, d3, d4, d5, d6};
        return (double)((object[1] - object[0] + 1.0) * (object[3] - object[2] + 1.0) * (object[5] - object[4] + 1.0));
    }

    public ArrayList<Voxel3D> getBoundingOriented() {
        Vector3D vector3D = this.getVectorAxis(2);
        vector3D.normalize();
        Vector3D vector3D2 = this.getVectorAxis(1);
        vector3D2.normalize();
        Vector3D vector3D3 = this.getVectorAxis(0);
        vector3D3.normalize();
        double d = vector3D.getX();
        double d2 = vector3D.getY();
        double d3 = vector3D.getZ();
        double d4 = vector3D2.getX();
        double d5 = vector3D2.getY();
        double d6 = vector3D2.getZ();
        double d7 = vector3D3.getX();
        double d8 = vector3D3.getY();
        double d9 = vector3D3.getZ();
        double[] dArray = this.getCenterAsArray();
        double d10 = dArray[0];
        double d11 = dArray[1];
        double d12 = dArray[2];
        ArrayList<Voxel3D> arrayList = this.getContours();
        ArrayList<Voxel3D> arrayList2 = new ArrayList<Voxel3D>();
        for (Voxel3D voxel3D : arrayList) {
            double d13 = d * (voxel3D.getX() - d10) + d4 * (voxel3D.getY() - d11) + d7 * (voxel3D.getZ() - d12) + d10;
            double d14 = d2 * (voxel3D.getX() - d10) + d5 * (voxel3D.getY() - d11) + d8 * (voxel3D.getZ() - d12) + d11;
            double d15 = d3 * (voxel3D.getX() - d10) + d6 * (voxel3D.getY() - d11) + d9 * (voxel3D.getZ() - d12) + d12;
            arrayList2.add(new Voxel3D(d13, d14, d15, (double)this.getValue()));
        }
        return arrayList2;
    }

    public double getVolumeEllipseUnit() {
        double d = this.getRadiusMoments(2);
        double d2 = d / this.getMainElongation();
        double d3 = d2 / this.getMedianElongation();
        return 4.18879 * d * d2 * d3;
    }

    protected void computeEigen() {
        if (this.eigen == null) {
            Matrix matrix = new Matrix(3, 3);
            if (Double.isNaN(this.s200)) {
                this.computeMoments2(true);
            }
            matrix.set(0, 0, this.s200);
            matrix.set(0, 1, this.s110);
            matrix.set(0, 2, this.s101);
            matrix.set(1, 0, this.s110);
            matrix.set(1, 1, this.s020);
            matrix.set(1, 2, this.s011);
            matrix.set(2, 0, this.s101);
            matrix.set(2, 1, this.s011);
            matrix.set(2, 2, this.s002);
            this.eigen = new EigenvalueDecomposition(matrix);
        }
    }

    public Matrix getMatrixAxes() {
        this.computeEigen();
        Matrix matrix = this.eigen.getV().copy();
        double d = matrix.get(0, 2);
        matrix.set(0, 2, matrix.get(0, 0));
        matrix.set(0, 0, d);
        d = matrix.get(1, 2);
        matrix.set(1, 2, matrix.get(1, 0));
        matrix.set(1, 0, d);
        d = matrix.get(2, 2);
        matrix.set(2, 2, matrix.get(2, 0));
        matrix.set(2, 0, d);
        return matrix;
    }

    public double getValueAxis(int n) {
        this.computeEigen();
        double[] dArray = this.eigen.getRealEigenvalues();
        return dArray[n];
    }

    public Vector3D getMainAxis() {
        return this.getVectorAxis(2);
    }

    public Vector3D getVectorAxis(int n) {
        this.computeEigen();
        Matrix matrix = this.eigen.getV();
        Vector3D vector3D = new Vector3D(matrix.get(0, n), matrix.get(1, n), matrix.get(2, n));
        return vector3D;
    }

    public double getRadiusMoments(int n) {
        return Math.sqrt(5.0 * this.getValueAxis(n));
    }

    public double getMainElongation() {
        if (this.getValueAxis(1) != 0.0) {
            return Math.sqrt(this.getValueAxis(2) / this.getValueAxis(1));
        }
        return Double.NaN;
    }

    public double getMedianElongation() {
        if (this.getValueAxis(0) != 0.0) {
            return Math.sqrt(this.getValueAxis(1) / this.getValueAxis(0));
        }
        return Double.NaN;
    }

    public void computeContours(ImageHandler imageHandler) {
        this.areaNbVoxels = 0.0;
        this.contours = new ArrayList();
        for (int i = this.zmin; i <= this.zmax; ++i) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int k = this.xmin; k <= this.xmax; ++k) {
                    if (imageHandler.getPixel(k, j, i) != (float)this.value) continue;
                    this.areaNbVoxels += 1.0;
                    Voxel3D voxel3D = new Voxel3D(k, j, i, this.value);
                    this.contours.add(voxel3D);
                }
            }
        }
    }

    public double getDistCenterMin() {
        if (Double.isNaN(this.distcentermin)) {
            this.computeDistCenter();
        }
        return this.distcentermin;
    }

    public double getDistCenterMax() {
        if (Double.isNaN(this.distcentermax)) {
            this.computeDistCenter();
        }
        return this.distcentermax;
    }

    public double getDistCenterMean() {
        if (Double.isNaN(this.distcentermean)) {
            this.computeDistCenter();
        }
        return this.distcentermean;
    }

    public double getDistCenterSigma() {
        if (Double.isNaN(this.distcentersigma)) {
            this.computeDistCenter();
        }
        return this.distcentersigma;
    }

    public boolean centerInside() {
        Point3D point3D = this.getCenterAsPoint();
        return this.inside(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    private void computeDistCenter() {
        if (this.centerInside()) {
            double d = 0.0;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = this.resXY * this.resXY;
            double d6 = this.resZ * this.resZ;
            Vector3D vector3D = this.getCenterAsVector();
            Voxel3D voxel3D = new Voxel3D(vector3D.getX(), vector3D.getY(), vector3D.getZ(), 0.0);
            double d7 = voxel3D.getX();
            double d8 = voxel3D.getY();
            double d9 = voxel3D.getZ();
            ArrayList<Voxel3D> arrayList = this.getContours();
            int n = this.getContours().size();
            double d10 = n;
            for (int i = 0; i < n; ++i) {
                Voxel3D voxel3D2 = arrayList.get(i);
                double d11 = d5 * ((d7 - voxel3D2.getX()) * (d7 - voxel3D2.getX()) + (d8 - voxel3D2.getY()) * (d8 - voxel3D2.getY())) + d6 * (d9 - voxel3D2.getZ()) * (d9 - voxel3D2.getZ());
                d3 += Math.sqrt(d11);
                d4 += d11;
                if (d11 > d) {
                    d = d11;
                }
                if (!(d11 < d2)) continue;
                d2 = d11;
            }
            this.distcentermax = Math.sqrt(d);
            this.distcentermin = Math.sqrt(d2);
            this.distcentermean = d3 / d10;
            this.distcentersigma = Math.sqrt((d4 - d3 * d3 / d10) / (d10 - 1.0));
        }
    }

    private void computeFeret() {
        double d = 0.0;
        double d2 = this.resXY * this.resXY;
        double d3 = this.resZ * this.resZ;
        ArrayList<Voxel3D> arrayList = this.getContours();
        int n = this.getContours().size();
        for (int i = 0; i < n; ++i) {
            Voxel3D voxel3D = arrayList.get(i);
            for (int j = i + 1; j < n; ++j) {
                Voxel3D voxel3D2 = arrayList.get(j);
                double d4 = d2 * ((voxel3D.getX() - voxel3D2.getX()) * (voxel3D.getX() - voxel3D2.getX()) + (voxel3D.getY() - voxel3D2.getY()) * (voxel3D.getY() - voxel3D2.getY())) + d3 * (voxel3D.getZ() - voxel3D2.getZ()) * (voxel3D.getZ() - voxel3D2.getZ());
                if (!(d4 > d)) continue;
                d = d4;
                this.feret1 = voxel3D;
                this.feret2 = voxel3D2;
            }
        }
        this.feret = (float)Math.sqrt(d);
    }

    public double getFeret() {
        if (Double.isNaN(this.feret)) {
            this.computeFeret();
        }
        return this.feret;
    }

    public Voxel3D getFeretVoxel1() {
        if (this.feret1 == null) {
            this.computeFeret();
        }
        return this.feret1;
    }

    public Voxel3D getFeretVoxel2() {
        if (this.feret2 == null) {
            this.computeFeret();
        }
        return this.feret2;
    }

    public String toString() {
        return "Object3D : " + this.value + " (" + (int)(this.bx + 0.5) + "," + (int)(this.by + 0.5) + "," + (int)(this.bz + 0.5) + ")";
    }

    public double distBorderUnit(Object3D object3D) {
        return this.vectorBorderBorder(object3D).getLength(this.resXY, this.resZ);
    }

    public double distBorderPixel(Object3D object3D) {
        return this.vectorBorderBorder(object3D).getLength(1.0, 1.0);
    }

    public double distBorderUnit(Point3D point3D, Object3D object3D, Point3D point3D2, boolean bl) {
        Vector3D vector3D = this.vectorBorderBorder(point3D, object3D, point3D2, bl);
        if (vector3D != null) {
            return vector3D.getLength(this.resXY, this.resZ);
        }
        return Double.NaN;
    }

    public double distCenterUnit(Object3D object3D) {
        double d = Math.sqrt((this.bx - object3D.bx) * (this.bx - object3D.bx) * this.resXY * this.resXY + (this.by - object3D.by) * (this.by - object3D.by) * this.resXY * this.resXY + (this.bz - object3D.bz) * (this.bz - object3D.bz) * this.resZ * this.resZ);
        return d;
    }

    public double distCenter2DUnit(Object3D object3D) {
        double d = Math.sqrt((this.bx - object3D.bx) * (this.bx - object3D.bx) * this.resXY * this.resXY + (this.by - object3D.by) * (this.by - object3D.by) * this.resXY * this.resXY);
        return d;
    }

    public double distCenterBorderUnit(Object3D object3D) {
        return this.vectorCenterBorder(object3D).getLength(this.resXY, this.resZ);
    }

    public double distPixelBorder(Point3D point3D) {
        return this.vectorPixelBorder(point3D.getX(), point3D.getY(), point3D.getZ()).getLength(this.resXY, this.resZ);
    }

    public double distPixelBorderUnit(double d, double d2, double d3) {
        return this.vectorPixelBorder(d, d2, d3).getLength(this.resXY, this.resZ);
    }

    public double distPixelBorderUnit(double d, double d2, double d3, Vector3D vector3D) {
        Vector3D vector3D2 = this.vectorPixelBorder(d, d2, d3, vector3D);
        if (vector3D2 != null) {
            return vector3D2.getLength(this.resXY, this.resZ);
        }
        return Double.NaN;
    }

    public double distPixelCenter(double d, double d2, double d3) {
        return Math.sqrt((this.bx - d) * (this.bx - d) * this.resXY * this.resXY + (this.by - d2) * (this.by - d2) * this.resXY * this.resXY + (this.bz - d3) * (this.bz - d3) * this.resZ * this.resZ);
    }

    public Vector3D getCenterUnit() {
        Vector3D vector3D = this.getCenterAsVector();
        return new Vector3D(vector3D.getX() * this.resXY, vector3D.getY() * this.resXY, vector3D.getZ() * this.resZ);
    }

    public boolean getTouchBorders() {
        return this.touchBorders;
    }

    public boolean isContour(Voxel3D voxel3D) {
        if (this.contours == null) {
            this.computeContours();
        }
        for (Voxel3D voxel3D2 : this.contours) {
            if (!(voxel3D2.distBlock(voxel3D) < 0.001)) continue;
            return true;
        }
        return false;
    }

    public boolean insideBounding(double d, double d2, double d3) {
        return d >= (double)this.xmin && d <= (double)this.xmax && d2 >= (double)this.ymin && d2 <= (double)this.ymax && d3 >= (double)this.zmin && d3 <= (double)this.zmax;
    }

    public boolean insideBounding(float f, float f2, float f3) {
        return f >= (float)this.xmin && f <= (float)this.xmax && f2 >= (float)this.ymin && f2 <= (float)this.ymax && f3 >= (float)this.zmin && f3 <= (float)this.zmax;
    }

    public boolean insideBounding(double d, double d2, double d3, int n, int n2, int n3) {
        return d >= (double)(this.xmin - n) && d <= (double)(this.xmax + n) && d2 >= (double)(this.ymin - n2) && d2 <= (double)(this.ymax + n2) && d3 >= (double)(this.zmin - n3) && d3 <= (double)(this.zmax + n3);
    }

    public boolean inside(Point3D point3D) {
        return this.inside(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public synchronized boolean inside(double d, double d2, double d3) {
        if (!this.insideBounding(d, d2, d3, 1, 1, 1)) {
            return false;
        }
        int n = this.value;
        if (this.labelImage != null) {
            int n2 = (int)Math.round(d);
            int n3 = (int)Math.round(d2);
            int n4 = (int)Math.round(d3);
            if (n2 < 0 || n3 < 0 || n4 < 0 || n2 >= this.labelImage.sizeX || n3 >= this.labelImage.sizeY || n4 >= this.labelImage.sizeZ) {
                return false;
            }
            return this.labelImage.getPixel(n2, n3, n4) == (float)n;
        }
        if (this.miniLabelImage == null) {
            this.miniLabelImage = this.createSegImageMini(n, 1);
        } else if (this.miniLabelImage.sizeZ < this.getZmax() - this.getZmin()) {
            System.out.println("Pb size seg image ");
            this.miniLabelImage = this.createSegImageMini(n, 1);
        }
        int n5 = this.miniLabelImage.offsetX;
        int n6 = this.miniLabelImage.offsetY;
        int n7 = this.miniLabelImage.offsetZ;
        int n8 = (int)Math.round(d - (double)n5);
        int n9 = (int)Math.round(d2 - (double)n6);
        int n10 = (int)Math.round(d3 - (double)n7);
        if (n8 < 0 || n9 < 0 || n10 < 0 || n8 >= this.miniLabelImage.sizeX || n9 >= this.miniLabelImage.sizeY || n10 >= this.miniLabelImage.sizeZ) {
            return false;
        }
        return this.miniLabelImage.getPixel(n8, n9, n10) == (float)n;
    }

    public boolean includesBox(Object3D object3D) {
        int n = object3D.getXmin();
        int n2 = object3D.getXmax();
        int n3 = object3D.getYmin();
        int n4 = object3D.getYmax();
        int n5 = object3D.getZmin();
        int n6 = object3D.getZmax();
        return this.insideBounding(n, n3, n5) && this.insideBounding(n, n4, n5) && this.insideBounding(n2, n3, n5) && this.insideBounding(n2, n4, n5) && this.insideBounding(n, n3, n6) && this.insideBounding(n, n4, n6) && this.insideBounding(n2, n3, n6) && this.insideBounding(n2, n4, n6);
    }

    protected int[] getIntersectionBox(Object3D object3D) {
        int[] nArray = new int[]{Math.max(this.getXmin(), object3D.getXmin()), Math.min(this.getXmax(), object3D.getXmax()), Math.max(this.getYmin(), object3D.getYmin()), Math.min(this.getYmax(), object3D.getYmax()), Math.max(this.getZmin(), object3D.getZmin()), Math.min(this.getZmax(), object3D.getZmax())};
        return nArray;
    }

    private boolean includesOneVertexBox(Object3D object3D) {
        int n = object3D.getXmin();
        int n2 = object3D.getXmax();
        int n3 = object3D.getYmin();
        int n4 = object3D.getYmax();
        int n5 = object3D.getZmin();
        int n6 = object3D.getZmax();
        return this.insideBounding(n, n3, n5) || this.insideBounding(n, n4, n5) || this.insideBounding(n2, n3, n5) || this.insideBounding(n2, n4, n5) || this.insideBounding(n, n3, n6) || this.insideBounding(n, n4, n6) || this.insideBounding(n2, n3, n6) || this.insideBounding(n2, n4, n6);
    }

    public boolean intersectionBox(Object3D object3D) {
        return this.includesOneVertexBox(object3D) || object3D.includesOneVertexBox(this);
    }

    public boolean disjointBox(Object3D object3D) {
        return !this.intersectionBox(object3D);
    }

    public ImageInt createIntersectionImage(Object3D object3D, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = Math.min(this.xmin, object3D.xmin) - n3;
        if (n6 < 0) {
            n6 = 0;
        }
        if ((n5 = Math.min(this.ymin, object3D.ymin) - n3) < 0) {
            n5 = 0;
        }
        if ((n4 = Math.min(this.zmin, object3D.zmin) - n3) < 0) {
            n4 = 0;
        }
        int n7 = Math.max(this.xmax, object3D.xmax) + n3;
        int n8 = Math.max(this.ymax, object3D.ymax) + n3;
        int n9 = Math.max(this.zmax, object3D.zmax) + n3;
        ImageInt imageInt = this.createSegImage(n6, n5, n4, n7, n8, n9, n);
        ImageInt imageInt2 = object3D.createSegImage(n6, n5, n4, n7, n8, n9, n2);
        ImageInt imageInt3 = imageInt.addImage(imageInt2);
        imageInt3.offsetX = n6;
        imageInt3.offsetY = n5;
        imageInt3.offsetZ = n4;
        imageInt = null;
        imageInt2 = null;
        System.gc();
        return imageInt3;
    }

    public ImageInt createIntersectionImage(Object3D object3D, int n, int n2) {
        return this.createIntersectionImage(object3D, n, n2, 0);
    }

    public Object3DVoxels getIntersectionObject(Object3D object3D) {
        if (this.disjointBox(object3D)) {
            return null;
        }
        ImageInt imageInt = this.createIntersectionImage(object3D, 1, 2);
        Object3DVoxels object3DVoxels = new Object3DVoxels((ImageHandler)imageInt, 3);
        object3DVoxels.setValue(this.getValue());
        object3DVoxels.translate(imageInt.offsetX, imageInt.offsetY, imageInt.offsetZ);
        return object3DVoxels;
    }

    public int[] surfaceContact(Object3D object3D, double d) {
        int n;
        int n2;
        int n3;
        double d2 = this.distBorderPixel(object3D);
        if (d2 > d) {
            return new int[]{0, 0};
        }
        int n4 = 0;
        int n5 = this.getContours().size();
        ArrayList<Voxel3D> arrayList = object3D.getContours();
        int n6 = arrayList.size();
        double d3 = d * d;
        double[][] dArray = new double[n5][n6];
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                dArray[n3][n2] = -1.0;
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            Voxel3D voxel3D = this.contours.get(n3);
            n = -1;
            if (object3D.inside(voxel3D)) {
                ++n4;
                continue;
            }
            double d4 = d3;
            for (n2 = 0; n2 < n6; ++n2) {
                Voxel3D voxel3D2 = arrayList.get(n2);
                double d5 = voxel3D.distanceSquare(voxel3D2);
                if (!(d5 <= d4)) continue;
                d4 = d5;
                n = n2;
            }
            if (n == -1) continue;
            dArray[n3][n] = d4;
        }
        int n7 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            for (n = 0; n < n5 && dArray[n][n3] == -1.0; ++n) {
            }
            if (n >= n5) continue;
            ++n7;
        }
        return new int[]{n7, n4};
    }

    public int edgeContact(Object3D object3D, int n) {
        HashSet<Voxel3D> hashSet = new HashSet<Voxel3D>();
        for (Voxel3D voxel3D : this.getContours()) {
            for (Voxel3D voxel3D2 : object3D.getContours()) {
                if (!(voxel3D.distanceSquare(voxel3D2) <= (double)n)) continue;
                hashSet.add(voxel3D);
            }
        }
        return hashSet.size();
    }

    public double radiusCenter(Object3D object3D) {
        return this.radiusCenter(object3D, false);
    }

    public double radiusCenter(Object3D object3D, boolean bl) {
        Vector3D vector3D = bl ? new Vector3D(object3D.getCenterAsPoint(), this.getCenterAsPoint()) : new Vector3D(this.getCenterAsPoint(), object3D.getCenterAsPoint());
        if (vector3D.getLength() == 0.0) {
            return 0.0;
        }
        return this.distPixelBorderUnit(this.getCenterX(), this.getCenterY(), this.getCenterZ(), vector3D);
    }

    public double radiusCenter(Vector3D vector3D) {
        Vector3D vector3D2 = this.getCenterAsVector().add(vector3D, -1.0f, 1.0f);
        return this.distPixelBorderUnit(this.getCenterX(), this.getCenterY(), this.getCenterZ(), vector3D2);
    }

    public double radiusPixel(double d, double d2, double d3) {
        Vector3D vector3D = this.getCenterAsVector().add(new Vector3D(d, d2, d3), -1.0f, 1.0f);
        return this.distPixelBorderUnit(this.getCenterX(), this.getCenterY(), this.getCenterZ(), vector3D);
    }

    public Vector3D vectorBorderBorder(Object3D object3D) {
        Voxel3D[] voxel3DArray = this.VoxelsBorderBorder(object3D);
        return new Vector3D(voxel3DArray[0], voxel3DArray[1]);
    }

    public Voxel3D[] VoxelsBorderBorder(Object3D object3D) {
        double d = Double.MAX_VALUE;
        Voxel3D voxel3D = null;
        Voxel3D voxel3D2 = null;
        for (Voxel3D voxel3D3 : object3D.getContours()) {
            double[] dArray = voxel3D3.getArray();
            KDTreeC.Item item = this.getKdtreeContours().getNearestNeighbor(dArray, 1)[0];
            if (!(item.distanceSq < d)) continue;
            voxel3D = voxel3D3;
            voxel3D2 = (Voxel3D)item.obj;
            d = item.distanceSq;
        }
        return new Voxel3D[]{voxel3D2, voxel3D};
    }

    public Vector3D vectorBorderBorder(Point3D point3D, Object3D object3D, Point3D point3D2, boolean bl) {
        Vector3D vector3D = new Vector3D(point3D, point3D2);
        Vector3D vector3D2 = this.vectorPixelBorder(point3D.getX(), point3D.getY(), point3D.getZ(), vector3D);
        if (vector3D2 == null) {
            return null;
        }
        Vector3D vector3D3 = point3D.getVector3D().add(vector3D2);
        if (bl) {
            vector3D = vector3D.multiply(-1.0);
        }
        if ((vector3D2 = object3D.vectorPixelBorder(point3D2.getX(), point3D2.getY(), point3D2.getZ(), vector3D)) == null) {
            return null;
        }
        Vector3D vector3D4 = point3D2.getVector3D().add(vector3D2);
        return new Vector3D(vector3D3, vector3D4);
    }

    public Vector3D vectorCenterBorder(Object3D object3D) {
        Vector3D vector3D = object3D.vectorPixelBorder(this.getCenterAsVector());
        return vector3D;
    }

    public Vector3D vectorPixelBorder(Vector3D vector3D) {
        return this.vectorPixelBorder(vector3D.getX(), vector3D.getY(), vector3D.getZ());
    }

    public Voxel3D getPixelBorder(double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3};
        KDTreeC.Item item = this.getKdtreeContours().getNearestNeighbor(dArray, 1)[0];
        Voxel3D voxel3D = (Voxel3D)item.obj;
        return voxel3D;
    }

    public Vector3D vectorPixelBorder(double d, double d2, double d3) {
        Voxel3D voxel3D = this.getPixelBorder(d, d2, d3);
        return new Vector3D(voxel3D.getX() - d, voxel3D.getY() - d2, voxel3D.getZ() - d3);
    }

    public Vector3D vectorPixelBorder(double d, double d2, double d3, Vector3D vector3D) {
        boolean bl;
        Vector3D vector3D2 = new Vector3D(vector3D);
        vector3D2.normalize();
        float f = (float)vector3D2.getX();
        float f2 = (float)vector3D2.getY();
        float f3 = (float)vector3D2.getZ();
        float f4 = (float)d;
        float f5 = (float)d2;
        float f6 = (float)d3;
        float f7 = 0.5f;
        boolean bl2 = bl = this.inside((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3));
        while (bl2 == bl && this.insideBounding(f4, f5, f6, 1, 1, 1)) {
            bl2 = this.inside(f4 += f7 * f, f5 += f7 * f2, f6 += f7 * f3);
        }
        if (bl2 != bl) {
            return new Vector3D((double)f4 - 0.5 * (double)f7 * (double)f - d, (double)f5 - 0.5 * (double)f7 * (double)f2 - d2, (double)f6 - 0.5 * (double)f7 * (double)f3 - d3);
        }
        return null;
    }

    public Point3D pointPixelBorder(double d, double d2, double d3, Vector3D vector3D) {
        double d4 = Double.MAX_VALUE;
        Vector3D vector3D2 = new Vector3D(vector3D);
        vector3D2.multiply(this.resXY, this.resXY, this.resZ);
        vector3D2.normalize();
        Voxel3D voxel3D = new Voxel3D();
        Vector3D vector3D3 = new Vector3D(d, d2, d3);
        ArrayList<Voxel3D> arrayList = this.getContours();
        for (Voxel3D voxel3D2 : arrayList) {
            Vector3D vector3D4 = new Vector3D(vector3D3, voxel3D2);
            vector3D4.multiply(this.resXY, this.resXY, this.resZ);
            double d5 = 1.0 - vector3D2.colinear(vector3D4);
            if (!(d5 < d4)) continue;
            d4 = d5;
            voxel3D = voxel3D2;
        }
        return new Point3D(voxel3D);
    }

    public Vector3D vectorPixelUnitBorder(Vector3D vector3D) {
        return this.vectorPixelUnitBorder(vector3D.getX(), vector3D.getY(), vector3D.getZ());
    }

    public Vector3D vectorPixelUnitBorder(Vector3D vector3D, Vector3D vector3D2) {
        return this.vectorPixelUnitBorder(vector3D.getX(), vector3D.getY(), vector3D.getZ(), vector3D2);
    }

    public Vector3D vectorPixelUnitBorder(double d, double d2, double d3) {
        return this.vectorPixelBorder(d / this.resXY, d2 / this.resXY, d3 / this.resZ);
    }

    public Vector3D vectorPixelUnitBorder(double d, double d2, double d3, Vector3D vector3D) {
        Vector3D vector3D2 = vector3D.multiply(1.0 / this.resXY, 1.0 / this.resXY, 1.0 / this.resZ);
        return this.vectorPixelBorder(d / this.resXY, d2 / this.resXY, d3 / this.resZ, vector3D2);
    }

    public double angle(Object3D object3D, Object3D object3D2) {
        double d = this.distCenterUnit(object3D);
        double d2 = this.distCenterUnit(object3D2);
        double d3 = object3D.distCenterUnit(object3D2);
        double d4 = (d3 * d3 - d2 * d2 - d * d) / (-2.0 * d2 * d);
        double d5 = Math.toDegrees(Math.acos(d4));
        return d5;
    }

    public double getMeanPixValue(ImageHandler imageHandler) {
        if (this.volume > 0) {
            return this.getIntegratedDensity(imageHandler) / (double)this.getVolumePixels();
        }
        return Double.NaN;
    }

    public double getMeanPixValueAroundBarycenter(boolean bl, ImageInt imageInt, ImageHandler imageHandler, double d, double d2) {
        int n;
        int n2;
        int n3;
        if (bl) {
            this.computeMassCenter(imageHandler);
            n3 = (int)(this.cx + 0.5);
            n2 = (int)(this.cy + 0.5);
            n = (int)(this.cz + 0.5);
        } else {
            this.computeCenter();
            n3 = (int)(this.bx + 0.5);
            n2 = (int)(this.by + 0.5);
            n = (int)(this.bz + 0.5);
        }
        double d3 = 0.0;
        int n4 = 0;
        for (int i = n - 1; i <= n + 1; ++i) {
            if (i < 0 || i >= imageHandler.sizeZ) continue;
            for (int j = n2 - 1; j <= n2 + 1; ++j) {
                if (j < 0 || j >= imageHandler.sizeY) continue;
                for (int k = n3 - 1; k <= n3 + 1; ++k) {
                    if (k < 0 || k >= imageHandler.sizeX || imageInt.getPixelInt(k, j, i) != this.getValue()) continue;
                    d3 += (double)imageHandler.getPixel(k, j, i);
                    ++n4;
                }
            }
        }
        if (n4 > 0) {
            return d3 / (double)n4;
        }
        return 0.0;
    }

    public double getPixMaxValue(ImageHandler imageHandler) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != imageHandler) {
            this.computeMassCenter(imageHandler);
            this.currentQuantifImage = imageHandler;
        }
        return this.pixmax;
    }

    public double getPixMinValue(ImageHandler imageHandler) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != imageHandler) {
            this.computeMassCenter(imageHandler);
            this.currentQuantifImage = imageHandler;
        }
        return this.pixmin;
    }

    public double getStDevPixValue(ImageHandler imageHandler) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != imageHandler) {
            this.computeMassCenter(imageHandler);
            this.currentQuantifImage = imageHandler;
        }
        return this.sigma;
    }

    public ImageInt createSegImageMini(int n, int n2) {
        return this.createSegImageMini(n, n2, n2, n2);
    }

    public ImageInt createSegImageMini(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = this.getXmin() - n2;
        if (n7 < -n2) {
            n7 = -n2;
        }
        if ((n6 = this.getYmin() - n3) < -n3) {
            n6 = -n3;
        }
        if ((n5 = this.getZmin() - n4) < -n4) {
            n5 = -n4;
        }
        int n8 = this.getXmax() - n7 + 1 + n2;
        int n9 = this.getYmax() - n6 + 1 + n3;
        int n10 = this.getZmax() - n5 + 1 + n4;
        this.miniLabelImage = new ImageShort("Object_" + n, n8, n9, n10);
        for (Voxel3D voxel3D : this.getVoxels()) {
            double d;
            double d2;
            double d3 = voxel3D.getX() - (double)n7;
            if (!this.miniLabelImage.contains(d3, d2 = voxel3D.getY() - (double)n6, d = voxel3D.getZ() - (double)n5)) continue;
            this.miniLabelImage.setPixel((int)Math.round(d3), (int)Math.round(d2), (int)Math.round(d), n);
        }
        this.miniLabelImage.offsetX = n7;
        this.miniLabelImage.offsetY = n6;
        this.miniLabelImage.offsetZ = n5;
        this.miniLabelImage.setScale((float)this.getResXY(), (float)this.getResZ(), this.getUnits());
        return this.miniLabelImage;
    }

    public ImageInt createSegImageMini2D(int n, int n2) {
        int n3;
        int n4 = this.getXmin() - n2;
        if (n4 < -n2) {
            n4 = -n2;
        }
        if ((n3 = this.getYmin() - n2) < -n2) {
            n3 = -n2;
        }
        int n5 = this.getXmax() - n4 + 1 + n2;
        int n6 = this.getYmax() - n3 + 1 + n2;
        this.miniLabelImage = new ImageShort("Object_" + n, n5, n6, 1);
        for (Voxel3D voxel3D : this.getVoxels()) {
            double d;
            double d2 = voxel3D.getX() - (double)n4;
            if (!this.miniLabelImage.contains(d2, d = voxel3D.getY() - (double)n3, 0.0)) {
                System.out.println("outside miniseg " + d2 + " " + d);
                continue;
            }
            this.miniLabelImage.setPixel((int)Math.round(d2), (int)Math.round(d), 0, n);
        }
        this.miniLabelImage.offsetX = n4;
        this.miniLabelImage.offsetY = n3;
        this.miniLabelImage.setScale((float)this.getResXY(), (float)this.getResXY(), this.getUnits());
        return this.miniLabelImage;
    }

    public ImageInt createSegImage() {
        return this.createSegImage(0, 0, 0, this.xmax, this.ymax, this.zmax, this.value);
    }

    public ImageInt createSegImage(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        ImageShort imageShort = new ImageShort("Object", n4 - n + 1, n5 - n2 + 1, n6 - n3 + 1);
        for (Voxel3D voxel3D : this.getVoxels()) {
            if (!imageShort.contains(voxel3D.getRoundX() - n, voxel3D.getRoundY() - n2, voxel3D.getRoundZ() - n3)) continue;
            ((ImageInt)imageShort).setPixel(voxel3D.getRoundX() - n, voxel3D.getRoundY() - n2, voxel3D.getRoundZ() - n3, n7);
        }
        return imageShort;
    }

    public abstract ArrayList<Voxel3D> getVoxels();

    public abstract void writeVoxels(String var1);

    public boolean includes(Object3D object3D) {
        if (!this.includesBox(object3D)) {
            return false;
        }
        int n = this.getColoc(object3D);
        return n == object3D.getVolumePixels();
    }

    private KDTreeC getKdtreeContours() {
        if (this.kdtreeContours == null) {
            if (this.contours != null && !this.contours.isEmpty()) {
                this.kdtreeContours = new KDTreeC(3);
                this.kdtreeContours.setScale3(this.resXY, this.resXY, this.resZ);
                for (Voxel3D voxel3D : this.contours) {
                    this.kdtreeContours.add(voxel3D.getArray(), voxel3D);
                }
            } else {
                this.computeContours();
            }
        }
        return this.kdtreeContours;
    }

    public abstract boolean hasOneVoxelColoc(Object3D var1);

    public abstract int getColoc(Object3D var1);

    public static double pcColocSum(Object3D object3D, Object3D object3D2) {
        double d = object3D.getVolumePixels();
        double d2 = object3D2.getVolumePixels();
        double d3 = object3D.getColoc(object3D2);
        return 100.0 * d3 / (d + d2);
    }

    private Object3DVoxels getMorphoObject(int n, float f, float f2, float f3, boolean bl) {
        if (f == 0.0f && f2 == 0.0f && f3 == 0.0f) {
            return new Object3DVoxels(this);
        }
        ImageInt imageInt = this.createSegImageMini(this.value, (int)Math.ceil(f), (int)Math.ceil(f2), (int)Math.ceil(f3));
        ImageInt imageInt2 = null;
        if (f2 != f || f3 == 0.0f) {
            int n2 = 0;
            if (n == 1) {
                n2 = 3;
            } else if (n == 2) {
                n2 = 2;
            } else if (n == 3) {
                n2 = 7;
            } else if (n == 4) {
                n2 = 6;
            }
            imageInt2 = FastFilters3D.filterIntImage(imageInt, n2, f, f2, f3, 0, true);
            imageInt2.setOffset(imageInt);
        } else {
            imageInt2 = BinaryMorpho.binaryMorpho(imageInt, n, f, f3);
            if (imageInt2 != null) {
                imageInt2.replacePixelsValue(255, this.value);
            }
        }
        if (imageInt2 == null) {
            return null;
        }
        Object3DVoxels object3DVoxels = new Object3DVoxels((ImageHandler)imageInt2, this.value);
        object3DVoxels.translate(imageInt2.offsetX, imageInt2.offsetY, imageInt2.offsetZ);
        if (bl) {
            ImageInt imageInt3 = object3DVoxels.createSegImage();
            object3DVoxels.setLabelImage(imageInt3);
        }
        return object3DVoxels;
    }

    public boolean b_closed(float f, float f2, float f3) {
        Object3DVoxels object3DVoxels = this.getClosedObject(f, f2, f3, false);
        MereoObject3D mereoObject3D = new MereoObject3D(this, object3DVoxels);
        return mereoObject3D.Equality();
    }

    public boolean b_open(float f, float f2, float f3) {
        Object3DVoxels object3DVoxels = this.getOpenedObject(f, f2, f3, false);
        MereoObject3D mereoObject3D = new MereoObject3D(this, object3DVoxels);
        return mereoObject3D.Equality();
    }

    public boolean regular(float f, float f2, float f3) {
        if (!this.b_open(f, f2, f3)) {
            return false;
        }
        return this.b_closed(f, f2, f3);
    }

    public Object3DVoxels getDilatedObject(float f, float f2, float f3, boolean bl) {
        return this.getMorphoObject(1, f, f2, f3, bl);
    }

    public Object3DVoxels getErodedObject(float f, float f2, float f3, boolean bl) {
        return this.getMorphoObject(2, f, f2, f3, bl);
    }

    public Object3DVoxels getClosedObject(float f, float f2, float f3, boolean bl) {
        return this.getMorphoObject(3, f, f2, f3, bl);
    }

    public Object3DVoxels getOpenedObject(float f, float f2, float f3, boolean bl) {
        return this.getMorphoObject(4, f, f2, f3, bl);
    }
}

